
package com.workday.staffing;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;


/**
 * The Wrapper element for the Applicant Data Web Service.
 * 
 * <p>Java class for Applicant_Data_WWSType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Applicant_Data_WWSType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Applicant_ID" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Personal_Data" type="{urn:com.workday/bsvc}Personal_Information_DataType" minOccurs="0"/>
 *         &lt;element name="Qualification_Data" type="{urn:com.workday/bsvc}Person_Qualification_DataType" minOccurs="0"/>
 *         &lt;element name="Recruiting_Data" type="{urn:com.workday/bsvc}Recruiting_DataType" minOccurs="0"/>
 *         &lt;element name="Resume_Data" type="{urn:com.workday/bsvc}Applicant_Resume_DataType" minOccurs="0"/>
 *         &lt;element name="Background_Check_Data" type="{urn:com.workday/bsvc}Background_Check_DataType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="External_Integration_ID_Data" type="{urn:com.workday/bsvc}External_Integration_ID_DataType" minOccurs="0"/>
 *         &lt;element name="Document_Field_Result_Data" type="{urn:com.workday/bsvc}Document_Field_Result_DataType" maxOccurs="unbounded" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Applicant_Data_WWSType", propOrder = {
    "applicantID",
    "personalData",
    "qualificationData",
    "recruitingData",
    "resumeData",
    "backgroundCheckData",
    "externalIntegrationIDData",
    "documentFieldResultData"
})
public class ApplicantDataWWSType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Applicant_ID")
    protected String applicantID;
    @XmlElement(name = "Personal_Data")
    protected PersonalInformationDataType personalData;
    @XmlElement(name = "Qualification_Data")
    protected PersonQualificationDataType qualificationData;
    @XmlElement(name = "Recruiting_Data")
    protected RecruitingDataType recruitingData;
    @XmlElement(name = "Resume_Data")
    protected ApplicantResumeDataType resumeData;
    @XmlElement(name = "Background_Check_Data")
    protected List<BackgroundCheckDataType> backgroundCheckData;
    @XmlElement(name = "External_Integration_ID_Data")
    protected ExternalIntegrationIDDataType externalIntegrationIDData;
    @XmlElement(name = "Document_Field_Result_Data")
    protected List<DocumentFieldResultDataType> documentFieldResultData;

    /**
     * Gets the value of the applicantID property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getApplicantID() {
        return applicantID;
    }

    /**
     * Sets the value of the applicantID property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setApplicantID(String value) {
        this.applicantID = value;
    }

    /**
     * Gets the value of the personalData property.
     * 
     * @return
     *     possible object is
     *     {@link PersonalInformationDataType }
     *     
     */
    public PersonalInformationDataType getPersonalData() {
        return personalData;
    }

    /**
     * Sets the value of the personalData property.
     * 
     * @param value
     *     allowed object is
     *     {@link PersonalInformationDataType }
     *     
     */
    public void setPersonalData(PersonalInformationDataType value) {
        this.personalData = value;
    }

    /**
     * Gets the value of the qualificationData property.
     * 
     * @return
     *     possible object is
     *     {@link PersonQualificationDataType }
     *     
     */
    public PersonQualificationDataType getQualificationData() {
        return qualificationData;
    }

    /**
     * Sets the value of the qualificationData property.
     * 
     * @param value
     *     allowed object is
     *     {@link PersonQualificationDataType }
     *     
     */
    public void setQualificationData(PersonQualificationDataType value) {
        this.qualificationData = value;
    }

    /**
     * Gets the value of the recruitingData property.
     * 
     * @return
     *     possible object is
     *     {@link RecruitingDataType }
     *     
     */
    public RecruitingDataType getRecruitingData() {
        return recruitingData;
    }

    /**
     * Sets the value of the recruitingData property.
     * 
     * @param value
     *     allowed object is
     *     {@link RecruitingDataType }
     *     
     */
    public void setRecruitingData(RecruitingDataType value) {
        this.recruitingData = value;
    }

    /**
     * Gets the value of the resumeData property.
     * 
     * @return
     *     possible object is
     *     {@link ApplicantResumeDataType }
     *     
     */
    public ApplicantResumeDataType getResumeData() {
        return resumeData;
    }

    /**
     * Sets the value of the resumeData property.
     * 
     * @param value
     *     allowed object is
     *     {@link ApplicantResumeDataType }
     *     
     */
    public void setResumeData(ApplicantResumeDataType value) {
        this.resumeData = value;
    }

    /**
     * Gets the value of the backgroundCheckData property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the backgroundCheckData property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getBackgroundCheckData().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link BackgroundCheckDataType }
     * 
     * 
     */
    public List<BackgroundCheckDataType> getBackgroundCheckData() {
        if (backgroundCheckData == null) {
            backgroundCheckData = new ArrayList<BackgroundCheckDataType>();
        }
        return this.backgroundCheckData;
    }

    /**
     * Gets the value of the externalIntegrationIDData property.
     * 
     * @return
     *     possible object is
     *     {@link ExternalIntegrationIDDataType }
     *     
     */
    public ExternalIntegrationIDDataType getExternalIntegrationIDData() {
        return externalIntegrationIDData;
    }

    /**
     * Sets the value of the externalIntegrationIDData property.
     * 
     * @param value
     *     allowed object is
     *     {@link ExternalIntegrationIDDataType }
     *     
     */
    public void setExternalIntegrationIDData(ExternalIntegrationIDDataType value) {
        this.externalIntegrationIDData = value;
    }

    /**
     * Gets the value of the documentFieldResultData property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the documentFieldResultData property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getDocumentFieldResultData().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link DocumentFieldResultDataType }
     * 
     * 
     */
    public List<DocumentFieldResultDataType> getDocumentFieldResultData() {
        if (documentFieldResultData == null) {
            documentFieldResultData = new ArrayList<DocumentFieldResultDataType>();
        }
        return this.documentFieldResultData;
    }

    /**
     * Sets the value of the backgroundCheckData property.
     * 
     * @param backgroundCheckData
     *     allowed object is
     *     {@link BackgroundCheckDataType }
     *     
     */
    public void setBackgroundCheckData(List<BackgroundCheckDataType> backgroundCheckData) {
        this.backgroundCheckData = backgroundCheckData;
    }

    /**
     * Sets the value of the documentFieldResultData property.
     * 
     * @param documentFieldResultData
     *     allowed object is
     *     {@link DocumentFieldResultDataType }
     *     
     */
    public void setDocumentFieldResultData(List<DocumentFieldResultDataType> documentFieldResultData) {
        this.documentFieldResultData = documentFieldResultData;
    }

}
