
package com.workday.staffing;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.datatype.XMLGregorianCalendar;


/**
 * Wrapper element for the details of an Add Additional Job for an employee.
 * 
 * <p>Java class for Add_Additional_Job_Event_DataType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Add_Additional_Job_Event_DataType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Position_ID" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Additional_Job_Reason_Reference" type="{urn:com.workday/bsvc}Event_Classification_SubcategoryObjectType" minOccurs="0"/>
 *         &lt;element name="Employee_Type_Reference" type="{urn:com.workday/bsvc}Position_Worker_TypeObjectType" minOccurs="0"/>
 *         &lt;element name="First_Day_of_Work" type="{http://www.w3.org/2001/XMLSchema}date" minOccurs="0"/>
 *         &lt;element name="Probation_Start_Date" type="{http://www.w3.org/2001/XMLSchema}date" minOccurs="0"/>
 *         &lt;element name="Probation_End_Date" type="{http://www.w3.org/2001/XMLSchema}date" minOccurs="0"/>
 *         &lt;element name="End_Employment_Date" type="{http://www.w3.org/2001/XMLSchema}date" minOccurs="0"/>
 *         &lt;element name="Conversion_Position_Start_Date" type="{http://www.w3.org/2001/XMLSchema}date" minOccurs="0"/>
 *         &lt;element name="Position_Details" type="{urn:com.workday/bsvc}Position_Details_Sub_DataType"/>
 *         &lt;element name="Worker_Document_Data" type="{urn:com.workday/bsvc}Worker_Document_for_Staffing_Event_DataType" maxOccurs="unbounded" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Add_Additional_Job_Event_DataType", propOrder = {
    "positionID",
    "additionalJobReasonReference",
    "employeeTypeReference",
    "firstDayOfWork",
    "probationStartDate",
    "probationEndDate",
    "endEmploymentDate",
    "conversionPositionStartDate",
    "positionDetails",
    "workerDocumentData"
})
public class AddAdditionalJobEventDataType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Position_ID")
    protected String positionID;
    @XmlElement(name = "Additional_Job_Reason_Reference")
    protected EventClassificationSubcategoryObjectType additionalJobReasonReference;
    @XmlElement(name = "Employee_Type_Reference")
    protected PositionWorkerTypeObjectType employeeTypeReference;
    @XmlElement(name = "First_Day_of_Work")
    @XmlSchemaType(name = "date")
    protected XMLGregorianCalendar firstDayOfWork;
    @XmlElement(name = "Probation_Start_Date")
    @XmlSchemaType(name = "date")
    protected XMLGregorianCalendar probationStartDate;
    @XmlElement(name = "Probation_End_Date")
    @XmlSchemaType(name = "date")
    protected XMLGregorianCalendar probationEndDate;
    @XmlElement(name = "End_Employment_Date")
    @XmlSchemaType(name = "date")
    protected XMLGregorianCalendar endEmploymentDate;
    @XmlElement(name = "Conversion_Position_Start_Date")
    @XmlSchemaType(name = "date")
    protected XMLGregorianCalendar conversionPositionStartDate;
    @XmlElement(name = "Position_Details", required = true)
    protected PositionDetailsSubDataType positionDetails;
    @XmlElement(name = "Worker_Document_Data")
    protected List<WorkerDocumentForStaffingEventDataType> workerDocumentData;

    /**
     * Gets the value of the positionID property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getPositionID() {
        return positionID;
    }

    /**
     * Sets the value of the positionID property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setPositionID(String value) {
        this.positionID = value;
    }

    /**
     * Gets the value of the additionalJobReasonReference property.
     * 
     * @return
     *     possible object is
     *     {@link EventClassificationSubcategoryObjectType }
     *     
     */
    public EventClassificationSubcategoryObjectType getAdditionalJobReasonReference() {
        return additionalJobReasonReference;
    }

    /**
     * Sets the value of the additionalJobReasonReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link EventClassificationSubcategoryObjectType }
     *     
     */
    public void setAdditionalJobReasonReference(EventClassificationSubcategoryObjectType value) {
        this.additionalJobReasonReference = value;
    }

    /**
     * Gets the value of the employeeTypeReference property.
     * 
     * @return
     *     possible object is
     *     {@link PositionWorkerTypeObjectType }
     *     
     */
    public PositionWorkerTypeObjectType getEmployeeTypeReference() {
        return employeeTypeReference;
    }

    /**
     * Sets the value of the employeeTypeReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link PositionWorkerTypeObjectType }
     *     
     */
    public void setEmployeeTypeReference(PositionWorkerTypeObjectType value) {
        this.employeeTypeReference = value;
    }

    /**
     * Gets the value of the firstDayOfWork property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getFirstDayOfWork() {
        return firstDayOfWork;
    }

    /**
     * Sets the value of the firstDayOfWork property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setFirstDayOfWork(XMLGregorianCalendar value) {
        this.firstDayOfWork = value;
    }

    /**
     * Gets the value of the probationStartDate property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getProbationStartDate() {
        return probationStartDate;
    }

    /**
     * Sets the value of the probationStartDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setProbationStartDate(XMLGregorianCalendar value) {
        this.probationStartDate = value;
    }

    /**
     * Gets the value of the probationEndDate property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getProbationEndDate() {
        return probationEndDate;
    }

    /**
     * Sets the value of the probationEndDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setProbationEndDate(XMLGregorianCalendar value) {
        this.probationEndDate = value;
    }

    /**
     * Gets the value of the endEmploymentDate property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getEndEmploymentDate() {
        return endEmploymentDate;
    }

    /**
     * Sets the value of the endEmploymentDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setEndEmploymentDate(XMLGregorianCalendar value) {
        this.endEmploymentDate = value;
    }

    /**
     * Gets the value of the conversionPositionStartDate property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getConversionPositionStartDate() {
        return conversionPositionStartDate;
    }

    /**
     * Sets the value of the conversionPositionStartDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setConversionPositionStartDate(XMLGregorianCalendar value) {
        this.conversionPositionStartDate = value;
    }

    /**
     * Gets the value of the positionDetails property.
     * 
     * @return
     *     possible object is
     *     {@link PositionDetailsSubDataType }
     *     
     */
    public PositionDetailsSubDataType getPositionDetails() {
        return positionDetails;
    }

    /**
     * Sets the value of the positionDetails property.
     * 
     * @param value
     *     allowed object is
     *     {@link PositionDetailsSubDataType }
     *     
     */
    public void setPositionDetails(PositionDetailsSubDataType value) {
        this.positionDetails = value;
    }

    /**
     * Gets the value of the workerDocumentData property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the workerDocumentData property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getWorkerDocumentData().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link WorkerDocumentForStaffingEventDataType }
     * 
     * 
     */
    public List<WorkerDocumentForStaffingEventDataType> getWorkerDocumentData() {
        if (workerDocumentData == null) {
            workerDocumentData = new ArrayList<WorkerDocumentForStaffingEventDataType>();
        }
        return this.workerDocumentData;
    }

    /**
     * Sets the value of the workerDocumentData property.
     * 
     * @param workerDocumentData
     *     allowed object is
     *     {@link WorkerDocumentForStaffingEventDataType }
     *     
     */
    public void setWorkerDocumentData(List<WorkerDocumentForStaffingEventDataType> workerDocumentData) {
        this.workerDocumentData = workerDocumentData;
    }

}
