
package com.workday.staffing;

import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.datatype.XMLGregorianCalendar;


/**
 * Wrapper Element for the Add Additional Job business process web service and its sub business processes.
 * 
 * <p>Java class for Add_Additional_Job_DataType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Add_Additional_Job_DataType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Employee_Reference" type="{urn:com.workday/bsvc}EmployeeObjectType"/>
 *         &lt;element name="Organization_Reference" type="{urn:com.workday/bsvc}Supervisory_OrganizationObjectType"/>
 *         &lt;choice>
 *           &lt;element name="Position_Reference" type="{urn:com.workday/bsvc}Position_RestrictionsObjectType" minOccurs="0"/>
 *           &lt;element name="Headcount_Reference" type="{urn:com.workday/bsvc}Headcount_RestrictionsObjectType" minOccurs="0"/>
 *           &lt;element name="Job_Requisition_Reference" type="{urn:com.workday/bsvc}Job_RequisitionObjectType" minOccurs="0"/>
 *         &lt;/choice>
 *         &lt;element name="Exclude_from_Headcount" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Add_Additional_Job_Event_Data" type="{urn:com.workday/bsvc}Add_Additional_Job_Event_DataType"/>
 *         &lt;element name="Edit_Assign_Organization_Sub_Process" type="{urn:com.workday/bsvc}Edit_Assign_Position_Organization_Sub_Business_ProcessType" minOccurs="0"/>
 *         &lt;element name="Assign_Matrix_Organization_Sub_Process" type="{urn:com.workday/bsvc}Assign_Matrix_Organization_Sub_Business_ProcessType" minOccurs="0"/>
 *         &lt;element name="Assign_Pay_Group_Sub_Process" type="{urn:com.workday/bsvc}Assign_Pay_Group_Sub_Business_ProcessType" minOccurs="0"/>
 *         &lt;element name="Propose_Compensation_for_Additional_Job_Sub_Process" type="{urn:com.workday/bsvc}Propose_Compensation_For_Employment_Sub_Business_ProcessType" minOccurs="0"/>
 *         &lt;element name="Request_Budget_Approval_Sub_Process" type="{urn:com.workday/bsvc}Request_Budget_Approval_Sub_Business_ProcessType" minOccurs="0"/>
 *         &lt;element name="Check_Position_Budget_Sub_Process" type="{urn:com.workday/bsvc}Check_Position_Budget_Sub_Business_ProcessType" minOccurs="0"/>
 *         &lt;element name="Assign_Costing_Allocation_Sub_Process" type="{urn:com.workday/bsvc}Assign_Costing_Allocation_Sub_Business_ProcessType" minOccurs="0"/>
 *         &lt;element name="Switch_Primary_Job_Sub_Process" type="{urn:com.workday/bsvc}Switch_Primary_Job_Sub_ProcessType" minOccurs="0"/>
 *         &lt;element name="Add_Academic_Appointment_Sub_Process" type="{urn:com.workday/bsvc}Add_Academic_Appointment_Sub_Business_ProcessType" minOccurs="0"/>
 *       &lt;/sequence>
 *       &lt;attribute name="Start_Date" type="{http://www.w3.org/2001/XMLSchema}date" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Add_Additional_Job_DataType", propOrder = {
    "employeeReference",
    "organizationReference",
    "positionReference",
    "headcountReference",
    "jobRequisitionReference",
    "excludeFromHeadcount",
    "addAdditionalJobEventData",
    "editAssignOrganizationSubProcess",
    "assignMatrixOrganizationSubProcess",
    "assignPayGroupSubProcess",
    "proposeCompensationForAdditionalJobSubProcess",
    "requestBudgetApprovalSubProcess",
    "checkPositionBudgetSubProcess",
    "assignCostingAllocationSubProcess",
    "switchPrimaryJobSubProcess",
    "addAcademicAppointmentSubProcess"
})
public class AddAdditionalJobDataType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Employee_Reference", required = true)
    protected EmployeeObjectType employeeReference;
    @XmlElement(name = "Organization_Reference", required = true)
    protected SupervisoryOrganizationObjectType organizationReference;
    @XmlElement(name = "Position_Reference")
    protected PositionRestrictionsObjectType positionReference;
    @XmlElement(name = "Headcount_Reference")
    protected HeadcountRestrictionsObjectType headcountReference;
    @XmlElement(name = "Job_Requisition_Reference")
    protected JobRequisitionObjectType jobRequisitionReference;
    @XmlElement(name = "Exclude_from_Headcount")
    protected Boolean excludeFromHeadcount;
    @XmlElement(name = "Add_Additional_Job_Event_Data", required = true)
    protected AddAdditionalJobEventDataType addAdditionalJobEventData;
    @XmlElement(name = "Edit_Assign_Organization_Sub_Process")
    protected EditAssignPositionOrganizationSubBusinessProcessType editAssignOrganizationSubProcess;
    @XmlElement(name = "Assign_Matrix_Organization_Sub_Process")
    protected AssignMatrixOrganizationSubBusinessProcessType assignMatrixOrganizationSubProcess;
    @XmlElement(name = "Assign_Pay_Group_Sub_Process")
    protected AssignPayGroupSubBusinessProcessType assignPayGroupSubProcess;
    @XmlElement(name = "Propose_Compensation_for_Additional_Job_Sub_Process")
    protected ProposeCompensationForEmploymentSubBusinessProcessType proposeCompensationForAdditionalJobSubProcess;
    @XmlElement(name = "Request_Budget_Approval_Sub_Process")
    protected RequestBudgetApprovalSubBusinessProcessType requestBudgetApprovalSubProcess;
    @XmlElement(name = "Check_Position_Budget_Sub_Process")
    protected CheckPositionBudgetSubBusinessProcessType checkPositionBudgetSubProcess;
    @XmlElement(name = "Assign_Costing_Allocation_Sub_Process")
    protected AssignCostingAllocationSubBusinessProcessType assignCostingAllocationSubProcess;
    @XmlElement(name = "Switch_Primary_Job_Sub_Process")
    protected SwitchPrimaryJobSubProcessType switchPrimaryJobSubProcess;
    @XmlElement(name = "Add_Academic_Appointment_Sub_Process")
    protected AddAcademicAppointmentSubBusinessProcessType addAcademicAppointmentSubProcess;
    @XmlAttribute(name = "Start_Date", namespace = "urn:com.workday/bsvc")
    @XmlSchemaType(name = "date")
    protected XMLGregorianCalendar startDate;

    /**
     * Gets the value of the employeeReference property.
     * 
     * @return
     *     possible object is
     *     {@link EmployeeObjectType }
     *     
     */
    public EmployeeObjectType getEmployeeReference() {
        return employeeReference;
    }

    /**
     * Sets the value of the employeeReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link EmployeeObjectType }
     *     
     */
    public void setEmployeeReference(EmployeeObjectType value) {
        this.employeeReference = value;
    }

    /**
     * Gets the value of the organizationReference property.
     * 
     * @return
     *     possible object is
     *     {@link SupervisoryOrganizationObjectType }
     *     
     */
    public SupervisoryOrganizationObjectType getOrganizationReference() {
        return organizationReference;
    }

    /**
     * Sets the value of the organizationReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link SupervisoryOrganizationObjectType }
     *     
     */
    public void setOrganizationReference(SupervisoryOrganizationObjectType value) {
        this.organizationReference = value;
    }

    /**
     * Gets the value of the positionReference property.
     * 
     * @return
     *     possible object is
     *     {@link PositionRestrictionsObjectType }
     *     
     */
    public PositionRestrictionsObjectType getPositionReference() {
        return positionReference;
    }

    /**
     * Sets the value of the positionReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link PositionRestrictionsObjectType }
     *     
     */
    public void setPositionReference(PositionRestrictionsObjectType value) {
        this.positionReference = value;
    }

    /**
     * Gets the value of the headcountReference property.
     * 
     * @return
     *     possible object is
     *     {@link HeadcountRestrictionsObjectType }
     *     
     */
    public HeadcountRestrictionsObjectType getHeadcountReference() {
        return headcountReference;
    }

    /**
     * Sets the value of the headcountReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link HeadcountRestrictionsObjectType }
     *     
     */
    public void setHeadcountReference(HeadcountRestrictionsObjectType value) {
        this.headcountReference = value;
    }

    /**
     * Gets the value of the jobRequisitionReference property.
     * 
     * @return
     *     possible object is
     *     {@link JobRequisitionObjectType }
     *     
     */
    public JobRequisitionObjectType getJobRequisitionReference() {
        return jobRequisitionReference;
    }

    /**
     * Sets the value of the jobRequisitionReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link JobRequisitionObjectType }
     *     
     */
    public void setJobRequisitionReference(JobRequisitionObjectType value) {
        this.jobRequisitionReference = value;
    }

    /**
     * Gets the value of the excludeFromHeadcount property.
     * This getter has been renamed from isExcludeFromHeadcount() to getExcludeFromHeadcount() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getExcludeFromHeadcount() {
        return excludeFromHeadcount;
    }

    /**
     * Sets the value of the excludeFromHeadcount property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setExcludeFromHeadcount(Boolean value) {
        this.excludeFromHeadcount = value;
    }

    /**
     * Gets the value of the addAdditionalJobEventData property.
     * 
     * @return
     *     possible object is
     *     {@link AddAdditionalJobEventDataType }
     *     
     */
    public AddAdditionalJobEventDataType getAddAdditionalJobEventData() {
        return addAdditionalJobEventData;
    }

    /**
     * Sets the value of the addAdditionalJobEventData property.
     * 
     * @param value
     *     allowed object is
     *     {@link AddAdditionalJobEventDataType }
     *     
     */
    public void setAddAdditionalJobEventData(AddAdditionalJobEventDataType value) {
        this.addAdditionalJobEventData = value;
    }

    /**
     * Gets the value of the editAssignOrganizationSubProcess property.
     * 
     * @return
     *     possible object is
     *     {@link EditAssignPositionOrganizationSubBusinessProcessType }
     *     
     */
    public EditAssignPositionOrganizationSubBusinessProcessType getEditAssignOrganizationSubProcess() {
        return editAssignOrganizationSubProcess;
    }

    /**
     * Sets the value of the editAssignOrganizationSubProcess property.
     * 
     * @param value
     *     allowed object is
     *     {@link EditAssignPositionOrganizationSubBusinessProcessType }
     *     
     */
    public void setEditAssignOrganizationSubProcess(EditAssignPositionOrganizationSubBusinessProcessType value) {
        this.editAssignOrganizationSubProcess = value;
    }

    /**
     * Gets the value of the assignMatrixOrganizationSubProcess property.
     * 
     * @return
     *     possible object is
     *     {@link AssignMatrixOrganizationSubBusinessProcessType }
     *     
     */
    public AssignMatrixOrganizationSubBusinessProcessType getAssignMatrixOrganizationSubProcess() {
        return assignMatrixOrganizationSubProcess;
    }

    /**
     * Sets the value of the assignMatrixOrganizationSubProcess property.
     * 
     * @param value
     *     allowed object is
     *     {@link AssignMatrixOrganizationSubBusinessProcessType }
     *     
     */
    public void setAssignMatrixOrganizationSubProcess(AssignMatrixOrganizationSubBusinessProcessType value) {
        this.assignMatrixOrganizationSubProcess = value;
    }

    /**
     * Gets the value of the assignPayGroupSubProcess property.
     * 
     * @return
     *     possible object is
     *     {@link AssignPayGroupSubBusinessProcessType }
     *     
     */
    public AssignPayGroupSubBusinessProcessType getAssignPayGroupSubProcess() {
        return assignPayGroupSubProcess;
    }

    /**
     * Sets the value of the assignPayGroupSubProcess property.
     * 
     * @param value
     *     allowed object is
     *     {@link AssignPayGroupSubBusinessProcessType }
     *     
     */
    public void setAssignPayGroupSubProcess(AssignPayGroupSubBusinessProcessType value) {
        this.assignPayGroupSubProcess = value;
    }

    /**
     * Gets the value of the proposeCompensationForAdditionalJobSubProcess property.
     * 
     * @return
     *     possible object is
     *     {@link ProposeCompensationForEmploymentSubBusinessProcessType }
     *     
     */
    public ProposeCompensationForEmploymentSubBusinessProcessType getProposeCompensationForAdditionalJobSubProcess() {
        return proposeCompensationForAdditionalJobSubProcess;
    }

    /**
     * Sets the value of the proposeCompensationForAdditionalJobSubProcess property.
     * 
     * @param value
     *     allowed object is
     *     {@link ProposeCompensationForEmploymentSubBusinessProcessType }
     *     
     */
    public void setProposeCompensationForAdditionalJobSubProcess(ProposeCompensationForEmploymentSubBusinessProcessType value) {
        this.proposeCompensationForAdditionalJobSubProcess = value;
    }

    /**
     * Gets the value of the requestBudgetApprovalSubProcess property.
     * 
     * @return
     *     possible object is
     *     {@link RequestBudgetApprovalSubBusinessProcessType }
     *     
     */
    public RequestBudgetApprovalSubBusinessProcessType getRequestBudgetApprovalSubProcess() {
        return requestBudgetApprovalSubProcess;
    }

    /**
     * Sets the value of the requestBudgetApprovalSubProcess property.
     * 
     * @param value
     *     allowed object is
     *     {@link RequestBudgetApprovalSubBusinessProcessType }
     *     
     */
    public void setRequestBudgetApprovalSubProcess(RequestBudgetApprovalSubBusinessProcessType value) {
        this.requestBudgetApprovalSubProcess = value;
    }

    /**
     * Gets the value of the checkPositionBudgetSubProcess property.
     * 
     * @return
     *     possible object is
     *     {@link CheckPositionBudgetSubBusinessProcessType }
     *     
     */
    public CheckPositionBudgetSubBusinessProcessType getCheckPositionBudgetSubProcess() {
        return checkPositionBudgetSubProcess;
    }

    /**
     * Sets the value of the checkPositionBudgetSubProcess property.
     * 
     * @param value
     *     allowed object is
     *     {@link CheckPositionBudgetSubBusinessProcessType }
     *     
     */
    public void setCheckPositionBudgetSubProcess(CheckPositionBudgetSubBusinessProcessType value) {
        this.checkPositionBudgetSubProcess = value;
    }

    /**
     * Gets the value of the assignCostingAllocationSubProcess property.
     * 
     * @return
     *     possible object is
     *     {@link AssignCostingAllocationSubBusinessProcessType }
     *     
     */
    public AssignCostingAllocationSubBusinessProcessType getAssignCostingAllocationSubProcess() {
        return assignCostingAllocationSubProcess;
    }

    /**
     * Sets the value of the assignCostingAllocationSubProcess property.
     * 
     * @param value
     *     allowed object is
     *     {@link AssignCostingAllocationSubBusinessProcessType }
     *     
     */
    public void setAssignCostingAllocationSubProcess(AssignCostingAllocationSubBusinessProcessType value) {
        this.assignCostingAllocationSubProcess = value;
    }

    /**
     * Gets the value of the switchPrimaryJobSubProcess property.
     * 
     * @return
     *     possible object is
     *     {@link SwitchPrimaryJobSubProcessType }
     *     
     */
    public SwitchPrimaryJobSubProcessType getSwitchPrimaryJobSubProcess() {
        return switchPrimaryJobSubProcess;
    }

    /**
     * Sets the value of the switchPrimaryJobSubProcess property.
     * 
     * @param value
     *     allowed object is
     *     {@link SwitchPrimaryJobSubProcessType }
     *     
     */
    public void setSwitchPrimaryJobSubProcess(SwitchPrimaryJobSubProcessType value) {
        this.switchPrimaryJobSubProcess = value;
    }

    /**
     * Gets the value of the addAcademicAppointmentSubProcess property.
     * 
     * @return
     *     possible object is
     *     {@link AddAcademicAppointmentSubBusinessProcessType }
     *     
     */
    public AddAcademicAppointmentSubBusinessProcessType getAddAcademicAppointmentSubProcess() {
        return addAcademicAppointmentSubProcess;
    }

    /**
     * Sets the value of the addAcademicAppointmentSubProcess property.
     * 
     * @param value
     *     allowed object is
     *     {@link AddAcademicAppointmentSubBusinessProcessType }
     *     
     */
    public void setAddAcademicAppointmentSubProcess(AddAcademicAppointmentSubBusinessProcessType value) {
        this.addAcademicAppointmentSubProcess = value;
    }

    /**
     * Gets the value of the startDate property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getStartDate() {
        return startDate;
    }

    /**
     * Sets the value of the startDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setStartDate(XMLGregorianCalendar value) {
        this.startDate = value;
    }

}
