/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.workday.professionalservices.process;

import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.filter.Filter;
import org.mule.modules.workday.professionalservices.adapters.ProfessionalModuleConnectionIdentifierAdapter;
import org.mule.modules.workday.professionalservices.connection.ConnectionManager;
import org.mule.modules.workday.professionalservices.connection.UnableToAcquireConnectionException;
import org.mule.modules.workday.professionalservices.connection.UnableToReleaseConnectionException;
import org.mule.modules.workday.professionalservices.connectivity.ProfessionalModuleConnectionKey;
import org.mule.modules.workday.professionalservices.process.ProcessCallback;
import org.mule.modules.workday.professionalservices.process.ProcessInterceptor;
import org.mule.modules.workday.professionalservices.processors.AbstractConnectedProcessor;
import org.mule.modules.workday.professionalservices.processors.AbstractExpressionEvaluator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfessionalModuleManagedConnectionProcessInterceptor<T>
extends AbstractExpressionEvaluator
implements ProcessInterceptor<T, ProfessionalModuleConnectionIdentifierAdapter> {
    private static Logger logger = LoggerFactory.getLogger(ProfessionalModuleManagedConnectionProcessInterceptor.class);
    private final ConnectionManager<ProfessionalModuleConnectionKey, ProfessionalModuleConnectionIdentifierAdapter> connectionManager;
    private final MuleContext muleContext;
    private final ProcessInterceptor<T, ProfessionalModuleConnectionIdentifierAdapter> next;

    public ProfessionalModuleManagedConnectionProcessInterceptor(ProcessInterceptor<T, ProfessionalModuleConnectionIdentifierAdapter> next, ConnectionManager<ProfessionalModuleConnectionKey, ProfessionalModuleConnectionIdentifierAdapter> connectionManager, MuleContext muleContext) {
        this.next = next;
        this.connectionManager = connectionManager;
        this.muleContext = muleContext;
    }

    @Override
    public T execute(ProcessCallback<T, ProfessionalModuleConnectionIdentifierAdapter> processCallback, ProfessionalModuleConnectionIdentifierAdapter object, MessageProcessor messageProcessor, MuleEvent event) throws Exception {
        String _transformedProfessionalServicesAutomationUser;
        ProfessionalModuleConnectionIdentifierAdapter connection = null;
        ProfessionalModuleConnectionKey key = null;
        if (messageProcessor != null && messageProcessor instanceof AbstractConnectedProcessor && ((AbstractConnectedProcessor)messageProcessor).getProfessionalServicesAutomationUser() != null) {
            _transformedProfessionalServicesAutomationUser = (String)this.evaluateAndTransform(this.muleContext, event, AbstractConnectedProcessor.class.getDeclaredField("_professionalServicesAutomationUserType").getGenericType(), null, ((AbstractConnectedProcessor)messageProcessor).getProfessionalServicesAutomationUser());
            if (_transformedProfessionalServicesAutomationUser == null) {
                throw new UnableToAcquireConnectionException("Parameter professionalServicesAutomationUser in method connect can't be null because is not @Optional");
            }
            String _transformedProfessionalServicesAutomationPassword = (String)this.evaluateAndTransform(this.muleContext, event, AbstractConnectedProcessor.class.getDeclaredField("_professionalServicesAutomationPasswordType").getGenericType(), null, ((AbstractConnectedProcessor)messageProcessor).getProfessionalServicesAutomationPassword());
            if (_transformedProfessionalServicesAutomationPassword == null) {
                throw new UnableToAcquireConnectionException("Parameter professionalServicesAutomationPassword in method connect can't be null because is not @Optional");
            }
            String _transformedProfessionalServicesAutomationEndpoint = (String)this.evaluateAndTransform(this.muleContext, event, AbstractConnectedProcessor.class.getDeclaredField("_professionalServicesAutomationEndpointType").getGenericType(), null, ((AbstractConnectedProcessor)messageProcessor).getProfessionalServicesAutomationEndpoint());
            if (_transformedProfessionalServicesAutomationEndpoint == null) {
                throw new UnableToAcquireConnectionException("Parameter professionalServicesAutomationEndpoint in method connect can't be null because is not @Optional");
            }
            String _transformedProfessionalServicesAutomationWsdlLocation = (String)this.evaluateAndTransform(this.muleContext, event, AbstractConnectedProcessor.class.getDeclaredField("_professionalServicesAutomationWsdlLocationType").getGenericType(), null, ((AbstractConnectedProcessor)messageProcessor).getProfessionalServicesAutomationWsdlLocation());
            key = new ProfessionalModuleConnectionKey(_transformedProfessionalServicesAutomationUser, _transformedProfessionalServicesAutomationPassword, _transformedProfessionalServicesAutomationEndpoint, _transformedProfessionalServicesAutomationWsdlLocation);
        } else {
            key = this.connectionManager.getDefaultConnectionKey();
        }
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Attempting to acquire connection using " + key.toString());
            }
            if ((connection = this.connectionManager.acquireConnection(key)) == null) {
                throw new UnableToAcquireConnectionException();
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Connection has been acquired with [id=" + connection.getConnectionIdentifier() + "]");
            }
            _transformedProfessionalServicesAutomationUser = this.next.execute(processCallback, connection, messageProcessor, event);
            return (T)_transformedProfessionalServicesAutomationUser;
        }
        catch (Exception e) {
            if (processCallback.getManagedExceptions() != null) {
                for (Class exceptionClass : processCallback.getManagedExceptions()) {
                    if (!exceptionClass.isInstance(e)) continue;
                    if (logger.isDebugEnabled()) {
                        logger.debug("An exception ( " + exceptionClass.getName() + ") has been thrown. Destroying the connection with [id=" + connection.getConnectionIdentifier() + "]");
                    }
                    try {
                        if (connection == null) continue;
                        this.connectionManager.destroyConnection(key, connection);
                        connection = null;
                    }
                    catch (Exception innerException) {
                        logger.error(innerException.getMessage(), (Throwable)innerException);
                    }
                }
            }
            throw e;
        }
        finally {
            try {
                if (connection != null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Releasing the connection back into the pool [id=" + connection.getConnectionIdentifier() + "]");
                    }
                    this.connectionManager.releaseConnection(key, connection);
                }
            }
            catch (Exception e) {
                throw new UnableToReleaseConnectionException(e);
            }
        }
    }

    @Override
    public T execute(ProcessCallback<T, ProfessionalModuleConnectionIdentifierAdapter> processCallback, ProfessionalModuleConnectionIdentifierAdapter object, Filter filter, MuleMessage message) throws Exception {
        throw new UnsupportedOperationException();
    }
}

