
package org.mule.modules.workday.professionalservices.connectivity;

import javax.annotation.Generated;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.modules.workday.professionalservices.adapters.ProfessionalModuleConnectionIdentifierAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated(value = "Mule DevKit Version 3.4.3", date = "2014-12-12T07:03:20-03:00", comments = "Build 3.4.3.1620.30ea288")
public class ProfessionalModuleConnectionFactory implements KeyedPoolableObjectFactory
{

    private static Logger logger = LoggerFactory.getLogger(ProfessionalModuleConnectionFactory.class);
    private ProfessionalModuleConnectionManager connectionManager;

    public ProfessionalModuleConnectionFactory(ProfessionalModuleConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    public Object makeObject(Object key)
        throws Exception
    {
        if (!(key instanceof ProfessionalModuleConnectionKey)) {
            if (key == null) {
                logger.warn("Connection key is null");
            } else {
                logger.warn("Cannot cast key of type ".concat(key.getClass().getName().concat(" to ").concat("org.mule.modules.workday.professionalservices.connectivity.ProfessionalModuleConnectionKey")));
            }
            throw new RuntimeException("Invalid key type ".concat(key.getClass().getName()));
        }
        ProfessionalModuleConnectionIdentifierAdapter connector = new ProfessionalModuleConnectionIdentifierAdapter();
        if (connector instanceof Initialisable) {
            ((Initialisable) connector).initialise();
        }
        if (connector instanceof MuleContextAware) {
            ((MuleContextAware) connector).setMuleContext(connectionManager.getMuleContext());
        }
        if (connector instanceof Startable) {
            ((Startable) connector).start();
        }
        if (!connector.validateConnection()) {
            connector.connect(((ProfessionalModuleConnectionKey) key).getProfessionalServicesAutomationUser(), ((ProfessionalModuleConnectionKey) key).getProfessionalServicesAutomationPassword(), ((ProfessionalModuleConnectionKey) key).getProfessionalServicesAutomationEndpoint(), ((ProfessionalModuleConnectionKey) key).getProfessionalServicesAutomationWsdlLocation());
        }
        return connector;
    }

    public void destroyObject(Object key, Object obj)
        throws Exception
    {
        if (!(key instanceof ProfessionalModuleConnectionKey)) {
            if (key == null) {
                logger.warn("Connection key is null");
            } else {
                logger.warn("Cannot cast key of type ".concat(key.getClass().getName().concat(" to ").concat("org.mule.modules.workday.professionalservices.connectivity.ProfessionalModuleConnectionKey")));
            }
            throw new RuntimeException("Invalid key type ".concat(key.getClass().getName()));
        }
        if (!(obj instanceof ProfessionalModuleConnectionIdentifierAdapter)) {
            if (obj == null) {
                logger.warn("Connector is null");
            } else {
                logger.warn("Cannot cast connector of type ".concat(obj.getClass().getName().concat(" to ").concat("org.mule.modules.workday.professionalservices.adapters.ProfessionalModuleConnectionIdentifierAdapter")));
            }
            throw new RuntimeException("Invalid connector type ".concat(obj.getClass().getName()));
        }
        try {
            ((ProfessionalModuleConnectionIdentifierAdapter) obj).disconnect();
        } catch (Exception e) {
            throw e;
        } finally {
            if (((ProfessionalModuleConnectionIdentifierAdapter) obj) instanceof Stoppable) {
                ((Stoppable) obj).stop();
            }
            if (((ProfessionalModuleConnectionIdentifierAdapter) obj) instanceof Disposable) {
                ((Disposable) obj).dispose();
            }
        }
    }

    public boolean validateObject(Object key, Object obj) {
        if (!(obj instanceof ProfessionalModuleConnectionIdentifierAdapter)) {
            if (obj == null) {
                logger.warn("Connector is null");
            } else {
                logger.warn("Cannot cast connector of type ".concat(obj.getClass().getName().concat(" to ").concat("org.mule.modules.workday.professionalservices.adapters.ProfessionalModuleConnectionIdentifierAdapter")));
            }
            throw new RuntimeException("Invalid connector type ".concat(obj.getClass().getName()));
        }
        try {
            return ((ProfessionalModuleConnectionIdentifierAdapter) obj).validateConnection();
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            return false;
        }
    }

    public void activateObject(Object key, Object obj)
        throws Exception
    {
        if (!(key instanceof ProfessionalModuleConnectionKey)) {
            throw new RuntimeException("Invalid key type");
        }
        if (!(obj instanceof ProfessionalModuleConnectionIdentifierAdapter)) {
            throw new RuntimeException("Invalid connector type");
        }
        try {
            if (!((ProfessionalModuleConnectionIdentifierAdapter) obj).validateConnection()) {
                ((ProfessionalModuleConnectionIdentifierAdapter) obj).connect(((ProfessionalModuleConnectionKey) key).getProfessionalServicesAutomationUser(), ((ProfessionalModuleConnectionKey) key).getProfessionalServicesAutomationPassword(), ((ProfessionalModuleConnectionKey) key).getProfessionalServicesAutomationEndpoint(), ((ProfessionalModuleConnectionKey) key).getProfessionalServicesAutomationWsdlLocation());
            }
        } catch (Exception e) {
            throw e;
        }
    }

    public void passivateObject(Object key, Object obj)
        throws Exception
    {
    }

}
