/**
 * (c) 2003-2014 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master
 * Subscription Agreement (or other Terms of Service) separately entered
 * into between you and MuleSoft. If such an agreement is not in
 * place, you may not use the software.
 */

package org.mule.modules.workday.professionalservices;

import javax.validation.constraints.NotNull;
import javax.xml.ws.Service;

import org.mule.modules.workday.api.AbstractCxfWorkdayClient;

import com.workday.professionalservices.ExpenseReportAddUpdateType;
import com.workday.professionalservices.ExpenseReportCancelType;
import com.workday.professionalservices.ProfessionalServicesAutomationPort;
import com.workday.professionalservices.ProfessionalServicesAutomationService;

public class CxfProfessionalServicesClient extends AbstractCxfWorkdayClient<ProfessionalServicesAutomationPort> implements ProfessionalServicesAutomationPort {

    public CxfProfessionalServicesClient(@NotNull String username, @NotNull String password, @NotNull String endpoint, @NotNull String wsdlLocation) {
        super(username, password, endpoint, wsdlLocation);
    }

    @Override
    protected Class<? extends Service> serviceType() {
        return ProfessionalServicesAutomationService.class;
    }

    @Override
    protected Class<ProfessionalServicesAutomationPort> portType() {
        return ProfessionalServicesAutomationPort.class;
    }

    @Override
    public void cancelExpenseReportOld(ExpenseReportCancelType body) {
        getConnection().cancelExpenseReportOld(body);
    }

    @Override
    public void addUpdateExpenseReport(ExpenseReportAddUpdateType body) {
        getConnection().addUpdateExpenseReport(body);
    }


}
