
package com.workday.professionalservices;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.datatype.XMLGregorianCalendar;


/**
 * Encapsulating element containing all Expense Report Line data.
 * 
 * <p>Java class for Expense_Report_Line_DataType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Expense_Report_Line_DataType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Expense_Report_Line_Date" type="{http://www.w3.org/2001/XMLSchema}date"/>
 *         &lt;element name="Expense_Item_Reference" type="{urn:com.workday/bsvc}Expense_Item_ReferenceType" maxOccurs="unbounded"/>
 *         &lt;element name="Quantity">
 *           &lt;simpleType>
 *             &lt;restriction base="{http://www.w3.org/2001/XMLSchema}decimal">
 *               &lt;totalDigits value="22"/>
 *               &lt;fractionDigits value="2"/>
 *             &lt;/restriction>
 *           &lt;/simpleType>
 *         &lt;/element>
 *         &lt;element name="Amount">
 *           &lt;simpleType>
 *             &lt;restriction base="{http://www.w3.org/2001/XMLSchema}decimal">
 *               &lt;totalDigits value="26"/>
 *               &lt;fractionDigits value="6"/>
 *             &lt;/restriction>
 *           &lt;/simpleType>
 *         &lt;/element>
 *         &lt;element name="Transaction_Currency_Reference" type="{urn:com.workday/bsvc}Currency_Reference_DataType"/>
 *         &lt;element name="Currency_Rate" minOccurs="0">
 *           &lt;simpleType>
 *             &lt;restriction base="{http://www.w3.org/2001/XMLSchema}decimal">
 *               &lt;totalDigits value="21"/>
 *               &lt;fractionDigits value="6"/>
 *             &lt;/restriction>
 *           &lt;/simpleType>
 *         &lt;/element>
 *         &lt;element name="Converted_Amount" minOccurs="0">
 *           &lt;simpleType>
 *             &lt;restriction base="{http://www.w3.org/2001/XMLSchema}decimal">
 *               &lt;totalDigits value="26"/>
 *               &lt;fractionDigits value="6"/>
 *             &lt;/restriction>
 *           &lt;/simpleType>
 *         &lt;/element>
 *         &lt;element name="Total_Amount" minOccurs="0">
 *           &lt;simpleType>
 *             &lt;restriction base="{http://www.w3.org/2001/XMLSchema}decimal">
 *               &lt;totalDigits value="26"/>
 *               &lt;fractionDigits value="6"/>
 *             &lt;/restriction>
 *           &lt;/simpleType>
 *         &lt;/element>
 *         &lt;element name="Receipt_Included" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Billable" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Expense_Line_Description" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Work_Tag_for_Business_Document_Line_Reference" type="{urn:com.workday/bsvc}Worktag_for_Business_Document_Line_ReferenceType" maxOccurs="unbounded" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Expense_Report_Line_DataType", propOrder = {
    "expenseReportLineDate",
    "expenseItemReference",
    "quantity",
    "amount",
    "transactionCurrencyReference",
    "currencyRate",
    "convertedAmount",
    "totalAmount",
    "receiptIncluded",
    "billable",
    "expenseLineDescription",
    "workTagForBusinessDocumentLineReference"
})
public class ExpenseReportLineDataType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Expense_Report_Line_Date", required = true)
    @XmlSchemaType(name = "date")
    protected XMLGregorianCalendar expenseReportLineDate;
    @XmlElement(name = "Expense_Item_Reference", required = true)
    protected List<ExpenseItemReferenceType> expenseItemReference;
    @XmlElement(name = "Quantity", required = true)
    protected BigDecimal quantity;
    @XmlElement(name = "Amount", required = true)
    protected BigDecimal amount;
    @XmlElement(name = "Transaction_Currency_Reference", required = true)
    protected CurrencyReferenceDataType transactionCurrencyReference;
    @XmlElement(name = "Currency_Rate")
    protected BigDecimal currencyRate;
    @XmlElement(name = "Converted_Amount")
    protected BigDecimal convertedAmount;
    @XmlElement(name = "Total_Amount")
    protected BigDecimal totalAmount;
    @XmlElement(name = "Receipt_Included")
    protected Boolean receiptIncluded;
    @XmlElement(name = "Billable")
    protected Boolean billable;
    @XmlElement(name = "Expense_Line_Description")
    protected String expenseLineDescription;
    @XmlElement(name = "Work_Tag_for_Business_Document_Line_Reference")
    protected List<WorktagForBusinessDocumentLineReferenceType> workTagForBusinessDocumentLineReference;

    /**
     * Gets the value of the expenseReportLineDate property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getExpenseReportLineDate() {
        return expenseReportLineDate;
    }

    /**
     * Sets the value of the expenseReportLineDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setExpenseReportLineDate(XMLGregorianCalendar value) {
        this.expenseReportLineDate = value;
    }

    /**
     * Gets the value of the expenseItemReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the expenseItemReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExpenseItemReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ExpenseItemReferenceType }
     * 
     * 
     */
    public List<ExpenseItemReferenceType> getExpenseItemReference() {
        if (expenseItemReference == null) {
            expenseItemReference = new ArrayList<ExpenseItemReferenceType>();
        }
        return this.expenseItemReference;
    }

    /**
     * Gets the value of the quantity property.
     * 
     * @return
     *     possible object is
     *     {@link BigDecimal }
     *     
     */
    public BigDecimal getQuantity() {
        return quantity;
    }

    /**
     * Sets the value of the quantity property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigDecimal }
     *     
     */
    public void setQuantity(BigDecimal value) {
        this.quantity = value;
    }

    /**
     * Gets the value of the amount property.
     * 
     * @return
     *     possible object is
     *     {@link BigDecimal }
     *     
     */
    public BigDecimal getAmount() {
        return amount;
    }

    /**
     * Sets the value of the amount property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigDecimal }
     *     
     */
    public void setAmount(BigDecimal value) {
        this.amount = value;
    }

    /**
     * Gets the value of the transactionCurrencyReference property.
     * 
     * @return
     *     possible object is
     *     {@link CurrencyReferenceDataType }
     *     
     */
    public CurrencyReferenceDataType getTransactionCurrencyReference() {
        return transactionCurrencyReference;
    }

    /**
     * Sets the value of the transactionCurrencyReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link CurrencyReferenceDataType }
     *     
     */
    public void setTransactionCurrencyReference(CurrencyReferenceDataType value) {
        this.transactionCurrencyReference = value;
    }

    /**
     * Gets the value of the currencyRate property.
     * 
     * @return
     *     possible object is
     *     {@link BigDecimal }
     *     
     */
    public BigDecimal getCurrencyRate() {
        return currencyRate;
    }

    /**
     * Sets the value of the currencyRate property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigDecimal }
     *     
     */
    public void setCurrencyRate(BigDecimal value) {
        this.currencyRate = value;
    }

    /**
     * Gets the value of the convertedAmount property.
     * 
     * @return
     *     possible object is
     *     {@link BigDecimal }
     *     
     */
    public BigDecimal getConvertedAmount() {
        return convertedAmount;
    }

    /**
     * Sets the value of the convertedAmount property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigDecimal }
     *     
     */
    public void setConvertedAmount(BigDecimal value) {
        this.convertedAmount = value;
    }

    /**
     * Gets the value of the totalAmount property.
     * 
     * @return
     *     possible object is
     *     {@link BigDecimal }
     *     
     */
    public BigDecimal getTotalAmount() {
        return totalAmount;
    }

    /**
     * Sets the value of the totalAmount property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigDecimal }
     *     
     */
    public void setTotalAmount(BigDecimal value) {
        this.totalAmount = value;
    }

    /**
     * Gets the value of the receiptIncluded property.
     * This getter has been renamed from isReceiptIncluded() to getReceiptIncluded() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getReceiptIncluded() {
        return receiptIncluded;
    }

    /**
     * Sets the value of the receiptIncluded property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setReceiptIncluded(Boolean value) {
        this.receiptIncluded = value;
    }

    /**
     * Gets the value of the billable property.
     * This getter has been renamed from isBillable() to getBillable() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getBillable() {
        return billable;
    }

    /**
     * Sets the value of the billable property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setBillable(Boolean value) {
        this.billable = value;
    }

    /**
     * Gets the value of the expenseLineDescription property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getExpenseLineDescription() {
        return expenseLineDescription;
    }

    /**
     * Sets the value of the expenseLineDescription property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setExpenseLineDescription(String value) {
        this.expenseLineDescription = value;
    }

    /**
     * Gets the value of the workTagForBusinessDocumentLineReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the workTagForBusinessDocumentLineReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getWorkTagForBusinessDocumentLineReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link WorktagForBusinessDocumentLineReferenceType }
     * 
     * 
     */
    public List<WorktagForBusinessDocumentLineReferenceType> getWorkTagForBusinessDocumentLineReference() {
        if (workTagForBusinessDocumentLineReference == null) {
            workTagForBusinessDocumentLineReference = new ArrayList<WorktagForBusinessDocumentLineReferenceType>();
        }
        return this.workTagForBusinessDocumentLineReference;
    }

    /**
     * Sets the value of the expenseItemReference property.
     * 
     * @param expenseItemReference
     *     allowed object is
     *     {@link ExpenseItemReferenceType }
     *     
     */
    public void setExpenseItemReference(List<ExpenseItemReferenceType> expenseItemReference) {
        this.expenseItemReference = expenseItemReference;
    }

    /**
     * Sets the value of the workTagForBusinessDocumentLineReference property.
     * 
     * @param workTagForBusinessDocumentLineReference
     *     allowed object is
     *     {@link WorktagForBusinessDocumentLineReferenceType }
     *     
     */
    public void setWorkTagForBusinessDocumentLineReference(List<WorktagForBusinessDocumentLineReferenceType> workTagForBusinessDocumentLineReference) {
        this.workTagForBusinessDocumentLineReference = workTagForBusinessDocumentLineReference;
    }

}
