
package com.workday.professionalservices;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.datatype.XMLGregorianCalendar;


/**
 * Expense Report Data contains all the information about an Expense Report.  Header, Line, and Attachment information.
 * 
 * <p>Java class for Expense_Report_DataType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Expense_Report_DataType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Integration_ID_Data" type="{urn:com.workday/bsvc}External_Integration_ID_DataType"/>
 *         &lt;element name="Company_Reference" type="{urn:com.workday/bsvc}Company_ReferenceType"/>
 *         &lt;element name="Currency_Reference" type="{urn:com.workday/bsvc}Currency_Reference_DataType"/>
 *         &lt;element name="Employee_Reference" type="{urn:com.workday/bsvc}Employee_ReferenceType"/>
 *         &lt;element name="Expense_Report_Date" type="{http://www.w3.org/2001/XMLSchema}date"/>
 *         &lt;element name="Expense_Report_Number" type="{http://www.w3.org/2001/XMLSchema}string"/>
 *         &lt;element name="Total_Amount" minOccurs="0">
 *           &lt;simpleType>
 *             &lt;restriction base="{http://www.w3.org/2001/XMLSchema}decimal">
 *               &lt;totalDigits value="18"/>
 *               &lt;fractionDigits value="3"/>
 *             &lt;/restriction>
 *           &lt;/simpleType>
 *         &lt;/element>
 *         &lt;element name="Expense_Report_Description" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Expense_Report_Approved_Externally" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Payment_Type_Reference" type="{urn:com.workday/bsvc}Payment_Type_ReferenceType"/>
 *         &lt;element name="Expense_Report_Line_Data" type="{urn:com.workday/bsvc}Expense_Report_Line_DataType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Business_Document_Attachment_Data" type="{urn:com.workday/bsvc}Financials_Attachment_DataType" maxOccurs="unbounded" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Expense_Report_DataType", propOrder = {
    "integrationIDData",
    "companyReference",
    "currencyReference",
    "employeeReference",
    "expenseReportDate",
    "expenseReportNumber",
    "totalAmount",
    "expenseReportDescription",
    "expenseReportApprovedExternally",
    "paymentTypeReference",
    "expenseReportLineData",
    "businessDocumentAttachmentData"
})
public class ExpenseReportDataType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Integration_ID_Data", required = true)
    protected ExternalIntegrationIDDataType integrationIDData;
    @XmlElement(name = "Company_Reference", required = true)
    protected CompanyReferenceType companyReference;
    @XmlElement(name = "Currency_Reference", required = true)
    protected CurrencyReferenceDataType currencyReference;
    @XmlElement(name = "Employee_Reference", required = true)
    protected EmployeeReferenceType employeeReference;
    @XmlElement(name = "Expense_Report_Date", required = true)
    @XmlSchemaType(name = "date")
    protected XMLGregorianCalendar expenseReportDate;
    @XmlElement(name = "Expense_Report_Number", required = true)
    protected String expenseReportNumber;
    @XmlElement(name = "Total_Amount")
    protected BigDecimal totalAmount;
    @XmlElement(name = "Expense_Report_Description")
    protected String expenseReportDescription;
    @XmlElement(name = "Expense_Report_Approved_Externally")
    protected Boolean expenseReportApprovedExternally;
    @XmlElement(name = "Payment_Type_Reference", required = true)
    protected PaymentTypeReferenceType paymentTypeReference;
    @XmlElement(name = "Expense_Report_Line_Data")
    protected List<ExpenseReportLineDataType> expenseReportLineData;
    @XmlElement(name = "Business_Document_Attachment_Data")
    protected List<FinancialsAttachmentDataType> businessDocumentAttachmentData;

    /**
     * Gets the value of the integrationIDData property.
     * 
     * @return
     *     possible object is
     *     {@link ExternalIntegrationIDDataType }
     *     
     */
    public ExternalIntegrationIDDataType getIntegrationIDData() {
        return integrationIDData;
    }

    /**
     * Sets the value of the integrationIDData property.
     * 
     * @param value
     *     allowed object is
     *     {@link ExternalIntegrationIDDataType }
     *     
     */
    public void setIntegrationIDData(ExternalIntegrationIDDataType value) {
        this.integrationIDData = value;
    }

    /**
     * Gets the value of the companyReference property.
     * 
     * @return
     *     possible object is
     *     {@link CompanyReferenceType }
     *     
     */
    public CompanyReferenceType getCompanyReference() {
        return companyReference;
    }

    /**
     * Sets the value of the companyReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link CompanyReferenceType }
     *     
     */
    public void setCompanyReference(CompanyReferenceType value) {
        this.companyReference = value;
    }

    /**
     * Gets the value of the currencyReference property.
     * 
     * @return
     *     possible object is
     *     {@link CurrencyReferenceDataType }
     *     
     */
    public CurrencyReferenceDataType getCurrencyReference() {
        return currencyReference;
    }

    /**
     * Sets the value of the currencyReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link CurrencyReferenceDataType }
     *     
     */
    public void setCurrencyReference(CurrencyReferenceDataType value) {
        this.currencyReference = value;
    }

    /**
     * Gets the value of the employeeReference property.
     * 
     * @return
     *     possible object is
     *     {@link EmployeeReferenceType }
     *     
     */
    public EmployeeReferenceType getEmployeeReference() {
        return employeeReference;
    }

    /**
     * Sets the value of the employeeReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link EmployeeReferenceType }
     *     
     */
    public void setEmployeeReference(EmployeeReferenceType value) {
        this.employeeReference = value;
    }

    /**
     * Gets the value of the expenseReportDate property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getExpenseReportDate() {
        return expenseReportDate;
    }

    /**
     * Sets the value of the expenseReportDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setExpenseReportDate(XMLGregorianCalendar value) {
        this.expenseReportDate = value;
    }

    /**
     * Gets the value of the expenseReportNumber property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getExpenseReportNumber() {
        return expenseReportNumber;
    }

    /**
     * Sets the value of the expenseReportNumber property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setExpenseReportNumber(String value) {
        this.expenseReportNumber = value;
    }

    /**
     * Gets the value of the totalAmount property.
     * 
     * @return
     *     possible object is
     *     {@link BigDecimal }
     *     
     */
    public BigDecimal getTotalAmount() {
        return totalAmount;
    }

    /**
     * Sets the value of the totalAmount property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigDecimal }
     *     
     */
    public void setTotalAmount(BigDecimal value) {
        this.totalAmount = value;
    }

    /**
     * Gets the value of the expenseReportDescription property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getExpenseReportDescription() {
        return expenseReportDescription;
    }

    /**
     * Sets the value of the expenseReportDescription property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setExpenseReportDescription(String value) {
        this.expenseReportDescription = value;
    }

    /**
     * Gets the value of the expenseReportApprovedExternally property.
     * This getter has been renamed from isExpenseReportApprovedExternally() to getExpenseReportApprovedExternally() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getExpenseReportApprovedExternally() {
        return expenseReportApprovedExternally;
    }

    /**
     * Sets the value of the expenseReportApprovedExternally property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setExpenseReportApprovedExternally(Boolean value) {
        this.expenseReportApprovedExternally = value;
    }

    /**
     * Gets the value of the paymentTypeReference property.
     * 
     * @return
     *     possible object is
     *     {@link PaymentTypeReferenceType }
     *     
     */
    public PaymentTypeReferenceType getPaymentTypeReference() {
        return paymentTypeReference;
    }

    /**
     * Sets the value of the paymentTypeReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link PaymentTypeReferenceType }
     *     
     */
    public void setPaymentTypeReference(PaymentTypeReferenceType value) {
        this.paymentTypeReference = value;
    }

    /**
     * Gets the value of the expenseReportLineData property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the expenseReportLineData property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExpenseReportLineData().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ExpenseReportLineDataType }
     * 
     * 
     */
    public List<ExpenseReportLineDataType> getExpenseReportLineData() {
        if (expenseReportLineData == null) {
            expenseReportLineData = new ArrayList<ExpenseReportLineDataType>();
        }
        return this.expenseReportLineData;
    }

    /**
     * Gets the value of the businessDocumentAttachmentData property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the businessDocumentAttachmentData property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getBusinessDocumentAttachmentData().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link FinancialsAttachmentDataType }
     * 
     * 
     */
    public List<FinancialsAttachmentDataType> getBusinessDocumentAttachmentData() {
        if (businessDocumentAttachmentData == null) {
            businessDocumentAttachmentData = new ArrayList<FinancialsAttachmentDataType>();
        }
        return this.businessDocumentAttachmentData;
    }

    /**
     * Sets the value of the expenseReportLineData property.
     * 
     * @param expenseReportLineData
     *     allowed object is
     *     {@link ExpenseReportLineDataType }
     *     
     */
    public void setExpenseReportLineData(List<ExpenseReportLineDataType> expenseReportLineData) {
        this.expenseReportLineData = expenseReportLineData;
    }

    /**
     * Sets the value of the businessDocumentAttachmentData property.
     * 
     * @param businessDocumentAttachmentData
     *     allowed object is
     *     {@link FinancialsAttachmentDataType }
     *     
     */
    public void setBusinessDocumentAttachmentData(List<FinancialsAttachmentDataType> businessDocumentAttachmentData) {
        this.businessDocumentAttachmentData = businessDocumentAttachmentData;
    }

}
