/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.workday.financial.connectivity;

import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;
import org.mule.api.ConnectionException;
import org.mule.api.ConnectionExceptionCode;
import org.mule.api.MuleContext;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.retry.RetryPolicyTemplate;
import org.mule.common.DefaultResult;
import org.mule.common.DefaultTestResult;
import org.mule.common.FailureType;
import org.mule.common.Result;
import org.mule.common.TestResult;
import org.mule.common.Testable;
import org.mule.config.PoolingProfile;
import org.mule.modules.workday.financial.adapters.FinancialModuleConnectionIdentifierAdapter;
import org.mule.modules.workday.financial.basic.Capabilities;
import org.mule.modules.workday.financial.basic.Capability;
import org.mule.modules.workday.financial.basic.MetadataAware;
import org.mule.modules.workday.financial.connection.ConnectionManager;
import org.mule.modules.workday.financial.connectivity.FinancialModuleConnectionFactory;
import org.mule.modules.workday.financial.connectivity.FinancialModuleConnectionKey;
import org.mule.modules.workday.financial.connectivity.FinancialModuleManagedConnectionProcessTemplate;
import org.mule.modules.workday.financial.process.ProcessAdapter;
import org.mule.modules.workday.financial.process.ProcessTemplate;

public class FinancialModuleConnectionManager
implements MuleContextAware,
Disposable,
Initialisable,
Testable,
Capabilities,
MetadataAware,
ConnectionManager<FinancialModuleConnectionKey, FinancialModuleConnectionIdentifierAdapter>,
ProcessAdapter<FinancialModuleConnectionIdentifierAdapter> {
    private String financialUser;
    private String financialPassword;
    private String financialEndpoint;
    private String financialWsdlLocation;
    protected MuleContext muleContext;
    protected FlowConstruct flowConstruct;
    private GenericKeyedObjectPool connectionPool;
    protected PoolingProfile connectionPoolingProfile;
    protected RetryPolicyTemplate retryPolicyTemplate;
    private static final String MODULE_NAME = "Workday Financial Management";
    private static final String MODULE_VERSION = "4.1.1";
    private static final String DEVKIT_VERSION = "3.4.3";
    private static final String DEVKIT_BUILD = "3.4.3.1620.30ea288";

    public void setMuleContext(MuleContext value) {
        this.muleContext = value;
    }

    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    public void setFlowConstruct(FlowConstruct value) {
        this.flowConstruct = value;
    }

    public FlowConstruct getFlowConstruct() {
        return this.flowConstruct;
    }

    @Override
    public void setConnectionPoolingProfile(PoolingProfile value) {
        this.connectionPoolingProfile = value;
    }

    @Override
    public PoolingProfile getConnectionPoolingProfile() {
        return this.connectionPoolingProfile;
    }

    public void setRetryPolicyTemplate(RetryPolicyTemplate value) {
        this.retryPolicyTemplate = value;
    }

    @Override
    public RetryPolicyTemplate getRetryPolicyTemplate() {
        return this.retryPolicyTemplate;
    }

    public void setFinancialUser(String value) {
        this.financialUser = value;
    }

    public String getFinancialUser() {
        return this.financialUser;
    }

    public void setFinancialWsdlLocation(String value) {
        this.financialWsdlLocation = value;
    }

    public String getFinancialWsdlLocation() {
        return this.financialWsdlLocation;
    }

    public void setFinancialEndpoint(String value) {
        this.financialEndpoint = value;
    }

    public String getFinancialEndpoint() {
        return this.financialEndpoint;
    }

    public void setFinancialPassword(String value) {
        this.financialPassword = value;
    }

    public String getFinancialPassword() {
        return this.financialPassword;
    }

    public void initialise() {
        GenericKeyedObjectPool.Config config = new GenericKeyedObjectPool.Config();
        if (this.connectionPoolingProfile != null) {
            config.maxIdle = this.connectionPoolingProfile.getMaxIdle();
            config.maxActive = this.connectionPoolingProfile.getMaxActive();
            config.maxWait = this.connectionPoolingProfile.getMaxWait();
            config.whenExhaustedAction = (byte)this.connectionPoolingProfile.getExhaustedAction();
            config.timeBetweenEvictionRunsMillis = this.connectionPoolingProfile.getEvictionCheckIntervalMillis();
            config.minEvictableIdleTimeMillis = this.connectionPoolingProfile.getMinEvictionMillis();
        }
        this.connectionPool = new GenericKeyedObjectPool((KeyedPoolableObjectFactory)new FinancialModuleConnectionFactory(this), config);
        if (this.retryPolicyTemplate == null) {
            this.retryPolicyTemplate = (RetryPolicyTemplate)this.muleContext.getRegistry().lookupObject("_defaultRetryPolicyTemplate");
        }
    }

    public void dispose() {
        try {
            this.connectionPool.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public FinancialModuleConnectionIdentifierAdapter acquireConnection(FinancialModuleConnectionKey key) throws Exception {
        return (FinancialModuleConnectionIdentifierAdapter)this.connectionPool.borrowObject((Object)key);
    }

    @Override
    public void releaseConnection(FinancialModuleConnectionKey key, FinancialModuleConnectionIdentifierAdapter connection) throws Exception {
        this.connectionPool.returnObject((Object)key, (Object)connection);
    }

    @Override
    public void destroyConnection(FinancialModuleConnectionKey key, FinancialModuleConnectionIdentifierAdapter connection) throws Exception {
        this.connectionPool.invalidateObject((Object)key, (Object)connection);
    }

    @Override
    public boolean isCapableOf(Capability capability) {
        if (capability == Capability.LIFECYCLE_CAPABLE) {
            return true;
        }
        return capability == Capability.CONNECTION_MANAGEMENT_CAPABLE;
    }

    @Override
    public <P> ProcessTemplate<P, FinancialModuleConnectionIdentifierAdapter> getProcessTemplate() {
        return new FinancialModuleManagedConnectionProcessTemplate(this, this.muleContext);
    }

    @Override
    public FinancialModuleConnectionKey getDefaultConnectionKey() {
        return new FinancialModuleConnectionKey(this.getFinancialUser(), this.getFinancialPassword(), this.getFinancialEndpoint(), this.getFinancialWsdlLocation());
    }

    @Override
    public String getModuleName() {
        return MODULE_NAME;
    }

    @Override
    public String getModuleVersion() {
        return MODULE_VERSION;
    }

    @Override
    public String getDevkitVersion() {
        return DEVKIT_VERSION;
    }

    @Override
    public String getDevkitBuild() {
        return DEVKIT_BUILD;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestResult test() {
        DefaultTestResult result;
        FinancialModuleConnectionIdentifierAdapter connection = null;
        FinancialModuleConnectionKey key = this.getDefaultConnectionKey();
        try {
            connection = this.acquireConnection(key);
            result = new DefaultTestResult(Result.Status.SUCCESS);
        }
        catch (Exception e) {
            try {
                this.destroyConnection(key, connection);
            }
            catch (Exception ie) {
                // empty catch block
            }
            result = (DefaultTestResult)this.buildFailureTestResult(e);
        }
        finally {
            if (connection != null) {
                try {
                    this.releaseConnection(key, connection);
                }
                catch (Exception ie) {}
            }
        }
        return result;
    }

    public DefaultResult buildFailureTestResult(Exception exception) {
        ConnectionExceptionCode code;
        DefaultTestResult result = exception instanceof ConnectionException ? ((code = ((ConnectionException)exception).getCode()) == ConnectionExceptionCode.UNKNOWN_HOST ? new DefaultTestResult(Result.Status.FAILURE, exception.getMessage(), FailureType.UNKNOWN_HOST, (Throwable)exception) : (code == ConnectionExceptionCode.CANNOT_REACH ? new DefaultTestResult(Result.Status.FAILURE, exception.getMessage(), FailureType.RESOURCE_UNAVAILABLE, (Throwable)exception) : (code == ConnectionExceptionCode.INCORRECT_CREDENTIALS ? new DefaultTestResult(Result.Status.FAILURE, exception.getMessage(), FailureType.INVALID_CREDENTIALS, (Throwable)exception) : (code == ConnectionExceptionCode.CREDENTIALS_EXPIRED ? new DefaultTestResult(Result.Status.FAILURE, exception.getMessage(), FailureType.INVALID_CREDENTIALS, (Throwable)exception) : (code == ConnectionExceptionCode.UNKNOWN ? new DefaultTestResult(Result.Status.FAILURE, exception.getMessage(), FailureType.UNSPECIFIED, (Throwable)exception) : new DefaultTestResult(Result.Status.FAILURE, exception.getMessage(), FailureType.UNSPECIFIED, (Throwable)exception)))))) : new DefaultTestResult(Result.Status.FAILURE, exception.getMessage(), FailureType.UNSPECIFIED, (Throwable)exception);
        return result;
    }
}

