/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.workday.financial.process;

import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.filter.Filter;
import org.mule.modules.workday.financial.adapters.FinancialModuleConnectionIdentifierAdapter;
import org.mule.modules.workday.financial.connection.ConnectionManager;
import org.mule.modules.workday.financial.connection.UnableToAcquireConnectionException;
import org.mule.modules.workday.financial.connection.UnableToReleaseConnectionException;
import org.mule.modules.workday.financial.connectivity.FinancialModuleConnectionKey;
import org.mule.modules.workday.financial.process.ProcessCallback;
import org.mule.modules.workday.financial.process.ProcessInterceptor;
import org.mule.modules.workday.financial.processors.AbstractConnectedProcessor;
import org.mule.modules.workday.financial.processors.AbstractExpressionEvaluator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FinancialModuleManagedConnectionProcessInterceptor<T>
extends AbstractExpressionEvaluator
implements ProcessInterceptor<T, FinancialModuleConnectionIdentifierAdapter> {
    private static Logger logger = LoggerFactory.getLogger(FinancialModuleManagedConnectionProcessInterceptor.class);
    private final ConnectionManager<FinancialModuleConnectionKey, FinancialModuleConnectionIdentifierAdapter> connectionManager;
    private final MuleContext muleContext;
    private final ProcessInterceptor<T, FinancialModuleConnectionIdentifierAdapter> next;

    public FinancialModuleManagedConnectionProcessInterceptor(ProcessInterceptor<T, FinancialModuleConnectionIdentifierAdapter> next, ConnectionManager<FinancialModuleConnectionKey, FinancialModuleConnectionIdentifierAdapter> connectionManager, MuleContext muleContext) {
        this.next = next;
        this.connectionManager = connectionManager;
        this.muleContext = muleContext;
    }

    @Override
    public T execute(ProcessCallback<T, FinancialModuleConnectionIdentifierAdapter> processCallback, FinancialModuleConnectionIdentifierAdapter object, MessageProcessor messageProcessor, MuleEvent event) throws Exception {
        String _transformedFinancialUser;
        FinancialModuleConnectionIdentifierAdapter connection = null;
        FinancialModuleConnectionKey key = null;
        if (messageProcessor != null && messageProcessor instanceof AbstractConnectedProcessor && ((AbstractConnectedProcessor)messageProcessor).getFinancialUser() != null) {
            _transformedFinancialUser = (String)this.evaluateAndTransform(this.muleContext, event, AbstractConnectedProcessor.class.getDeclaredField("_financialUserType").getGenericType(), null, ((AbstractConnectedProcessor)messageProcessor).getFinancialUser());
            if (_transformedFinancialUser == null) {
                throw new UnableToAcquireConnectionException("Parameter financialUser in method connect can't be null because is not @Optional");
            }
            String _transformedFinancialPassword = (String)this.evaluateAndTransform(this.muleContext, event, AbstractConnectedProcessor.class.getDeclaredField("_financialPasswordType").getGenericType(), null, ((AbstractConnectedProcessor)messageProcessor).getFinancialPassword());
            if (_transformedFinancialPassword == null) {
                throw new UnableToAcquireConnectionException("Parameter financialPassword in method connect can't be null because is not @Optional");
            }
            String _transformedFinancialEndpoint = (String)this.evaluateAndTransform(this.muleContext, event, AbstractConnectedProcessor.class.getDeclaredField("_financialEndpointType").getGenericType(), null, ((AbstractConnectedProcessor)messageProcessor).getFinancialEndpoint());
            if (_transformedFinancialEndpoint == null) {
                throw new UnableToAcquireConnectionException("Parameter financialEndpoint in method connect can't be null because is not @Optional");
            }
            String _transformedFinancialWsdlLocation = (String)this.evaluateAndTransform(this.muleContext, event, AbstractConnectedProcessor.class.getDeclaredField("_financialWsdlLocationType").getGenericType(), null, ((AbstractConnectedProcessor)messageProcessor).getFinancialWsdlLocation());
            key = new FinancialModuleConnectionKey(_transformedFinancialUser, _transformedFinancialPassword, _transformedFinancialEndpoint, _transformedFinancialWsdlLocation);
        } else {
            key = this.connectionManager.getDefaultConnectionKey();
        }
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Attempting to acquire connection using " + key.toString());
            }
            if ((connection = this.connectionManager.acquireConnection(key)) == null) {
                throw new UnableToAcquireConnectionException();
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Connection has been acquired with [id=" + connection.getConnectionIdentifier() + "]");
            }
            _transformedFinancialUser = this.next.execute(processCallback, connection, messageProcessor, event);
            return (T)_transformedFinancialUser;
        }
        catch (Exception e) {
            if (processCallback.getManagedExceptions() != null) {
                for (Class exceptionClass : processCallback.getManagedExceptions()) {
                    if (!exceptionClass.isInstance(e)) continue;
                    if (logger.isDebugEnabled()) {
                        logger.debug("An exception ( " + exceptionClass.getName() + ") has been thrown. Destroying the connection with [id=" + connection.getConnectionIdentifier() + "]");
                    }
                    try {
                        if (connection == null) continue;
                        this.connectionManager.destroyConnection(key, connection);
                        connection = null;
                    }
                    catch (Exception innerException) {
                        logger.error(innerException.getMessage(), (Throwable)innerException);
                    }
                }
            }
            throw e;
        }
        finally {
            try {
                if (connection != null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Releasing the connection back into the pool [id=" + connection.getConnectionIdentifier() + "]");
                    }
                    this.connectionManager.releaseConnection(key, connection);
                }
            }
            catch (Exception e) {
                throw new UnableToReleaseConnectionException(e);
            }
        }
    }

    @Override
    public T execute(ProcessCallback<T, FinancialModuleConnectionIdentifierAdapter> processCallback, FinancialModuleConnectionIdentifierAdapter object, Filter filter, MuleMessage message) throws Exception {
        throw new UnsupportedOperationException();
    }
}

