/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.workday.financial.connectivity;

import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.modules.workday.financial.adapters.FinancialModuleConnectionIdentifierAdapter;
import org.mule.modules.workday.financial.connectivity.FinancialModuleConnectionKey;
import org.mule.modules.workday.financial.connectivity.FinancialModuleConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FinancialModuleConnectionFactory
implements KeyedPoolableObjectFactory {
    private static Logger logger = LoggerFactory.getLogger(FinancialModuleConnectionFactory.class);
    private FinancialModuleConnectionManager connectionManager;

    public FinancialModuleConnectionFactory(FinancialModuleConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    public Object makeObject(Object key) throws Exception {
        if (!(key instanceof FinancialModuleConnectionKey)) {
            if (key == null) {
                logger.warn("Connection key is null");
            } else {
                logger.warn("Cannot cast key of type ".concat(key.getClass().getName().concat(" to ").concat("org.mule.modules.workday.financial.connectivity.FinancialModuleConnectionKey")));
            }
            throw new RuntimeException("Invalid key type ".concat(key.getClass().getName()));
        }
        FinancialModuleConnectionIdentifierAdapter connector = new FinancialModuleConnectionIdentifierAdapter();
        if (connector instanceof Initialisable) {
            connector.initialise();
        }
        if (connector instanceof MuleContextAware) {
            ((MuleContextAware)connector).setMuleContext(this.connectionManager.getMuleContext());
        }
        if (connector instanceof Startable) {
            connector.start();
        }
        if (!connector.validateConnection()) {
            connector.connect(((FinancialModuleConnectionKey)key).getFinancialUser(), ((FinancialModuleConnectionKey)key).getFinancialPassword(), ((FinancialModuleConnectionKey)key).getFinancialEndpoint(), ((FinancialModuleConnectionKey)key).getFinancialWsdlLocation());
        }
        return connector;
    }

    public void destroyObject(Object key, Object obj) throws Exception {
        if (!(key instanceof FinancialModuleConnectionKey)) {
            if (key == null) {
                logger.warn("Connection key is null");
            } else {
                logger.warn("Cannot cast key of type ".concat(key.getClass().getName().concat(" to ").concat("org.mule.modules.workday.financial.connectivity.FinancialModuleConnectionKey")));
            }
            throw new RuntimeException("Invalid key type ".concat(key.getClass().getName()));
        }
        if (!(obj instanceof FinancialModuleConnectionIdentifierAdapter)) {
            if (obj == null) {
                logger.warn("Connector is null");
            } else {
                logger.warn("Cannot cast connector of type ".concat(obj.getClass().getName().concat(" to ").concat("org.mule.modules.workday.financial.adapters.FinancialModuleConnectionIdentifierAdapter")));
            }
            throw new RuntimeException("Invalid connector type ".concat(obj.getClass().getName()));
        }
        try {
            ((FinancialModuleConnectionIdentifierAdapter)obj).disconnect();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if ((FinancialModuleConnectionIdentifierAdapter)obj instanceof Stoppable) {
                ((Stoppable)obj).stop();
            }
            if ((FinancialModuleConnectionIdentifierAdapter)obj instanceof Disposable) {
                ((Disposable)obj).dispose();
            }
        }
    }

    public boolean validateObject(Object key, Object obj) {
        if (!(obj instanceof FinancialModuleConnectionIdentifierAdapter)) {
            if (obj == null) {
                logger.warn("Connector is null");
            } else {
                logger.warn("Cannot cast connector of type ".concat(obj.getClass().getName().concat(" to ").concat("org.mule.modules.workday.financial.adapters.FinancialModuleConnectionIdentifierAdapter")));
            }
            throw new RuntimeException("Invalid connector type ".concat(obj.getClass().getName()));
        }
        try {
            return ((FinancialModuleConnectionIdentifierAdapter)obj).validateConnection();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public void activateObject(Object key, Object obj) throws Exception {
        if (!(key instanceof FinancialModuleConnectionKey)) {
            throw new RuntimeException("Invalid key type");
        }
        if (!(obj instanceof FinancialModuleConnectionIdentifierAdapter)) {
            throw new RuntimeException("Invalid connector type");
        }
        if (!((FinancialModuleConnectionIdentifierAdapter)obj).validateConnection()) {
            ((FinancialModuleConnectionIdentifierAdapter)obj).connect(((FinancialModuleConnectionKey)key).getFinancialUser(), ((FinancialModuleConnectionKey)key).getFinancialPassword(), ((FinancialModuleConnectionKey)key).getFinancialEndpoint(), ((FinancialModuleConnectionKey)key).getFinancialWsdlLocation());
        }
    }

    public void passivateObject(Object key, Object obj) throws Exception {
    }
}

