
package org.mule.modules.workday.financial.processors;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Generated;
import com.workday.financial.PutObjectClassSetRequestType;
import com.workday.financial.PutObjectClassSetResponseType;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.processor.MessageProcessor;
import org.mule.common.DefaultResult;
import org.mule.common.Result;
import org.mule.common.metadata.DefaultMetaData;
import org.mule.common.metadata.DefaultPojoMetaDataModel;
import org.mule.common.metadata.DefaultSimpleMetaDataModel;
import org.mule.common.metadata.MetaData;
import org.mule.common.metadata.MetaDataModel;
import org.mule.common.metadata.OperationMetaDataEnabled;
import org.mule.common.metadata.datatype.DataType;
import org.mule.common.metadata.datatype.DataTypeFactory;
import org.mule.config.i18n.CoreMessages;
import org.mule.modules.workday.api.exception.WorkdayCredentialsException;
import org.mule.modules.workday.financial.FinancialModule;
import org.mule.modules.workday.financial.connectivity.FinancialModuleConnectionManager;
import org.mule.modules.workday.financial.process.ProcessAdapter;
import org.mule.modules.workday.financial.process.ProcessCallback;
import org.mule.modules.workday.financial.process.ProcessTemplate;


/**
 * PutObjectClassSetMessageProcessor invokes the {@link org.mule.modules.workday.financial.FinancialModule#putObjectClassSet(com.workday.financial.PutObjectClassSetRequestType)} method in {@link FinancialModule }. For each argument there is a field in this processor to match it.  Before invoking the actual method the processor will evaluate and transform where possible to the expected argument type.
 * 
 */
@Generated(value = "Mule DevKit Version 3.4.3", date = "2014-12-12T07:02:11-03:00", comments = "Build 3.4.3.1620.30ea288")
public class PutObjectClassSetMessageProcessor
    extends AbstractMessageProcessor<Object>
    implements Disposable, Initialisable, Startable, Stoppable, MessageProcessor, OperationMetaDataEnabled
{

    protected Object putObjectClassSetRequest;
    protected PutObjectClassSetRequestType _putObjectClassSetRequestType;

    /**
     * Obtains the expression manager from the Mule context and initialises the connector. If a target object  has not been set already it will search the Mule registry for a default one.
     * 
     * @throws InitialisationException
     */
    public void initialise()
        throws InitialisationException
    {
    }

    public void start()
        throws MuleException
    {
    }

    public void stop()
        throws MuleException
    {
    }

    public void dispose() {
    }

    /**
     * Set the Mule context
     * 
     * @param context Mule context to set
     */
    public void setMuleContext(MuleContext context) {
        super.setMuleContext(context);
    }

    /**
     * Sets flow construct
     * 
     * @param flowConstruct Flow construct to set
     */
    public void setFlowConstruct(FlowConstruct flowConstruct) {
        super.setFlowConstruct(flowConstruct);
    }

    /**
     * Sets putObjectClassSetRequest
     * 
     * @param value Value to set
     */
    public void setPutObjectClassSetRequest(Object value) {
        this.putObjectClassSetRequest = value;
    }

    /**
     * Invokes the MessageProcessor.
     * 
     * @param event MuleEvent to be processed
     * @throws MuleException
     */
    public MuleEvent process(final MuleEvent event)
        throws MuleException
    {
        Object moduleObject = null;
        try {
            moduleObject = findOrCreate(FinancialModuleConnectionManager.class, true, event);
            final PutObjectClassSetRequestType _transformedPutObjectClassSetRequest = ((PutObjectClassSetRequestType) evaluateAndTransform(getMuleContext(), event, PutObjectClassSetMessageProcessor.class.getDeclaredField("_putObjectClassSetRequestType").getGenericType(), null, putObjectClassSetRequest));
            Object resultPayload;
            ProcessTemplate<Object, Object> processTemplate = ((ProcessAdapter<Object> ) moduleObject).getProcessTemplate();
            resultPayload = processTemplate.execute(new ProcessCallback<Object,Object>() {


                public List<Class> getManagedExceptions() {
                    return Arrays.asList(new Class[] {WorkdayCredentialsException.class });
                }

                public boolean isProtected() {
                    return false;
                }

                public Object process(Object object)
                    throws Exception
                {
                    return ((FinancialModule) object).putObjectClassSet(_transformedPutObjectClassSetRequest);
                }

            }
            , this, event);
            overwritePayload(event, resultPayload);
            return event;
        } catch (MessagingException messagingException) {
            messagingException.setProcessedEvent(event);
            throw messagingException;
        } catch (Exception e) {
            throw new MessagingException(CoreMessages.failedToInvoke("putObjectClassSet"), event, e);
        }
    }

    @Override
    public Result<MetaData> getInputMetaData() {
        return new DefaultResult<MetaData>(new DefaultMetaData(getPojoOrSimpleModel(PutObjectClassSetRequestType.class)));
    }

    @Override
    public Result<MetaData> getOutputMetaData(MetaData inputMetadata) {
        return new DefaultResult<MetaData>(new DefaultMetaData(getPojoOrSimpleModel(PutObjectClassSetResponseType.class)));
    }

    private MetaDataModel getPojoOrSimpleModel(Class clazz) {
        DataType dataType = DataTypeFactory.getInstance().getDataType(clazz);
        if (DataType.POJO.equals(dataType)) {
            return new DefaultPojoMetaDataModel(clazz);
        } else {
            return new DefaultSimpleMetaDataModel(dataType);
        }
    }

}
