
package org.mule.modules.workday.financial.process;

import java.util.List;
import javax.annotation.Generated;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.filter.Filter;
import org.mule.modules.workday.financial.adapters.FinancialModuleConnectionIdentifierAdapter;
import org.mule.modules.workday.financial.connection.ConnectionManager;
import org.mule.modules.workday.financial.connection.UnableToAcquireConnectionException;
import org.mule.modules.workday.financial.connection.UnableToReleaseConnectionException;
import org.mule.modules.workday.financial.connectivity.FinancialModuleConnectionKey;
import org.mule.modules.workday.financial.processors.AbstractConnectedProcessor;
import org.mule.modules.workday.financial.processors.AbstractExpressionEvaluator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated(value = "Mule DevKit Version 3.4.3", date = "2014-12-12T07:02:11-03:00", comments = "Build 3.4.3.1620.30ea288")
public class FinancialModuleManagedConnectionProcessInterceptor<T >
    extends AbstractExpressionEvaluator
    implements ProcessInterceptor<T, FinancialModuleConnectionIdentifierAdapter>
{

    private static Logger logger = LoggerFactory.getLogger(FinancialModuleManagedConnectionProcessInterceptor.class);
    private final ConnectionManager<FinancialModuleConnectionKey, FinancialModuleConnectionIdentifierAdapter> connectionManager;
    private final MuleContext muleContext;
    private final ProcessInterceptor<T, FinancialModuleConnectionIdentifierAdapter> next;

    public FinancialModuleManagedConnectionProcessInterceptor(ProcessInterceptor<T, FinancialModuleConnectionIdentifierAdapter> next, ConnectionManager<FinancialModuleConnectionKey, FinancialModuleConnectionIdentifierAdapter> connectionManager, MuleContext muleContext) {
        this.next = next;
        this.connectionManager = connectionManager;
        this.muleContext = muleContext;
    }

    public T execute(ProcessCallback<T, FinancialModuleConnectionIdentifierAdapter> processCallback, FinancialModuleConnectionIdentifierAdapter object, MessageProcessor messageProcessor, MuleEvent event)
        throws Exception
    {
        FinancialModuleConnectionIdentifierAdapter connection = null;
        FinancialModuleConnectionKey key = null;
        if ((messageProcessor!= null)&&((messageProcessor instanceof AbstractConnectedProcessor)&&(((AbstractConnectedProcessor) messageProcessor).getFinancialUser()!= null))) {
            final String _transformedFinancialUser = ((String) evaluateAndTransform(muleContext, event, AbstractConnectedProcessor.class.getDeclaredField("_financialUserType").getGenericType(), null, ((AbstractConnectedProcessor) messageProcessor).getFinancialUser()));
            if (_transformedFinancialUser == null) {
                throw new UnableToAcquireConnectionException("Parameter financialUser in method connect can't be null because is not @Optional");
            }
            final String _transformedFinancialPassword = ((String) evaluateAndTransform(muleContext, event, AbstractConnectedProcessor.class.getDeclaredField("_financialPasswordType").getGenericType(), null, ((AbstractConnectedProcessor) messageProcessor).getFinancialPassword()));
            if (_transformedFinancialPassword == null) {
                throw new UnableToAcquireConnectionException("Parameter financialPassword in method connect can't be null because is not @Optional");
            }
            final String _transformedFinancialEndpoint = ((String) evaluateAndTransform(muleContext, event, AbstractConnectedProcessor.class.getDeclaredField("_financialEndpointType").getGenericType(), null, ((AbstractConnectedProcessor) messageProcessor).getFinancialEndpoint()));
            if (_transformedFinancialEndpoint == null) {
                throw new UnableToAcquireConnectionException("Parameter financialEndpoint in method connect can't be null because is not @Optional");
            }
            final String _transformedFinancialWsdlLocation = ((String) evaluateAndTransform(muleContext, event, AbstractConnectedProcessor.class.getDeclaredField("_financialWsdlLocationType").getGenericType(), null, ((AbstractConnectedProcessor) messageProcessor).getFinancialWsdlLocation()));
            key = new FinancialModuleConnectionKey(_transformedFinancialUser, _transformedFinancialPassword, _transformedFinancialEndpoint, _transformedFinancialWsdlLocation);
        } else {
            key = connectionManager.getDefaultConnectionKey();
        }
        try {
            if (logger.isDebugEnabled()) {
                logger.debug(("Attempting to acquire connection using "+ key.toString()));
            }
            connection = connectionManager.acquireConnection(key);
            if (connection == null) {
                throw new UnableToAcquireConnectionException();
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug((("Connection has been acquired with [id="+ connection.getConnectionIdentifier())+"]"));
                }
            }
            return next.execute(processCallback, connection, messageProcessor, event);
        } catch (Exception e) {
            if (processCallback.getManagedExceptions()!= null) {
                for (Class exceptionClass: ((List<Class> ) processCallback.getManagedExceptions())) {
                    if (exceptionClass.isInstance(e)) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((((("An exception ( "+ exceptionClass.getName())+") has been thrown. Destroying the connection with [id=")+ connection.getConnectionIdentifier())+"]"));
                        }
                        try {
                            if (connection!= null) {
                                connectionManager.destroyConnection(key, connection);
                                connection = null;
                            }
                        } catch (Exception innerException) {
                            logger.error(innerException.getMessage(), innerException);
                        }
                    }
                }
            }
            throw e;
        } finally {
            try {
                if (connection!= null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((("Releasing the connection back into the pool [id="+ connection.getConnectionIdentifier())+"]"));
                    }
                    connectionManager.releaseConnection(key, connection);
                }
            } catch (Exception e) {
                throw new UnableToReleaseConnectionException(e);
            }
        }
    }

    public T execute(ProcessCallback<T, FinancialModuleConnectionIdentifierAdapter> processCallback, FinancialModuleConnectionIdentifierAdapter object, Filter filter, MuleMessage message)
        throws Exception
    {
        throw new UnsupportedOperationException();
    }

}
