
package org.mule.modules.workday.financial.connectivity;

import javax.annotation.Generated;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;
import org.mule.api.ConnectionException;
import org.mule.api.ConnectionExceptionCode;
import org.mule.api.MuleContext;
import org.mule.api.config.MuleProperties;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.retry.RetryPolicyTemplate;
import org.mule.common.DefaultResult;
import org.mule.common.DefaultTestResult;
import org.mule.common.FailureType;
import org.mule.common.TestResult;
import org.mule.common.Testable;
import org.mule.config.PoolingProfile;
import org.mule.modules.workday.financial.FinancialModule;
import org.mule.modules.workday.financial.adapters.FinancialModuleConnectionIdentifierAdapter;
import org.mule.modules.workday.financial.basic.Capabilities;
import org.mule.modules.workday.financial.basic.Capability;
import org.mule.modules.workday.financial.basic.MetadataAware;
import org.mule.modules.workday.financial.connection.ConnectionManager;
import org.mule.modules.workday.financial.process.ProcessAdapter;
import org.mule.modules.workday.financial.process.ProcessTemplate;


/**
 * A {@code FinancialModuleConnectionManager} is a wrapper around {@link FinancialModule } that adds connection management capabilities to the pojo.
 * 
 */
@Generated(value = "Mule DevKit Version 3.4.3", date = "2014-12-12T07:02:11-03:00", comments = "Build 3.4.3.1620.30ea288")
public class FinancialModuleConnectionManager implements MuleContextAware, Disposable, Initialisable, Testable, Capabilities, MetadataAware, ConnectionManager<FinancialModuleConnectionKey, FinancialModuleConnectionIdentifierAdapter> , ProcessAdapter<FinancialModuleConnectionIdentifierAdapter>
{

    /**
     * 
     */
    private String financialUser;
    /**
     * 
     */
    private String financialPassword;
    /**
     * 
     */
    private String financialEndpoint;
    /**
     * 
     */
    private String financialWsdlLocation;
    /**
     * Mule Context
     * 
     */
    protected MuleContext muleContext;
    /**
     * Flow Construct
     * 
     */
    protected FlowConstruct flowConstruct;
    /**
     * Connector Pool
     * 
     */
    private GenericKeyedObjectPool connectionPool;
    protected PoolingProfile connectionPoolingProfile;
    protected RetryPolicyTemplate retryPolicyTemplate;
    private final static String MODULE_NAME = "Workday Financial Management";
    private final static String MODULE_VERSION = "4.1.0";
    private final static String DEVKIT_VERSION = "3.4.3";
    private final static String DEVKIT_BUILD = "3.4.3.1620.30ea288";

    /**
     * Sets muleContext
     * 
     * @param value Value to set
     */
    public void setMuleContext(MuleContext value) {
        this.muleContext = value;
    }

    /**
     * Retrieves muleContext
     * 
     */
    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    /**
     * Sets flowConstruct
     * 
     * @param value Value to set
     */
    public void setFlowConstruct(FlowConstruct value) {
        this.flowConstruct = value;
    }

    /**
     * Retrieves flowConstruct
     * 
     */
    public FlowConstruct getFlowConstruct() {
        return this.flowConstruct;
    }

    /**
     * Sets connectionPoolingProfile
     * 
     * @param value Value to set
     */
    public void setConnectionPoolingProfile(PoolingProfile value) {
        this.connectionPoolingProfile = value;
    }

    /**
     * Retrieves connectionPoolingProfile
     * 
     */
    public PoolingProfile getConnectionPoolingProfile() {
        return this.connectionPoolingProfile;
    }

    /**
     * Sets retryPolicyTemplate
     * 
     * @param value Value to set
     */
    public void setRetryPolicyTemplate(RetryPolicyTemplate value) {
        this.retryPolicyTemplate = value;
    }

    /**
     * Retrieves retryPolicyTemplate
     * 
     */
    public RetryPolicyTemplate getRetryPolicyTemplate() {
        return this.retryPolicyTemplate;
    }

    /**
     * Sets financialUser
     * 
     * @param value Value to set
     */
    public void setFinancialUser(String value) {
        this.financialUser = value;
    }

    /**
     * Retrieves financialUser
     * 
     */
    public String getFinancialUser() {
        return this.financialUser;
    }

    /**
     * Sets financialWsdlLocation
     * 
     * @param value Value to set
     */
    public void setFinancialWsdlLocation(String value) {
        this.financialWsdlLocation = value;
    }

    /**
     * Retrieves financialWsdlLocation
     * 
     */
    public String getFinancialWsdlLocation() {
        return this.financialWsdlLocation;
    }

    /**
     * Sets financialEndpoint
     * 
     * @param value Value to set
     */
    public void setFinancialEndpoint(String value) {
        this.financialEndpoint = value;
    }

    /**
     * Retrieves financialEndpoint
     * 
     */
    public String getFinancialEndpoint() {
        return this.financialEndpoint;
    }

    /**
     * Sets financialPassword
     * 
     * @param value Value to set
     */
    public void setFinancialPassword(String value) {
        this.financialPassword = value;
    }

    /**
     * Retrieves financialPassword
     * 
     */
    public String getFinancialPassword() {
        return this.financialPassword;
    }

    public void initialise() {
        GenericKeyedObjectPool.Config config = new GenericKeyedObjectPool.Config();
        if (connectionPoolingProfile!= null) {
            config.maxIdle = connectionPoolingProfile.getMaxIdle();
            config.maxActive = connectionPoolingProfile.getMaxActive();
            config.maxWait = connectionPoolingProfile.getMaxWait();
            config.whenExhaustedAction = ((byte) connectionPoolingProfile.getExhaustedAction());
            config.timeBetweenEvictionRunsMillis = connectionPoolingProfile.getEvictionCheckIntervalMillis();
            config.minEvictableIdleTimeMillis = connectionPoolingProfile.getMinEvictionMillis();
        }
        connectionPool = new GenericKeyedObjectPool(new FinancialModuleConnectionFactory(this), config);
        if (retryPolicyTemplate == null) {
            retryPolicyTemplate = muleContext.getRegistry().lookupObject(MuleProperties.OBJECT_DEFAULT_RETRY_POLICY_TEMPLATE);
        }
    }

    @Override
    public void dispose() {
        try {
            connectionPool.close();
        } catch (Exception e) {
        }
    }

    public FinancialModuleConnectionIdentifierAdapter acquireConnection(FinancialModuleConnectionKey key)
        throws Exception
    {
        return ((FinancialModuleConnectionIdentifierAdapter) connectionPool.borrowObject(key));
    }

    public void releaseConnection(FinancialModuleConnectionKey key, FinancialModuleConnectionIdentifierAdapter connection)
        throws Exception
    {
        connectionPool.returnObject(key, connection);
    }

    public void destroyConnection(FinancialModuleConnectionKey key, FinancialModuleConnectionIdentifierAdapter connection)
        throws Exception
    {
        connectionPool.invalidateObject(key, connection);
    }

    /**
     * Returns true if this module implements such capability
     * 
     */
    public boolean isCapableOf(Capability capability) {
        if (capability == Capability.LIFECYCLE_CAPABLE) {
            return true;
        }
        if (capability == Capability.CONNECTION_MANAGEMENT_CAPABLE) {
            return true;
        }
        return false;
    }

    @Override
    public<P >ProcessTemplate<P, FinancialModuleConnectionIdentifierAdapter> getProcessTemplate() {
        return new FinancialModuleManagedConnectionProcessTemplate(this, muleContext);
    }

    public FinancialModuleConnectionKey getDefaultConnectionKey() {
        return new FinancialModuleConnectionKey(getFinancialUser(), getFinancialPassword(), getFinancialEndpoint(), getFinancialWsdlLocation());
    }

    public String getModuleName() {
        return MODULE_NAME;
    }

    public String getModuleVersion() {
        return MODULE_VERSION;
    }

    public String getDevkitVersion() {
        return DEVKIT_VERSION;
    }

    public String getDevkitBuild() {
        return DEVKIT_BUILD;
    }

    public TestResult test() {
        FinancialModuleConnectionIdentifierAdapter connection = null;
        DefaultTestResult result;
        FinancialModuleConnectionKey key = getDefaultConnectionKey();
        try {
            connection = acquireConnection(key);
            result = new DefaultTestResult(org.mule.common.Result.Status.SUCCESS);
        } catch (Exception e) {
            try {
                destroyConnection(key, connection);
            } catch (Exception ie) {
            }
            result = ((DefaultTestResult) buildFailureTestResult(e));
        } finally {
            if (connection!= null) {
                try {
                    releaseConnection(key, connection);
                } catch (Exception ie) {
                }
            }
        }
        return result;
    }

    public DefaultResult buildFailureTestResult(Exception exception) {
        DefaultTestResult result;
        if (exception instanceof ConnectionException) {
            ConnectionExceptionCode code = ((ConnectionException) exception).getCode();
            if (code == ConnectionExceptionCode.UNKNOWN_HOST) {
                result = new DefaultTestResult(org.mule.common.Result.Status.FAILURE, exception.getMessage(), FailureType.UNKNOWN_HOST, exception);
            } else {
                if (code == ConnectionExceptionCode.CANNOT_REACH) {
                    result = new DefaultTestResult(org.mule.common.Result.Status.FAILURE, exception.getMessage(), FailureType.RESOURCE_UNAVAILABLE, exception);
                } else {
                    if (code == ConnectionExceptionCode.INCORRECT_CREDENTIALS) {
                        result = new DefaultTestResult(org.mule.common.Result.Status.FAILURE, exception.getMessage(), FailureType.INVALID_CREDENTIALS, exception);
                    } else {
                        if (code == ConnectionExceptionCode.CREDENTIALS_EXPIRED) {
                            result = new DefaultTestResult(org.mule.common.Result.Status.FAILURE, exception.getMessage(), FailureType.INVALID_CREDENTIALS, exception);
                        } else {
                            if (code == ConnectionExceptionCode.UNKNOWN) {
                                result = new DefaultTestResult(org.mule.common.Result.Status.FAILURE, exception.getMessage(), FailureType.UNSPECIFIED, exception);
                            } else {
                                result = new DefaultTestResult(org.mule.common.Result.Status.FAILURE, exception.getMessage(), FailureType.UNSPECIFIED, exception);
                            }
                        }
                    }
                }
            }
        } else {
            result = new DefaultTestResult(org.mule.common.Result.Status.FAILURE, exception.getMessage(), FailureType.UNSPECIFIED, exception);
        }
        return result;
    }

}
