/**
 * (c) 2003-2014 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master
 * Subscription Agreement (or other Terms of Service) separately entered
 * into between you and MuleSoft. If such an agreement is not in
 * place, you may not use the software.
 */

package org.mule.modules.workday.financial;

import javax.validation.constraints.NotNull;
import javax.xml.ws.Service;

import org.mule.modules.workday.api.AbstractCxfWorkdayClient;

import com.workday.financial.*;

public class CxfFinancialClient extends AbstractCxfWorkdayClient<FinancialManagementPort> implements FinancialManagementPort {

	public CxfFinancialClient(@NotNull String username, @NotNull String password,
			@NotNull String endpoint, @NotNull String wsdlLocation) {
		super(username, password, endpoint, wsdlLocation);
	}


	@Override
	protected Class<? extends Service> serviceType() {
		return FinancialManagementService.class;
	}

	@Override
	protected Class<FinancialManagementPort> portType() {
		return FinancialManagementPort.class;
	}
	
	@Override
	public GetBeginningBalanceJournalsResponseType getBeginningBalanceJournals(GetBeginningBalanceJournalsRequestType body) {
		return getConnection().getBeginningBalanceJournals(body);
	}

	@Override
	public GetRegionsResponseType getRegions(GetRegionsRequestType body) {
		return getConnection().getRegions(body);
	}

	@Override
	public PutEffortCertificationChangeReasonCodeResponseType putEffortCertificationChangeReasonCode(
			PutEffortCertificationChangeReasonCodeRequestType body) {
		return getConnection().putEffortCertificationChangeReasonCode(body);
	}

	@Override
	public PutCustomWorktagResponseType putCustomWorktag(PutCustomWorktagRequestType body) {
		return getConnection().putCustomWorktag(body);
	}

	@Override
	public PutSurveyResponseType putSurvey(PutSurveyRequestType body) {
		return getConnection().putSurvey(body);
	}

	@Override
	public GetCurrencyRateTypesResponseType getCurrencyRateTypes(GetCurrencyRateTypesRequestType body) {
		return getConnection().getCurrencyRateTypes(body);
	}

	@Override
	public PutResourceCategoryResponseType putResourceCategory(PutResourceCategoryRequestType body) {
		return getConnection().putResourceCategory(body);
	}

	@Override
	public GetBasicProjectsResponseType getBasicProjects(GetBasicProjectsRequestType body) {
		return getConnection().getBasicProjects(body);
	}

	@Override
	public Get1042SIncomeCodesResponseType get1042SIncomeCodes(Get1042SIncomeCodesRequestType body) {
		return getConnection().get1042SIncomeCodes(body);
	}

	@Override
	public GetPaymentMessagesResponseType getPaymentMessages(GetPaymentMessagesRequestType body) {
		return getConnection().getPaymentMessages(body);
	}

	@Override
	public GetEffortCertifyingTextsResponseType getEffortCertifyingTexts(GetEffortCertifyingTextsRequestType body) {
		return getConnection().getEffortCertifyingTexts(body);
	}

	@Override
	public GetResourceCategoriesResponseType getResourceCategories(GetResourceCategoriesRequestType body) {
		return getConnection().getResourceCategories(body);
	}

	@Override
	public GetStatisticsResponseType getStatistics(GetStatisticsRequestType body) {
		return getConnection().getStatistics(body);
	}

	@Override
	public GetBasicSalesItemsResponseType getBasicSalesItems(GetBasicSalesItemsRequestType body) {
		return getConnection().getBasicSalesItems(body);
	}

	@Override
	public PutPaymentTermResponseType putPaymentTerm(PutPaymentTermRequestType body) {
		return getConnection().putPaymentTerm(body);
	}

	@Override
	public PutCustomValidationRuleResponseType putCustomValidationRule(PutCustomValidationRuleRequestType body) {
		return getConnection().putCustomValidationRule(body);
	}

	@Override
	public GetTaxCategoriesResponseType getTaxCategories(GetTaxCategoriesRequestType body) {
		return getConnection().getTaxCategories(body);
	}

	@Override
	public GetBasicCustomersResponseType getBasicCustomers(GetBasicCustomersRequestType body) {
		return getConnection().getBasicCustomers(body);
	}

	@Override
	public GetGrantsResponseType getGrants(GetGrantsRequestType body) {
		return getConnection().getGrants(body);
	}

	@Override
	public GetPaymentTypesResponseType getPaymentTypes(GetPaymentTypesRequestType body) {
		return getConnection().getPaymentTypes(body);
	}

	@Override
	public GetCustomWorktagsResponseType getCustomWorktags(GetCustomWorktagsRequestType body) {
		return getConnection().getCustomWorktags(body);
	}

	@Override
	public PutStatisticDefinitionResponseType putStatisticDefinition(PutStatisticDefinitionRequestType body) {
		return getConnection().putStatisticDefinition(body);
	}

	@Override
	public Submit1099MISCAdjustmentResponseType submit1099MISCAdjustment(Submit1099MISCAdjustmentRequestType body) {
		return getConnection().submit1099MISCAdjustment(body);
	}

	@Override
	public PutEffortCertifyingTextResponseType putEffortCertifyingText(PutEffortCertifyingTextRequestType body) {
		return getConnection().putEffortCertifyingText(body);
	}

	@Override
	public PutProgramHierarchyResponseType putProgramHierarchy(PutProgramHierarchyRequestType body) {
		return getConnection().putProgramHierarchy(body);
	}

	@Override
	public GetBusinessUnitsResponseType getBusinessUnits(GetBusinessUnitsRequestType body) {
		return getConnection().getBusinessUnits(body);
	}

	@Override
	public SubmitBusinessPlanAmendmentResponseType submitBusinessPlanAmendment(SubmitBusinessPlanAmendmentRequestType body) {
		return getConnection().submitBusinessPlanAmendment(body);
	}

	@Override
	public PutBasicGrantResponseType putBasicGrant(PutBasicGrantRequestType body) {
		return getConnection().putBasicGrant(body);
	}

	@Override
	public PutBusinessUnitHierarchyResponseType putBusinessUnitHierarchy(PutBusinessUnitHierarchyRequestType body) {
		return getConnection().putBusinessUnitHierarchy(body);
	}

	@Override
	public GetGiftHierarchiesResponseType getGiftHierarchies(GetGiftHierarchiesRequestType body) {
		return getConnection().getGiftHierarchies(body);
	}

	@Override
	public GetEffortCertificationEligibilityRulesResponseType getEffortCertificationEligibilityRulesWithoutDependencies(
			GetEffortCertificationEligibilityRulesWithoutDependenciesRequestType body) {
		return getConnection().getEffortCertificationEligibilityRulesWithoutDependencies(body);
	}

	@Override
	public PutProgramResponseType putProgram(PutProgramRequestType body) {
		return getConnection().putProgram(body);
	}

	@Override
	public GetJournalsResponseType getJournals(GetJournalsRequestType body) {
		return getConnection().getJournals(body);
	}

	@Override
	public GetLoansResponseType getLoans(GetLoansRequestType body) {
		return getConnection().getLoans(body);
	}

	@Override
	public PutEffortCertificationTypeResponseType putEffortCertificationType(PutEffortCertificationTypeRequestType body) {
		return getConnection().putEffortCertificationType(body);
	}

	@Override
	public GetFundHierarchiesResponseType getFundHierarchies(GetFundHierarchiesRequestType body) {
		return getConnection().getFundHierarchies(body);
	}

	@Override
	public GetSearchSettingsResponseType getSearchSettings(GetSearchSettingsRequestType body) {
		return getConnection().getSearchSettings(body);
	}

	@Override
	public PutStatisticResponseType putStatistic(PutStatisticRequestType body) {
		return getConnection().putStatistic(body);
	}

	@Override
	public PutSalesItemResponseType putBasicSalesItem(PutBasicSalesItemRequestType body) {
		return getConnection().putBasicSalesItem(body);
	}

	@Override
	public GetProgramsResponseType getPrograms(GetProgramsRequestType body) {
		return getConnection().getPrograms(body);
	}

	@Override
	public PutSearchSettingsResponseType putSearchSettings(PutSearchSettingsRequestType body) {
		return getConnection().putSearchSettings(body);
	}

	@Override
	public SubmitGiftResponseType submitGift(SubmitGiftRequestType body) {
		return getConnection().submitGift(body);
	}

	@Override
	public PutLedgerAccountSummaryResponseType putLedgerAccountSummary(PutLedgerAccountSummaryRequestType body) {
		return getConnection().putLedgerAccountSummary(body);
	}

	@Override
	public PutCurrencyRateTypeResponseType putCurrencyRateType(PutCurrencyRateTypeRequestType body) {
		return getConnection().putCurrencyRateType(body);
	}

	@Override
	public GetRecurringJournalTemplatesResponseType getRecurringJournalTemplates(GetRecurringJournalTemplatesRequestType body) {
		return getConnection().getRecurringJournalTemplates(body);
	}

	@Override
	public GetLedgerAccountSummariesResponseType getLedgerAccountSummaries(GetLedgerAccountSummaryRequestType body) {
		return getConnection().getLedgerAccountSummaries(body);
	}

	@Override
	public GetEffortCertificationChangeReasonCodesResponseType getEffortCertificationChangeReasonCodes(GetEffortCertificationChangeReasonCodesRequestType body) {
		return getConnection().getEffortCertificationChangeReasonCodes(body);
	}

	@Override
	public PutCustomerCategoryResponseType putCustomerCategory(PutCustomerCategoryRequestType body) {
		return getConnection().putCustomerCategory(body);
	}

	@Override
	public GetBusinessEntityContactsResponseType getBusinessEntityContacts(GetBusinessEntityContactsRequestType body) {
		return getConnection().getBusinessEntityContacts(body);
	}

	@Override
	public PutGrantHierarchyResponseType putGrantHierarchy(PutGrantHierarchyRequestType body) {
		return getConnection().putGrantHierarchy(body);
	}

	@Override
	public PutGiftHierarchyResponseType putGiftHierarchy(PutGiftHierarchyRequestType body) {
		return getConnection().putGiftHierarchy(body);
	}

	@Override
	public GetProgramHierarchiesResponseType getProgramHierarchies(GetProgramHierarchiesRequestType body) {
		return getConnection().getProgramHierarchies(body);
	}

	@Override
	public GetFundTypesResponseType getFundTypes(GetFundTypesRequestType body) {
		return getConnection().getFundTypes(body);
	}

	@Override
	public PutImportProcessResponseType importAccountingJournal(ImportAccountingJournalRequestType body) {
		return getConnection().importAccountingJournal(body);
	}

	@Override
	public GetInvestorsResponseType getInvestors(GetInvestorsRequestType body) {
		return getConnection().getInvestors(body);
	}

	@Override
	public GetSupplierCategoriesResponseType getSupplierCategories(GetSupplierCategoriesRequestType body) {
		return getConnection().getSupplierCategories(body);
	}

	@Override
	public Get1099MISCAdjustmentsResponseType get1099MISCAdjustments(Get1099MISCAdjustmentsRequestType body) {
		return getConnection().get1099MISCAdjustments(body);
	}

	@Override
	public PutReceivableWriteoffCategoryResponseType putReceivableWriteoffCategory(PutReceivableWriteoffCategoryRequestType body) {
		return getConnection().putReceivableWriteoffCategory(body);
	}

	@Override
	public PutAwardPersonnelResponsibilityResponseType putAwardPersonnelResponsibility(
			PutAwardPersonnelResponsibilityRequestType body) {
		return getConnection().putAwardPersonnelResponsibility(body);
	}

	@Deprecated
	@Override
	public GetCompaniesResponseType getCompanies(GetCompaniesRequestType body) {
		return getConnection().getCompanies(body);
	}

	@Override
	public PutBasicGiftResponseType putBasicGift(PutBasicGiftRequestType body) {
		return getConnection().putBasicGift(body);
	}

	@Override
	public GetCostCentersResponseType getCostCenters(GetCostCentersRequestType body) {
		return getConnection().getCostCenters(body);
	}

	@Override
	public GetTaxApplicabilitiesResponseType getTaxApplicabilities(GetTaxApplicabilitiesRequestType body) {
		return getConnection().getTaxApplicabilities(body);
	}

	@Override
	public Get1099MiscsResponseType get1099MISCs(Get1099MiscsRequestType body) {
		return getConnection().get1099MISCs(body);
	}

	@Override
	public PutObjectClassSetResponseType putObjectClassSet(PutObjectClassSetRequestType body) {
		return getConnection().putObjectClassSet(body);
	}

	@Override
	public GetEffortCertificationTypesResponseType getEffortCertificationTypes(
			GetEffortCertificationTypesRequestType body) {
		return getConnection().getEffortCertificationTypes(body);
	}

	@Override
	public PutFundHierarchyResponseType putFundHierarchy(PutFundHierarchyRequestType body) {
		return getConnection().putFundHierarchy(body);
	}

	@Override
	public Put1042SIncomeCodeResponseType put1042SIncomeCode(Put1042SIncomeCodeRequestType body) {
		return getConnection().put1042SIncomeCode(body);
	}

	@Override
	public PutSupplierCategoryResponseType putSupplierCategory(PutSupplierCategoryRequestType body) {
		return getConnection().putSupplierCategory(body);
	}

	@Override
	public CancelAccountingJournalResponseType cancelAccountingJournal(CancelAccountingJournalRequestType body) {
		return getConnection().cancelAccountingJournal(body);
	}

	@Override
	public GetBasicGiftsResponseType getBasicGifts(GetBasicGiftsRequestType body) {
		return getConnection().getBasicGifts(body);
	}

	@Override
	public GetTaxCodesResponseType getTaxCodes(GetTaxCodesRequestType body) {
		return getConnection().getTaxCodes(body);
	}

	@Override
	public PutBusinessPlanDetailsResponseType putBusinessPlanDetails(PutBusinessPlanDetailsRequestType body) {
		return getConnection().putBusinessPlanDetails(body);
	}

	@Override
	public GetGiftsResponseType getGifts(GetGiftsRequestType body) {
		return getConnection().getGifts(body);
	}

	@Override
	public PutPaymentTypeResponseType putPaymentType(PutPaymentTypeRequestType body) {
		return getConnection().putPaymentType(body);
	}

	@Override
	public PutBeginningBalanceJournalResponseType putBeginningBalanceJournal(PutBeginningBalanceJournalRequestType body) {
		return getConnection().putBeginningBalanceJournal(body);
	}

	@Override
	public Get1099ElectronicFilingRunResponseType getCompany1099MISCData(Get1099DataRequestType body) {
		return getConnection().getCompany1099MISCData(body);
	}

	@Override
	public PutTaxAuthorityResponseType putTaxAuthority(PutTaxAuthorityRequestType body) {
		return getConnection().putTaxAuthority(body);
	}

	@Override
	public GetSpendCategoryHierarchiesResponseType getSpendCategoryHierarchies(GetSpendCategoryHierarchiesRequestType body) {
		return getConnection().getSpendCategoryHierarchies(body);
	}

	@Override
	public GetEffortCertificationEligibilityRulesResponseType getEffortCertificationEligibilityRules(
			GetEffortCertificationEligibilityRulesRequestType body) {
		return getConnection().getEffortCertificationEligibilityRules(body);
	}

	@Override
	public GetBasicGrantsResponseType getBasicGrants(GetBasicGrantsRequestType body) {
		return getConnection().getBasicGrants(body);
	}

	@Override
	public GetRevenueCategoryHierarchiesResponseType getRevenueCategoryHierarchies(
			GetRevenueCategoryHierarchiesRequestType body) {
		return getConnection().getRevenueCategoryHierarchies(body);
	}

	@Override
	public GetGrantHierarchiesResponseType getGrantHierarchies(GetGrantHierarchiesRequestType body) {
		return getConnection().getGrantHierarchies(body);
	}

	@Override
	public PutFundResponseType putFund(PutFundRequestType body) {
		return getConnection().putFund(body);
	}

	@Override
	public GetStatisticDefinitionsResponseType getStatisticDefinitions(GetStatisticDefinitionsRequestType body) {
		return getConnection().getStatisticDefinitions(body);
	}

	@Override
	public GetFundsResponseType getFunds(GetFundsRequestType body) {
		return getConnection().getFunds(body);
	}

	@Override
	public PutTaxCodeResponseType putTaxCode(PutTaxCodeRequestType body) {
		return getConnection().putTaxCode(body);
	}

	@Override
	public GetPaymentTermsResponseType getPaymentTerms(GetPaymentTermsRequestType body) {
		return getConnection().getPaymentTerms(body);
	}

	@Override
	public GetPositionBudgetsResponseType getPositionBudgets(GetPositionBudgetsRequestType body) {
		return getConnection().getPositionBudgets(body);
	}

	@Override
	public PutBudgetIncrementalResponseType putBudgetIncremental(PutBudgetIncrementalRequestType body) {
		return getConnection().putBudgetIncremental(body);
	}

	@Override
	public PutTaxRateResponseType putTaxRate(PutTaxRateRequestType body) {
		return getConnection().putTaxRate(body);
	}

	@Override
	public PutFundTypeResponseType putFundType(PutFundTypeRequestType body) {
		return getConnection().putFundType(body);
	}

	@Override
	public SubmitAccountingJournalResponseType submitAccountingJournal(SubmitAccountingJournalRequestType body) {
		return getConnection().submitAccountingJournal(body);
	}

	@Override
	public GetSurveysResponseType getSurveys(GetSurveysRequestType body) {
		return getConnection().getSurveys(body);
	}

	@Override
	public PutCustomerResponseType putBasicCustomer(PutBasicCustomerRequestType body) {
		return getConnection().putBasicCustomer(body);
	}

	@Override
	public GetPaymentsResponseType getPayments(GetPaymentsRequestType body) {
		return getConnection().getPayments(body);
	}

	@Override
	public CancelAccountingJournalResponseType unpostAccountingJournal(UnpostAccountingJournalRequestType body) {
		return getConnection().unpostAccountingJournal(body);
	}

	@Override
	public GetAccountSetsResponseType getAccountSets(GetAccountSetsRequestType body) {
		return getConnection().getAccountSets(body);
	}

	@Override
	public GetBusinessPlanDetailsResponseType getBusinessPlanDetails(GetBusinessPlanDetailsRequestType body) {
		return getConnection().getBusinessPlanDetails(body);
	}

	@Override
	public GetBasicSuppliersResponseType getBasicSuppliers(GetBasicSuppliersRequestType body) {
		return getConnection().getBasicSuppliers(body);
	}

	@Override
	public PutAccountSetResponseType putAccountSet(PutAccountSetRequestType body) {
		return getConnection().putAccountSet(body);
	}

	@Override
	public GetCustomValidationRulesResponseType getCustomValidationRules(GetCustomValidationRulesRequestType body) {
		return getConnection().getCustomValidationRules(body);
	}

	@Override
	public PutSpendCategoryHierarchyResponseType putSpendCategoryHierarchy(PutSpendCategoryHierarchyRequestType body) {
		return getConnection().putSpendCategoryHierarchy(body);
	}

	@Override
	public PutRevenueCategoryResponseType putRevenueCategory(PutRevenueCategoryRequestType body) {
		return getConnection().putRevenueCategory(body);
	}

	@Override
	public GetRevenueCategoriesResponseType getRevenueCategories(GetRevenueCategoriesRequestType body) {
		return getConnection().getRevenueCategories(body);
	}

	@Override
	public PutBeginningBalanceTranslationAmountsResponseType putBeginningBalanceTranslationAmounts(
			PutBeginningBalanceTranslationAmountsRequestType body) {
		return getConnection().putBeginningBalanceTranslationAmounts(body);
	}

	@Override
	public GetTaxAuthoritiesResponseType getTaxAuthorities(GetTaxAuthoritiesRequestType body) {
		return getConnection().getTaxAuthorities(body);
	}

	@Override
	public PutCurrencyConversionRateResponseType putCurrencyConversionRate(PutCurrencyConversionRateRequestType body) {
		return getConnection().putCurrencyConversionRate(body);
	}

	@Override
	public PutRevenueCategoryHierarchyResponseType putRevenueCategoryHierarchy(
			PutRevenueCategoryHierarchyRequestType body) {
		return getConnection().putRevenueCategoryHierarchy(body);
	}

	@Override
	public PutBusinessUnitResponseType putBusinessUnit(PutBusinessUnitRequestType body) {
		return getConnection().putBusinessUnit(body);
	}

	@Override
	public PutProjectResponseType putBasicProject(PutBasicProjectRequestType body) {
		return getConnection().putBasicProject(body);
	}

	@Override
	public PutBusinessEntityContactResponseType putBusinessEntityContact(PutBusinessEntityContactRequestType body) {
		return getConnection().putBusinessEntityContact(body);
	}

	@Override
	public GetOrganizationsResponseType getOrganizations(GetOrganizationsRequestType body) {
		return getConnection().getOrganizations(body);
	}

	@Override
	public PutRecurringJournalTemplateResponseType putRecurringJournalTemplate(
			PutRecurringJournalTemplateRequestType body) {
		return getConnection().putRecurringJournalTemplate(body);
	}

	@Override
	public GetReceivableWriteoffCategoriesResponseType getReceivableWriteoffCategories(
			GetReceivableWriteoffCategoriesRequestType body) {
		return getConnection().getReceivableWriteoffCategories(body);
	}

	@Override
	public GetAwardPersonnelResponsibilitiesResponseType getAwardPersonnelResponsibilities(
			GetAwardPersonnelResponsibilitiesRequestType body) {
		return getConnection().getAwardPersonnelResponsibilities(body);
	}

	@Override
	public PutLoanResponseType putLoan(PutLoanRequestType body) {
		return getConnection().putLoan(body);
	}

	@Override
	public GetObjectClassSetsResponseType getObjectClassSets(GetObjectClassSetsRequestType body) {
		return getConnection().getObjectClassSets(body);
	}

	@Override
	public PutTaxApplicabilityResponseType putTaxApplicability(PutTaxApplicabilityRequestType body) {
		return getConnection().putTaxApplicability(body);
	}

	@Override
	public PutSupplierResponseType putBasicSupplier(PutBasicSupplierRequestType body) {
		return getConnection().putBasicSupplier(body);
	}

	@Override
	public GetWorkdayCompaniesResponseType getWorkdayCompanies(GetWorkdayCompaniesRequestType body) {
		return getConnection().getWorkdayCompanies(body);
	}

	@Override
	public GetBeginningBalanceTranslationAmountsResponseType getBeginningBalanceTranslationAmounts(
			GetBeginningBalanceTranslationAmountsRequestType body) {
		return getConnection().getBeginningBalanceTranslationAmounts(body);
	}

	@Override
	public GetBusinessUnitHierarchiesResponseType getBusinessUnitHierarchies(
			GetBusinessUnitHierarchiesRequestType body) {
		return getConnection().getBusinessUnitHierarchies(body);
	}

	@Override
	public GetCustomValidationRulesResponseType getCustomValidationRulesWithoutDependencies(
			GetCustomValidationRulesWithoutDependenciesRequestType body) {
		return getConnection().getCustomValidationRulesWithoutDependencies(body);
	}

	@Override
	public GetTaxRatesResponseType getTaxRates(GetTaxRatesRequestType body)
			 {
		return getConnection().getTaxRates(body);
	}

	@Override
	public PutInvestorResponseType putInvestor(PutInvestorRequestType body) {
		return getConnection().putInvestor(body);
	}

	@Override
	public PutTaxCategoryResponseType putTaxCategory(PutTaxCategoryRequestType body) {
		return getConnection().putTaxCategory(body);
	}

	@Override
	public PutCurrencyConversionRatesResponseType putCurrencyConversionRates(PutCurrencyConversionRatesRequestType body) {
		return getConnection().putCurrencyConversionRates(body);
	}

	@Override
	public GetCurrencyConversionRatesResponseType getCurrencyConversionRates(GetCurrencyConversionRatesRequestType body) {
		return getConnection().getCurrencyConversionRates(body);
	}

	@Override
	public SubmitPositionBudgetResponseType submitPositionBudget(SubmitPositionBudgetRequestType body) {
		return getConnection().submitPositionBudget(body);
	}

	@Override
	public PutContingentWorkerTaxAuthorityFormTypeResponseType putContingentWorkerTaxAuthorityFormType(
			PutContingentWorkerTaxAuthorityFormTypeRequestType body) {
		return getConnection().putContingentWorkerTaxAuthorityFormType(body);
	}

	@Override
	public PutGrantResponseType putGrant(PutGrantRequestType body) {
		return getConnection().putGrant(body);
	}

	@Override
	public GetAccountSetsResponseType getAccountSetsWithoutDependencies(GetAccountSetsWithoutDependenciesRequestType body) {
		return getConnection().getAccountSetsWithoutDependencies(body);
	}

	@Override
	public GetCustomerCategoriesResponseType getCustomerCategories(GetCustomerCategoriesRequestType body) {
		return getConnection().getCustomerCategories(body);
	}
	
	@Override
	public GetLoanReferralTypesResponseType getLoanReferralTypes(GetLoanReferralTypesRequestType body){
		return getConnection().getLoanReferralTypes(body);
	}


	@Override
	public PutLoanInvestorTypeResponseType putLoanInvestorType(PutLoanInvestorTypeRequestType body){
		return getConnection().putLoanInvestorType(body);
	}


	@Override
	public GetLoanInvestorTypesResponseType getLoanInvestorTypes(GetLoanInvestorTypesRequestType body){
		return getConnection().getLoanInvestorTypes(body);
	}


	@Override
	public PutLoanReferralTypeResponseType putLoanReferralType(PutLoanReferralTypeRequestType body){
		return getConnection().putLoanReferralType(body);
	}


	@Override
	public PutImportProcessResponseType importBudgetDetailsIncremental(ImportBudgetDetailsIncrementalHighVolumeRequestType body){
		return getConnection().importBudgetDetailsIncremental(body);
	}


	@Override
	public PutThirdPartyCalculatedTaxInformationResponseType putThirdPartyCalculatedTaxInformation(PutThirdPartyCalculatedTaxInformationRequestType body){
		return getConnection().putThirdPartyCalculatedTaxInformation(body);
	}


	@Override
	public PutImportProcessResponseType importBudgetDetails(ImportBudgetDetailsRequestType body){
		return getConnection().importBudgetDetails(body);
	}


	@Override
	public PutImportProcessResponseType importBudgetAmendment(ImportBudgetAmendmentRequestType body){
		return getConnection().importBudgetAmendment(body);
	}

}
