
package com.workday.financial;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.datatype.XMLGregorianCalendar;


/**
 * Element containing all 1099 Electronic Filing Run Data
 * 
 * <p>Java class for XMLNAME_1099_Electronic_Filing_Run_DataType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="XMLNAME_1099_Electronic_Filing_Run_DataType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Electronic_Filing_1099_Run_Reference" type="{urn:com.workday/bsvc}Unique_IdentifierObjectType" minOccurs="0"/>
 *         &lt;element name="Calendar_Year" type="{http://www.w3.org/2001/XMLSchema}date" minOccurs="0"/>
 *         &lt;element name="Transmitter_Company_Data" type="{urn:com.workday/bsvc}XMLNAME_1099_Company_DataType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="IRS_1099_Electronic_Filing_Run_Correction" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Test_file_for_1099_Electronic_Filing_Run" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="IRS_1099_Electronic_Filing_Replacement" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Person_Data" type="{urn:com.workday/bsvc}Person_DataType" minOccurs="0"/>
 *         &lt;element name="Count_of_Payors" minOccurs="0">
 *           &lt;simpleType>
 *             &lt;restriction base="{http://www.w3.org/2001/XMLSchema}decimal">
 *               &lt;totalDigits value="12"/>
 *               &lt;minInclusive value="0"/>
 *               &lt;fractionDigits value="0"/>
 *             &lt;/restriction>
 *           &lt;/simpleType>
 *         &lt;/element>
 *         &lt;element name="Count_of_1099_Miscs_for_1099_Electronic_Filing_Run" minOccurs="0">
 *           &lt;simpleType>
 *             &lt;restriction base="{http://www.w3.org/2001/XMLSchema}decimal">
 *               &lt;totalDigits value="12"/>
 *               &lt;minInclusive value="0"/>
 *               &lt;fractionDigits value="0"/>
 *             &lt;/restriction>
 *           &lt;/simpleType>
 *         &lt;/element>
 *         &lt;element name="IRS_1099_Run_Data" type="{urn:com.workday/bsvc}XMLNAME_1099_Run_DataType" maxOccurs="unbounded" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "XMLNAME_1099_Electronic_Filing_Run_DataType", propOrder = {
    "electronicFiling1099RunReference",
    "calendarYear",
    "transmitterCompanyData",
    "irs1099ElectronicFilingRunCorrection",
    "testFileFor1099ElectronicFilingRun",
    "irs1099ElectronicFilingReplacement",
    "personData",
    "countOfPayors",
    "countOf1099MiscsFor1099ElectronicFilingRun",
    "irs1099RunData"
})
public class XMLNAME1099ElectronicFilingRunDataType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Electronic_Filing_1099_Run_Reference")
    protected UniqueIdentifierObjectType electronicFiling1099RunReference;
    @XmlElement(name = "Calendar_Year")
    @XmlSchemaType(name = "date")
    protected XMLGregorianCalendar calendarYear;
    @XmlElement(name = "Transmitter_Company_Data")
    protected List<XMLNAME1099CompanyDataType> transmitterCompanyData;
    @XmlElement(name = "IRS_1099_Electronic_Filing_Run_Correction")
    protected Boolean irs1099ElectronicFilingRunCorrection;
    @XmlElement(name = "Test_file_for_1099_Electronic_Filing_Run")
    protected Boolean testFileFor1099ElectronicFilingRun;
    @XmlElement(name = "IRS_1099_Electronic_Filing_Replacement")
    protected Boolean irs1099ElectronicFilingReplacement;
    @XmlElement(name = "Person_Data")
    protected PersonDataType personData;
    @XmlElement(name = "Count_of_Payors")
    protected BigDecimal countOfPayors;
    @XmlElement(name = "Count_of_1099_Miscs_for_1099_Electronic_Filing_Run")
    protected BigDecimal countOf1099MiscsFor1099ElectronicFilingRun;
    @XmlElement(name = "IRS_1099_Run_Data")
    protected List<XMLNAME1099RunDataType> irs1099RunData;

    /**
     * Gets the value of the electronicFiling1099RunReference property.
     * 
     * @return
     *     possible object is
     *     {@link UniqueIdentifierObjectType }
     *     
     */
    public UniqueIdentifierObjectType getElectronicFiling1099RunReference() {
        return electronicFiling1099RunReference;
    }

    /**
     * Sets the value of the electronicFiling1099RunReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link UniqueIdentifierObjectType }
     *     
     */
    public void setElectronicFiling1099RunReference(UniqueIdentifierObjectType value) {
        this.electronicFiling1099RunReference = value;
    }

    /**
     * Gets the value of the calendarYear property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getCalendarYear() {
        return calendarYear;
    }

    /**
     * Sets the value of the calendarYear property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setCalendarYear(XMLGregorianCalendar value) {
        this.calendarYear = value;
    }

    /**
     * Gets the value of the transmitterCompanyData property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the transmitterCompanyData property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getTransmitterCompanyData().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link XMLNAME1099CompanyDataType }
     * 
     * 
     */
    public List<XMLNAME1099CompanyDataType> getTransmitterCompanyData() {
        if (transmitterCompanyData == null) {
            transmitterCompanyData = new ArrayList<XMLNAME1099CompanyDataType>();
        }
        return this.transmitterCompanyData;
    }

    /**
     * Gets the value of the irs1099ElectronicFilingRunCorrection property.
     * This getter has been renamed from isIRS1099ElectronicFilingRunCorrection() to getIRS1099ElectronicFilingRunCorrection() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getIRS1099ElectronicFilingRunCorrection() {
        return irs1099ElectronicFilingRunCorrection;
    }

    /**
     * Sets the value of the irs1099ElectronicFilingRunCorrection property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setIRS1099ElectronicFilingRunCorrection(Boolean value) {
        this.irs1099ElectronicFilingRunCorrection = value;
    }

    /**
     * Gets the value of the testFileFor1099ElectronicFilingRun property.
     * This getter has been renamed from isTestFileFor1099ElectronicFilingRun() to getTestFileFor1099ElectronicFilingRun() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getTestFileFor1099ElectronicFilingRun() {
        return testFileFor1099ElectronicFilingRun;
    }

    /**
     * Sets the value of the testFileFor1099ElectronicFilingRun property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setTestFileFor1099ElectronicFilingRun(Boolean value) {
        this.testFileFor1099ElectronicFilingRun = value;
    }

    /**
     * Gets the value of the irs1099ElectronicFilingReplacement property.
     * This getter has been renamed from isIRS1099ElectronicFilingReplacement() to getIRS1099ElectronicFilingReplacement() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getIRS1099ElectronicFilingReplacement() {
        return irs1099ElectronicFilingReplacement;
    }

    /**
     * Sets the value of the irs1099ElectronicFilingReplacement property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setIRS1099ElectronicFilingReplacement(Boolean value) {
        this.irs1099ElectronicFilingReplacement = value;
    }

    /**
     * Gets the value of the personData property.
     * 
     * @return
     *     possible object is
     *     {@link PersonDataType }
     *     
     */
    public PersonDataType getPersonData() {
        return personData;
    }

    /**
     * Sets the value of the personData property.
     * 
     * @param value
     *     allowed object is
     *     {@link PersonDataType }
     *     
     */
    public void setPersonData(PersonDataType value) {
        this.personData = value;
    }

    /**
     * Gets the value of the countOfPayors property.
     * 
     * @return
     *     possible object is
     *     {@link BigDecimal }
     *     
     */
    public BigDecimal getCountOfPayors() {
        return countOfPayors;
    }

    /**
     * Sets the value of the countOfPayors property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigDecimal }
     *     
     */
    public void setCountOfPayors(BigDecimal value) {
        this.countOfPayors = value;
    }

    /**
     * Gets the value of the countOf1099MiscsFor1099ElectronicFilingRun property.
     * 
     * @return
     *     possible object is
     *     {@link BigDecimal }
     *     
     */
    public BigDecimal getCountOf1099MiscsFor1099ElectronicFilingRun() {
        return countOf1099MiscsFor1099ElectronicFilingRun;
    }

    /**
     * Sets the value of the countOf1099MiscsFor1099ElectronicFilingRun property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigDecimal }
     *     
     */
    public void setCountOf1099MiscsFor1099ElectronicFilingRun(BigDecimal value) {
        this.countOf1099MiscsFor1099ElectronicFilingRun = value;
    }

    /**
     * Gets the value of the irs1099RunData property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the irs1099RunData property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getIRS1099RunData().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link XMLNAME1099RunDataType }
     * 
     * 
     */
    public List<XMLNAME1099RunDataType> getIRS1099RunData() {
        if (irs1099RunData == null) {
            irs1099RunData = new ArrayList<XMLNAME1099RunDataType>();
        }
        return this.irs1099RunData;
    }

    /**
     * Sets the value of the transmitterCompanyData property.
     * 
     * @param transmitterCompanyData
     *     allowed object is
     *     {@link XMLNAME1099CompanyDataType }
     *     
     */
    public void setTransmitterCompanyData(List<XMLNAME1099CompanyDataType> transmitterCompanyData) {
        this.transmitterCompanyData = transmitterCompanyData;
    }

    /**
     * Sets the value of the irs1099RunData property.
     * 
     * @param irs1099RunData
     *     allowed object is
     *     {@link XMLNAME1099RunDataType }
     *     
     */
    public void setIRS1099RunData(List<XMLNAME1099RunDataType> irs1099RunData) {
        this.irs1099RunData = irs1099RunData;
    }

}
