
package com.workday.financial;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;


/**
 * Element containing all 1099 Company data
 * 
 * <p>Java class for XMLNAME_1099_Company_DataType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="XMLNAME_1099_Company_DataType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Company_Reference" type="{urn:com.workday/bsvc}CompanyObjectType" minOccurs="0"/>
 *         &lt;element name="Organization_Name" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Tax_ID" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="TCC_ID" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Foreign_Entity_Indicator" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Primary_Fully_Composed_Address_without_Country" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Address_Data" type="{urn:com.workday/bsvc}Address_Information_DataType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Phone_Number" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "XMLNAME_1099_Company_DataType", propOrder = {
    "companyReference",
    "organizationName",
    "taxID",
    "tccid",
    "foreignEntityIndicator",
    "primaryFullyComposedAddressWithoutCountry",
    "addressData",
    "phoneNumber"
})
public class XMLNAME1099CompanyDataType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Company_Reference")
    protected CompanyObjectType companyReference;
    @XmlElement(name = "Organization_Name")
    protected String organizationName;
    @XmlElement(name = "Tax_ID")
    protected String taxID;
    @XmlElement(name = "TCC_ID")
    protected String tccid;
    @XmlElement(name = "Foreign_Entity_Indicator")
    protected Boolean foreignEntityIndicator;
    @XmlElement(name = "Primary_Fully_Composed_Address_without_Country")
    protected String primaryFullyComposedAddressWithoutCountry;
    @XmlElement(name = "Address_Data")
    protected List<AddressInformationDataType> addressData;
    @XmlElement(name = "Phone_Number")
    protected String phoneNumber;

    /**
     * Gets the value of the companyReference property.
     * 
     * @return
     *     possible object is
     *     {@link CompanyObjectType }
     *     
     */
    public CompanyObjectType getCompanyReference() {
        return companyReference;
    }

    /**
     * Sets the value of the companyReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link CompanyObjectType }
     *     
     */
    public void setCompanyReference(CompanyObjectType value) {
        this.companyReference = value;
    }

    /**
     * Gets the value of the organizationName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getOrganizationName() {
        return organizationName;
    }

    /**
     * Sets the value of the organizationName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setOrganizationName(String value) {
        this.organizationName = value;
    }

    /**
     * Gets the value of the taxID property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getTaxID() {
        return taxID;
    }

    /**
     * Sets the value of the taxID property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setTaxID(String value) {
        this.taxID = value;
    }

    /**
     * Gets the value of the tccid property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getTCCID() {
        return tccid;
    }

    /**
     * Sets the value of the tccid property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setTCCID(String value) {
        this.tccid = value;
    }

    /**
     * Gets the value of the foreignEntityIndicator property.
     * This getter has been renamed from isForeignEntityIndicator() to getForeignEntityIndicator() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getForeignEntityIndicator() {
        return foreignEntityIndicator;
    }

    /**
     * Sets the value of the foreignEntityIndicator property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setForeignEntityIndicator(Boolean value) {
        this.foreignEntityIndicator = value;
    }

    /**
     * Gets the value of the primaryFullyComposedAddressWithoutCountry property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getPrimaryFullyComposedAddressWithoutCountry() {
        return primaryFullyComposedAddressWithoutCountry;
    }

    /**
     * Sets the value of the primaryFullyComposedAddressWithoutCountry property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setPrimaryFullyComposedAddressWithoutCountry(String value) {
        this.primaryFullyComposedAddressWithoutCountry = value;
    }

    /**
     * Gets the value of the addressData property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the addressData property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getAddressData().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AddressInformationDataType }
     * 
     * 
     */
    public List<AddressInformationDataType> getAddressData() {
        if (addressData == null) {
            addressData = new ArrayList<AddressInformationDataType>();
        }
        return this.addressData;
    }

    /**
     * Gets the value of the phoneNumber property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getPhoneNumber() {
        return phoneNumber;
    }

    /**
     * Sets the value of the phoneNumber property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setPhoneNumber(String value) {
        this.phoneNumber = value;
    }

    /**
     * Sets the value of the addressData property.
     * 
     * @param addressData
     *     allowed object is
     *     {@link AddressInformationDataType }
     *     
     */
    public void setAddressData(List<AddressInformationDataType> addressData) {
        this.addressData = addressData;
    }

}
