
package com.workday.financial;

import java.io.Serializable;
import java.math.BigDecimal;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;


/**
 * Element containing all Tax Rate data
 * 
 * <p>Java class for Tax_Rate_DataType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Tax_Rate_DataType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Tax_Rate_ID" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Tax_Rate_Name" type="{http://www.w3.org/2001/XMLSchema}string"/>
 *         &lt;element name="Country_Reference" type="{urn:com.workday/bsvc}CountryObjectType"/>
 *         &lt;element name="Tax_Rate" minOccurs="0">
 *           &lt;simpleType>
 *             &lt;restriction base="{http://www.w3.org/2001/XMLSchema}decimal">
 *               &lt;totalDigits value="6"/>
 *               &lt;minInclusive value="0"/>
 *               &lt;fractionDigits value="3"/>
 *             &lt;/restriction>
 *           &lt;/simpleType>
 *         &lt;/element>
 *         &lt;element name="Tax_Authority_Reference" type="{urn:com.workday/bsvc}Tax_AuthorityObjectType"/>
 *         &lt;element name="Tax_Category_Reference" type="{urn:com.workday/bsvc}Tax_CategoryObjectType"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Tax_Rate_DataType", propOrder = {
    "taxRateID",
    "taxRateName",
    "countryReference",
    "taxRate",
    "taxAuthorityReference",
    "taxCategoryReference"
})
public class TaxRateDataType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Tax_Rate_ID")
    protected String taxRateID;
    @XmlElement(name = "Tax_Rate_Name", required = true)
    protected String taxRateName;
    @XmlElement(name = "Country_Reference", required = true)
    protected CountryObjectType countryReference;
    @XmlElement(name = "Tax_Rate")
    protected BigDecimal taxRate;
    @XmlElement(name = "Tax_Authority_Reference", required = true)
    protected TaxAuthorityObjectType taxAuthorityReference;
    @XmlElement(name = "Tax_Category_Reference", required = true)
    protected TaxCategoryObjectType taxCategoryReference;

    /**
     * Gets the value of the taxRateID property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getTaxRateID() {
        return taxRateID;
    }

    /**
     * Sets the value of the taxRateID property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setTaxRateID(String value) {
        this.taxRateID = value;
    }

    /**
     * Gets the value of the taxRateName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getTaxRateName() {
        return taxRateName;
    }

    /**
     * Sets the value of the taxRateName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setTaxRateName(String value) {
        this.taxRateName = value;
    }

    /**
     * Gets the value of the countryReference property.
     * 
     * @return
     *     possible object is
     *     {@link CountryObjectType }
     *     
     */
    public CountryObjectType getCountryReference() {
        return countryReference;
    }

    /**
     * Sets the value of the countryReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link CountryObjectType }
     *     
     */
    public void setCountryReference(CountryObjectType value) {
        this.countryReference = value;
    }

    /**
     * Gets the value of the taxRate property.
     * 
     * @return
     *     possible object is
     *     {@link BigDecimal }
     *     
     */
    public BigDecimal getTaxRate() {
        return taxRate;
    }

    /**
     * Sets the value of the taxRate property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigDecimal }
     *     
     */
    public void setTaxRate(BigDecimal value) {
        this.taxRate = value;
    }

    /**
     * Gets the value of the taxAuthorityReference property.
     * 
     * @return
     *     possible object is
     *     {@link TaxAuthorityObjectType }
     *     
     */
    public TaxAuthorityObjectType getTaxAuthorityReference() {
        return taxAuthorityReference;
    }

    /**
     * Sets the value of the taxAuthorityReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link TaxAuthorityObjectType }
     *     
     */
    public void setTaxAuthorityReference(TaxAuthorityObjectType value) {
        this.taxAuthorityReference = value;
    }

    /**
     * Gets the value of the taxCategoryReference property.
     * 
     * @return
     *     possible object is
     *     {@link TaxCategoryObjectType }
     *     
     */
    public TaxCategoryObjectType getTaxCategoryReference() {
        return taxCategoryReference;
    }

    /**
     * Sets the value of the taxCategoryReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link TaxCategoryObjectType }
     *     
     */
    public void setTaxCategoryReference(TaxCategoryObjectType value) {
        this.taxCategoryReference = value;
    }

}
