
package com.workday.financial;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;


/**
 * Element containing all Tax Code data
 * 
 * <p>Java class for Tax_Code_DataType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Tax_Code_DataType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Tax_Code_ID" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Tax_Code_Name" type="{http://www.w3.org/2001/XMLSchema}string"/>
 *         &lt;element name="Country_Reference" type="{urn:com.workday/bsvc}CountryObjectType"/>
 *         &lt;element name="Exempt" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Tax_Rate_Reference" type="{urn:com.workday/bsvc}Tax_RateObjectType" maxOccurs="unbounded" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Tax_Code_DataType", propOrder = {
    "taxCodeID",
    "taxCodeName",
    "countryReference",
    "exempt",
    "taxRateReference"
})
public class TaxCodeDataType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Tax_Code_ID")
    protected String taxCodeID;
    @XmlElement(name = "Tax_Code_Name", required = true)
    protected String taxCodeName;
    @XmlElement(name = "Country_Reference", required = true)
    protected CountryObjectType countryReference;
    @XmlElement(name = "Exempt")
    protected Boolean exempt;
    @XmlElement(name = "Tax_Rate_Reference")
    protected List<TaxRateObjectType> taxRateReference;

    /**
     * Gets the value of the taxCodeID property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getTaxCodeID() {
        return taxCodeID;
    }

    /**
     * Sets the value of the taxCodeID property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setTaxCodeID(String value) {
        this.taxCodeID = value;
    }

    /**
     * Gets the value of the taxCodeName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getTaxCodeName() {
        return taxCodeName;
    }

    /**
     * Sets the value of the taxCodeName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setTaxCodeName(String value) {
        this.taxCodeName = value;
    }

    /**
     * Gets the value of the countryReference property.
     * 
     * @return
     *     possible object is
     *     {@link CountryObjectType }
     *     
     */
    public CountryObjectType getCountryReference() {
        return countryReference;
    }

    /**
     * Sets the value of the countryReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link CountryObjectType }
     *     
     */
    public void setCountryReference(CountryObjectType value) {
        this.countryReference = value;
    }

    /**
     * Gets the value of the exempt property.
     * This getter has been renamed from isExempt() to getExempt() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getExempt() {
        return exempt;
    }

    /**
     * Sets the value of the exempt property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setExempt(Boolean value) {
        this.exempt = value;
    }

    /**
     * Gets the value of the taxRateReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the taxRateReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getTaxRateReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TaxRateObjectType }
     * 
     * 
     */
    public List<TaxRateObjectType> getTaxRateReference() {
        if (taxRateReference == null) {
            taxRateReference = new ArrayList<TaxRateObjectType>();
        }
        return this.taxRateReference;
    }

    /**
     * Sets the value of the taxRateReference property.
     * 
     * @param taxRateReference
     *     allowed object is
     *     {@link TaxRateObjectType }
     *     
     */
    public void setTaxRateReference(List<TaxRateObjectType> taxRateReference) {
        this.taxRateReference = taxRateReference;
    }

}
