
package com.workday.financial;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;


/**
 * Element containing all Tax Authority data
 * 
 * <p>Java class for Tax_Authority_DataType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Tax_Authority_DataType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Tax_Authority_ID" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Tax_Authority_Reference_ID" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Tax_Authority_Name" type="{http://www.w3.org/2001/XMLSchema}string"/>
 *         &lt;choice>
 *           &lt;element name="Create_Tax_Authority_from_Customer_Reference" type="{urn:com.workday/bsvc}Billable_EntityObjectType" minOccurs="0"/>
 *           &lt;element name="Create_Tax_Authority_from_Financial_Institution_Reference" type="{urn:com.workday/bsvc}Financial_InstitutionObjectType" minOccurs="0"/>
 *           &lt;element name="Create_Tax_Authority_from_Supplier_Reference" type="{urn:com.workday/bsvc}SupplierObjectType" minOccurs="0"/>
 *           &lt;element name="Create_Tax_Authority_from_Investor_Reference" type="{urn:com.workday/bsvc}InvestorObjectType" minOccurs="0"/>
 *         &lt;/choice>
 *         &lt;element name="Business_Entity_Data" type="{urn:com.workday/bsvc}Business_Entity_WWS_DataType"/>
 *         &lt;element name="Default_Payment_Type_Reference" type="{urn:com.workday/bsvc}Payment_TypeObjectType" minOccurs="0"/>
 *         &lt;element name="Settlement_Account_Data" type="{urn:com.workday/bsvc}Settlement_Account_WWS_DataType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Attachment_Data" type="{urn:com.workday/bsvc}Financials_Attachment_DataType" maxOccurs="unbounded" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Tax_Authority_DataType", propOrder = {
    "taxAuthorityID",
    "taxAuthorityReferenceID",
    "taxAuthorityName",
    "createTaxAuthorityFromCustomerReference",
    "createTaxAuthorityFromFinancialInstitutionReference",
    "createTaxAuthorityFromSupplierReference",
    "createTaxAuthorityFromInvestorReference",
    "businessEntityData",
    "defaultPaymentTypeReference",
    "settlementAccountData",
    "attachmentData"
})
public class TaxAuthorityDataType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Tax_Authority_ID")
    protected String taxAuthorityID;
    @XmlElement(name = "Tax_Authority_Reference_ID")
    protected String taxAuthorityReferenceID;
    @XmlElement(name = "Tax_Authority_Name", required = true)
    protected String taxAuthorityName;
    @XmlElement(name = "Create_Tax_Authority_from_Customer_Reference")
    protected BillableEntityObjectType createTaxAuthorityFromCustomerReference;
    @XmlElement(name = "Create_Tax_Authority_from_Financial_Institution_Reference")
    protected FinancialInstitutionObjectType createTaxAuthorityFromFinancialInstitutionReference;
    @XmlElement(name = "Create_Tax_Authority_from_Supplier_Reference")
    protected SupplierObjectType createTaxAuthorityFromSupplierReference;
    @XmlElement(name = "Create_Tax_Authority_from_Investor_Reference")
    protected InvestorObjectType createTaxAuthorityFromInvestorReference;
    @XmlElement(name = "Business_Entity_Data", required = true)
    protected BusinessEntityWWSDataType businessEntityData;
    @XmlElement(name = "Default_Payment_Type_Reference")
    protected PaymentTypeObjectType defaultPaymentTypeReference;
    @XmlElement(name = "Settlement_Account_Data")
    protected List<SettlementAccountWWSDataType> settlementAccountData;
    @XmlElement(name = "Attachment_Data")
    protected List<FinancialsAttachmentDataType> attachmentData;

    /**
     * Gets the value of the taxAuthorityID property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getTaxAuthorityID() {
        return taxAuthorityID;
    }

    /**
     * Sets the value of the taxAuthorityID property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setTaxAuthorityID(String value) {
        this.taxAuthorityID = value;
    }

    /**
     * Gets the value of the taxAuthorityReferenceID property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getTaxAuthorityReferenceID() {
        return taxAuthorityReferenceID;
    }

    /**
     * Sets the value of the taxAuthorityReferenceID property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setTaxAuthorityReferenceID(String value) {
        this.taxAuthorityReferenceID = value;
    }

    /**
     * Gets the value of the taxAuthorityName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getTaxAuthorityName() {
        return taxAuthorityName;
    }

    /**
     * Sets the value of the taxAuthorityName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setTaxAuthorityName(String value) {
        this.taxAuthorityName = value;
    }

    /**
     * Gets the value of the createTaxAuthorityFromCustomerReference property.
     * 
     * @return
     *     possible object is
     *     {@link BillableEntityObjectType }
     *     
     */
    public BillableEntityObjectType getCreateTaxAuthorityFromCustomerReference() {
        return createTaxAuthorityFromCustomerReference;
    }

    /**
     * Sets the value of the createTaxAuthorityFromCustomerReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link BillableEntityObjectType }
     *     
     */
    public void setCreateTaxAuthorityFromCustomerReference(BillableEntityObjectType value) {
        this.createTaxAuthorityFromCustomerReference = value;
    }

    /**
     * Gets the value of the createTaxAuthorityFromFinancialInstitutionReference property.
     * 
     * @return
     *     possible object is
     *     {@link FinancialInstitutionObjectType }
     *     
     */
    public FinancialInstitutionObjectType getCreateTaxAuthorityFromFinancialInstitutionReference() {
        return createTaxAuthorityFromFinancialInstitutionReference;
    }

    /**
     * Sets the value of the createTaxAuthorityFromFinancialInstitutionReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link FinancialInstitutionObjectType }
     *     
     */
    public void setCreateTaxAuthorityFromFinancialInstitutionReference(FinancialInstitutionObjectType value) {
        this.createTaxAuthorityFromFinancialInstitutionReference = value;
    }

    /**
     * Gets the value of the createTaxAuthorityFromSupplierReference property.
     * 
     * @return
     *     possible object is
     *     {@link SupplierObjectType }
     *     
     */
    public SupplierObjectType getCreateTaxAuthorityFromSupplierReference() {
        return createTaxAuthorityFromSupplierReference;
    }

    /**
     * Sets the value of the createTaxAuthorityFromSupplierReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link SupplierObjectType }
     *     
     */
    public void setCreateTaxAuthorityFromSupplierReference(SupplierObjectType value) {
        this.createTaxAuthorityFromSupplierReference = value;
    }

    /**
     * Gets the value of the createTaxAuthorityFromInvestorReference property.
     * 
     * @return
     *     possible object is
     *     {@link InvestorObjectType }
     *     
     */
    public InvestorObjectType getCreateTaxAuthorityFromInvestorReference() {
        return createTaxAuthorityFromInvestorReference;
    }

    /**
     * Sets the value of the createTaxAuthorityFromInvestorReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link InvestorObjectType }
     *     
     */
    public void setCreateTaxAuthorityFromInvestorReference(InvestorObjectType value) {
        this.createTaxAuthorityFromInvestorReference = value;
    }

    /**
     * Gets the value of the businessEntityData property.
     * 
     * @return
     *     possible object is
     *     {@link BusinessEntityWWSDataType }
     *     
     */
    public BusinessEntityWWSDataType getBusinessEntityData() {
        return businessEntityData;
    }

    /**
     * Sets the value of the businessEntityData property.
     * 
     * @param value
     *     allowed object is
     *     {@link BusinessEntityWWSDataType }
     *     
     */
    public void setBusinessEntityData(BusinessEntityWWSDataType value) {
        this.businessEntityData = value;
    }

    /**
     * Gets the value of the defaultPaymentTypeReference property.
     * 
     * @return
     *     possible object is
     *     {@link PaymentTypeObjectType }
     *     
     */
    public PaymentTypeObjectType getDefaultPaymentTypeReference() {
        return defaultPaymentTypeReference;
    }

    /**
     * Sets the value of the defaultPaymentTypeReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link PaymentTypeObjectType }
     *     
     */
    public void setDefaultPaymentTypeReference(PaymentTypeObjectType value) {
        this.defaultPaymentTypeReference = value;
    }

    /**
     * Gets the value of the settlementAccountData property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the settlementAccountData property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getSettlementAccountData().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link SettlementAccountWWSDataType }
     * 
     * 
     */
    public List<SettlementAccountWWSDataType> getSettlementAccountData() {
        if (settlementAccountData == null) {
            settlementAccountData = new ArrayList<SettlementAccountWWSDataType>();
        }
        return this.settlementAccountData;
    }

    /**
     * Gets the value of the attachmentData property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the attachmentData property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getAttachmentData().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link FinancialsAttachmentDataType }
     * 
     * 
     */
    public List<FinancialsAttachmentDataType> getAttachmentData() {
        if (attachmentData == null) {
            attachmentData = new ArrayList<FinancialsAttachmentDataType>();
        }
        return this.attachmentData;
    }

    /**
     * Sets the value of the settlementAccountData property.
     * 
     * @param settlementAccountData
     *     allowed object is
     *     {@link SettlementAccountWWSDataType }
     *     
     */
    public void setSettlementAccountData(List<SettlementAccountWWSDataType> settlementAccountData) {
        this.settlementAccountData = settlementAccountData;
    }

    /**
     * Sets the value of the attachmentData property.
     * 
     * @param attachmentData
     *     allowed object is
     *     {@link FinancialsAttachmentDataType }
     *     
     */
    public void setAttachmentData(List<FinancialsAttachmentDataType> attachmentData) {
        this.attachmentData = attachmentData;
    }

}
