
package com.workday.financial;

import java.io.Serializable;
import java.math.BigDecimal;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;


/**
 * Tax Applicability Data
 * 
 * <p>Java class for Tax_Applicability_DataType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Tax_Applicability_DataType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Tax_Applicability_ID" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Tax_Applicability_Code" type="{http://www.w3.org/2001/XMLSchema}string"/>
 *         &lt;element name="Taxable" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Recoverable" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Tax_Recoverability_Reference" type="{urn:com.workday/bsvc}Tax_RecoverabilityObjectType" minOccurs="0"/>
 *         &lt;element name="Partially_Recoverable_Percentage" minOccurs="0">
 *           &lt;simpleType>
 *             &lt;restriction base="{http://www.w3.org/2001/XMLSchema}decimal">
 *               &lt;totalDigits value="3"/>
 *               &lt;minInclusive value="0"/>
 *               &lt;fractionDigits value="0"/>
 *             &lt;/restriction>
 *           &lt;/simpleType>
 *         &lt;/element>
 *         &lt;element name="Allocate_Non_Recoverable_Tax" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Tax_Applicability_DataType", propOrder = {
    "taxApplicabilityID",
    "taxApplicabilityCode",
    "taxable",
    "recoverable",
    "taxRecoverabilityReference",
    "partiallyRecoverablePercentage",
    "allocateNonRecoverableTax"
})
public class TaxApplicabilityDataType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Tax_Applicability_ID")
    protected String taxApplicabilityID;
    @XmlElement(name = "Tax_Applicability_Code", required = true)
    protected String taxApplicabilityCode;
    @XmlElement(name = "Taxable")
    protected Boolean taxable;
    @XmlElement(name = "Recoverable")
    protected Boolean recoverable;
    @XmlElement(name = "Tax_Recoverability_Reference")
    protected TaxRecoverabilityObjectType taxRecoverabilityReference;
    @XmlElement(name = "Partially_Recoverable_Percentage")
    protected BigDecimal partiallyRecoverablePercentage;
    @XmlElement(name = "Allocate_Non_Recoverable_Tax")
    protected Boolean allocateNonRecoverableTax;

    /**
     * Gets the value of the taxApplicabilityID property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getTaxApplicabilityID() {
        return taxApplicabilityID;
    }

    /**
     * Sets the value of the taxApplicabilityID property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setTaxApplicabilityID(String value) {
        this.taxApplicabilityID = value;
    }

    /**
     * Gets the value of the taxApplicabilityCode property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getTaxApplicabilityCode() {
        return taxApplicabilityCode;
    }

    /**
     * Sets the value of the taxApplicabilityCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setTaxApplicabilityCode(String value) {
        this.taxApplicabilityCode = value;
    }

    /**
     * Gets the value of the taxable property.
     * This getter has been renamed from isTaxable() to getTaxable() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getTaxable() {
        return taxable;
    }

    /**
     * Sets the value of the taxable property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setTaxable(Boolean value) {
        this.taxable = value;
    }

    /**
     * Gets the value of the recoverable property.
     * This getter has been renamed from isRecoverable() to getRecoverable() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getRecoverable() {
        return recoverable;
    }

    /**
     * Sets the value of the recoverable property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setRecoverable(Boolean value) {
        this.recoverable = value;
    }

    /**
     * Gets the value of the taxRecoverabilityReference property.
     * 
     * @return
     *     possible object is
     *     {@link TaxRecoverabilityObjectType }
     *     
     */
    public TaxRecoverabilityObjectType getTaxRecoverabilityReference() {
        return taxRecoverabilityReference;
    }

    /**
     * Sets the value of the taxRecoverabilityReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link TaxRecoverabilityObjectType }
     *     
     */
    public void setTaxRecoverabilityReference(TaxRecoverabilityObjectType value) {
        this.taxRecoverabilityReference = value;
    }

    /**
     * Gets the value of the partiallyRecoverablePercentage property.
     * 
     * @return
     *     possible object is
     *     {@link BigDecimal }
     *     
     */
    public BigDecimal getPartiallyRecoverablePercentage() {
        return partiallyRecoverablePercentage;
    }

    /**
     * Sets the value of the partiallyRecoverablePercentage property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigDecimal }
     *     
     */
    public void setPartiallyRecoverablePercentage(BigDecimal value) {
        this.partiallyRecoverablePercentage = value;
    }

    /**
     * Gets the value of the allocateNonRecoverableTax property.
     * This getter has been renamed from isAllocateNonRecoverableTax() to getAllocateNonRecoverableTax() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getAllocateNonRecoverableTax() {
        return allocateNonRecoverableTax;
    }

    /**
     * Sets the value of the allocateNonRecoverableTax property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setAllocateNonRecoverableTax(Boolean value) {
        this.allocateNonRecoverableTax = value;
    }

}
