
package com.workday.financial;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;


/**
 * Contains the data for questions that are a part of a Survey.
 * 
 * <p>Java class for Survey_Question_DataType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Survey_Question_DataType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Survey_Question_Order" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Survey_Question_Type_Reference" type="{urn:com.workday/bsvc}Survey_Question_TypeObjectType" minOccurs="0"/>
 *         &lt;element name="Survey_Question_Required" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Survey_Question_Text" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Multiple_Choice_Question_Option_Reference" type="{urn:com.workday/bsvc}Multiple_Choice_Question_Option_DataType" maxOccurs="unbounded" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Survey_Question_DataType", propOrder = {
    "surveyQuestionOrder",
    "surveyQuestionTypeReference",
    "surveyQuestionRequired",
    "surveyQuestionText",
    "multipleChoiceQuestionOptionReference"
})
public class SurveyQuestionDataType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Survey_Question_Order")
    protected String surveyQuestionOrder;
    @XmlElement(name = "Survey_Question_Type_Reference")
    protected SurveyQuestionTypeObjectType surveyQuestionTypeReference;
    @XmlElement(name = "Survey_Question_Required")
    protected Boolean surveyQuestionRequired;
    @XmlElement(name = "Survey_Question_Text")
    protected String surveyQuestionText;
    @XmlElement(name = "Multiple_Choice_Question_Option_Reference")
    protected List<MultipleChoiceQuestionOptionDataType> multipleChoiceQuestionOptionReference;

    /**
     * Gets the value of the surveyQuestionOrder property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getSurveyQuestionOrder() {
        return surveyQuestionOrder;
    }

    /**
     * Sets the value of the surveyQuestionOrder property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setSurveyQuestionOrder(String value) {
        this.surveyQuestionOrder = value;
    }

    /**
     * Gets the value of the surveyQuestionTypeReference property.
     * 
     * @return
     *     possible object is
     *     {@link SurveyQuestionTypeObjectType }
     *     
     */
    public SurveyQuestionTypeObjectType getSurveyQuestionTypeReference() {
        return surveyQuestionTypeReference;
    }

    /**
     * Sets the value of the surveyQuestionTypeReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link SurveyQuestionTypeObjectType }
     *     
     */
    public void setSurveyQuestionTypeReference(SurveyQuestionTypeObjectType value) {
        this.surveyQuestionTypeReference = value;
    }

    /**
     * Gets the value of the surveyQuestionRequired property.
     * This getter has been renamed from isSurveyQuestionRequired() to getSurveyQuestionRequired() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getSurveyQuestionRequired() {
        return surveyQuestionRequired;
    }

    /**
     * Sets the value of the surveyQuestionRequired property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setSurveyQuestionRequired(Boolean value) {
        this.surveyQuestionRequired = value;
    }

    /**
     * Gets the value of the surveyQuestionText property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getSurveyQuestionText() {
        return surveyQuestionText;
    }

    /**
     * Sets the value of the surveyQuestionText property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setSurveyQuestionText(String value) {
        this.surveyQuestionText = value;
    }

    /**
     * Gets the value of the multipleChoiceQuestionOptionReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the multipleChoiceQuestionOptionReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getMultipleChoiceQuestionOptionReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link MultipleChoiceQuestionOptionDataType }
     * 
     * 
     */
    public List<MultipleChoiceQuestionOptionDataType> getMultipleChoiceQuestionOptionReference() {
        if (multipleChoiceQuestionOptionReference == null) {
            multipleChoiceQuestionOptionReference = new ArrayList<MultipleChoiceQuestionOptionDataType>();
        }
        return this.multipleChoiceQuestionOptionReference;
    }

    /**
     * Sets the value of the multipleChoiceQuestionOptionReference property.
     * 
     * @param multipleChoiceQuestionOptionReference
     *     allowed object is
     *     {@link MultipleChoiceQuestionOptionDataType }
     *     
     */
    public void setMultipleChoiceQuestionOptionReference(List<MultipleChoiceQuestionOptionDataType> multipleChoiceQuestionOptionReference) {
        this.multipleChoiceQuestionOptionReference = multipleChoiceQuestionOptionReference;
    }

}
