
package com.workday.financial;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;


/**
 * Contains all of the data for a Survey.
 * 
 * <p>Java class for Survey_DataType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Survey_DataType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Survey_Type_Reference" type="{urn:com.workday/bsvc}Survey_TypeObjectType" minOccurs="0"/>
 *         &lt;element name="Survey_Name" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Survey_Question_Reference" type="{urn:com.workday/bsvc}Survey_Question_DataType" maxOccurs="unbounded" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Survey_DataType", propOrder = {
    "surveyTypeReference",
    "surveyName",
    "surveyQuestionReference"
})
public class SurveyDataType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Survey_Type_Reference")
    protected SurveyTypeObjectType surveyTypeReference;
    @XmlElement(name = "Survey_Name")
    protected String surveyName;
    @XmlElement(name = "Survey_Question_Reference")
    protected List<SurveyQuestionDataType> surveyQuestionReference;

    /**
     * Gets the value of the surveyTypeReference property.
     * 
     * @return
     *     possible object is
     *     {@link SurveyTypeObjectType }
     *     
     */
    public SurveyTypeObjectType getSurveyTypeReference() {
        return surveyTypeReference;
    }

    /**
     * Sets the value of the surveyTypeReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link SurveyTypeObjectType }
     *     
     */
    public void setSurveyTypeReference(SurveyTypeObjectType value) {
        this.surveyTypeReference = value;
    }

    /**
     * Gets the value of the surveyName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getSurveyName() {
        return surveyName;
    }

    /**
     * Sets the value of the surveyName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setSurveyName(String value) {
        this.surveyName = value;
    }

    /**
     * Gets the value of the surveyQuestionReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the surveyQuestionReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getSurveyQuestionReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link SurveyQuestionDataType }
     * 
     * 
     */
    public List<SurveyQuestionDataType> getSurveyQuestionReference() {
        if (surveyQuestionReference == null) {
            surveyQuestionReference = new ArrayList<SurveyQuestionDataType>();
        }
        return this.surveyQuestionReference;
    }

    /**
     * Sets the value of the surveyQuestionReference property.
     * 
     * @param surveyQuestionReference
     *     allowed object is
     *     {@link SurveyQuestionDataType }
     *     
     */
    public void setSurveyQuestionReference(List<SurveyQuestionDataType> surveyQuestionReference) {
        this.surveyQuestionReference = surveyQuestionReference;
    }

}
