
package com.workday.financial;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.datatype.XMLGregorianCalendar;


/**
 * Element used to Request certain Suppliers
 * 
 * <p>Java class for Supplier_Request_CriteriaType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Supplier_Request_CriteriaType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Updated_From_Date" type="{http://www.w3.org/2001/XMLSchema}dateTime" minOccurs="0"/>
 *         &lt;element name="Updated_To_Date" type="{http://www.w3.org/2001/XMLSchema}dateTime" minOccurs="0"/>
 *         &lt;element name="Supplier_Status_Reference" type="{urn:com.workday/bsvc}Business_Entity_Status_ValueObjectType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Supplier_Category_Reference" type="{urn:com.workday/bsvc}Supplier_CategoryObjectType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Supplier_Group_Reference" type="{urn:com.workday/bsvc}Supplier_GroupObjectType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Customer_Account_Number" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="DUNS_Number" minOccurs="0">
 *           &lt;simpleType>
 *             &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *               &lt;maxLength value="9"/>
 *             &lt;/restriction>
 *           &lt;/simpleType>
 *         &lt;/element>
 *         &lt;element name="Parent_Supplier_Reference" type="{urn:com.workday/bsvc}SupplierObjectType" maxOccurs="unbounded" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Supplier_Request_CriteriaType", propOrder = {
    "updatedFromDate",
    "updatedToDate",
    "supplierStatusReference",
    "supplierCategoryReference",
    "supplierGroupReference",
    "customerAccountNumber",
    "dunsNumber",
    "parentSupplierReference"
})
public class SupplierRequestCriteriaType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Updated_From_Date")
    @XmlSchemaType(name = "dateTime")
    protected XMLGregorianCalendar updatedFromDate;
    @XmlElement(name = "Updated_To_Date")
    @XmlSchemaType(name = "dateTime")
    protected XMLGregorianCalendar updatedToDate;
    @XmlElement(name = "Supplier_Status_Reference")
    protected List<BusinessEntityStatusValueObjectType> supplierStatusReference;
    @XmlElement(name = "Supplier_Category_Reference")
    protected List<SupplierCategoryObjectType> supplierCategoryReference;
    @XmlElement(name = "Supplier_Group_Reference")
    protected List<SupplierGroupObjectType> supplierGroupReference;
    @XmlElement(name = "Customer_Account_Number")
    protected String customerAccountNumber;
    @XmlElement(name = "DUNS_Number")
    protected String dunsNumber;
    @XmlElement(name = "Parent_Supplier_Reference")
    protected List<SupplierObjectType> parentSupplierReference;

    /**
     * Gets the value of the updatedFromDate property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getUpdatedFromDate() {
        return updatedFromDate;
    }

    /**
     * Sets the value of the updatedFromDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setUpdatedFromDate(XMLGregorianCalendar value) {
        this.updatedFromDate = value;
    }

    /**
     * Gets the value of the updatedToDate property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getUpdatedToDate() {
        return updatedToDate;
    }

    /**
     * Sets the value of the updatedToDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setUpdatedToDate(XMLGregorianCalendar value) {
        this.updatedToDate = value;
    }

    /**
     * Gets the value of the supplierStatusReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the supplierStatusReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getSupplierStatusReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link BusinessEntityStatusValueObjectType }
     * 
     * 
     */
    public List<BusinessEntityStatusValueObjectType> getSupplierStatusReference() {
        if (supplierStatusReference == null) {
            supplierStatusReference = new ArrayList<BusinessEntityStatusValueObjectType>();
        }
        return this.supplierStatusReference;
    }

    /**
     * Gets the value of the supplierCategoryReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the supplierCategoryReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getSupplierCategoryReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link SupplierCategoryObjectType }
     * 
     * 
     */
    public List<SupplierCategoryObjectType> getSupplierCategoryReference() {
        if (supplierCategoryReference == null) {
            supplierCategoryReference = new ArrayList<SupplierCategoryObjectType>();
        }
        return this.supplierCategoryReference;
    }

    /**
     * Gets the value of the supplierGroupReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the supplierGroupReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getSupplierGroupReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link SupplierGroupObjectType }
     * 
     * 
     */
    public List<SupplierGroupObjectType> getSupplierGroupReference() {
        if (supplierGroupReference == null) {
            supplierGroupReference = new ArrayList<SupplierGroupObjectType>();
        }
        return this.supplierGroupReference;
    }

    /**
     * Gets the value of the customerAccountNumber property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getCustomerAccountNumber() {
        return customerAccountNumber;
    }

    /**
     * Sets the value of the customerAccountNumber property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setCustomerAccountNumber(String value) {
        this.customerAccountNumber = value;
    }

    /**
     * Gets the value of the dunsNumber property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getDUNSNumber() {
        return dunsNumber;
    }

    /**
     * Sets the value of the dunsNumber property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setDUNSNumber(String value) {
        this.dunsNumber = value;
    }

    /**
     * Gets the value of the parentSupplierReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the parentSupplierReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getParentSupplierReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link SupplierObjectType }
     * 
     * 
     */
    public List<SupplierObjectType> getParentSupplierReference() {
        if (parentSupplierReference == null) {
            parentSupplierReference = new ArrayList<SupplierObjectType>();
        }
        return this.parentSupplierReference;
    }

    /**
     * Sets the value of the supplierStatusReference property.
     * 
     * @param supplierStatusReference
     *     allowed object is
     *     {@link BusinessEntityStatusValueObjectType }
     *     
     */
    public void setSupplierStatusReference(List<BusinessEntityStatusValueObjectType> supplierStatusReference) {
        this.supplierStatusReference = supplierStatusReference;
    }

    /**
     * Sets the value of the supplierCategoryReference property.
     * 
     * @param supplierCategoryReference
     *     allowed object is
     *     {@link SupplierCategoryObjectType }
     *     
     */
    public void setSupplierCategoryReference(List<SupplierCategoryObjectType> supplierCategoryReference) {
        this.supplierCategoryReference = supplierCategoryReference;
    }

    /**
     * Sets the value of the supplierGroupReference property.
     * 
     * @param supplierGroupReference
     *     allowed object is
     *     {@link SupplierGroupObjectType }
     *     
     */
    public void setSupplierGroupReference(List<SupplierGroupObjectType> supplierGroupReference) {
        this.supplierGroupReference = supplierGroupReference;
    }

    /**
     * Sets the value of the parentSupplierReference property.
     * 
     * @param parentSupplierReference
     *     allowed object is
     *     {@link SupplierObjectType }
     *     
     */
    public void setParentSupplierReference(List<SupplierObjectType> parentSupplierReference) {
        this.parentSupplierReference = parentSupplierReference;
    }

}
