
package com.workday.financial;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;


/**
 * Contains data for creating or updating a Position Budget. A unique instance of the Position Budget is identified by a Company, Business Plan Structure, Fiscal Year, Fiscal Time Interval and Position.
 * 
 * <p>Java class for Submit_Position_Budget_RequestType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Submit_Position_Budget_RequestType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Position_Budget_Reference" type="{urn:com.workday/bsvc}Unique_IdentifierObjectType" minOccurs="0"/>
 *         &lt;element name="Business_Process_Parameters" type="{urn:com.workday/bsvc}Financials_Business_Process_ParametersType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Position_Budget_Data" type="{urn:com.workday/bsvc}Position_Budget_DataType" minOccurs="0"/>
 *       &lt;/sequence>
 *       &lt;attribute name="Add_Only" type="{http://www.w3.org/2001/XMLSchema}boolean" />
 *       &lt;attribute ref="{urn:com.workday/bsvc}version"/>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Submit_Position_Budget_RequestType", propOrder = {
    "positionBudgetReference",
    "businessProcessParameters",
    "positionBudgetData"
})
public class SubmitPositionBudgetRequestType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Position_Budget_Reference")
    protected UniqueIdentifierObjectType positionBudgetReference;
    @XmlElement(name = "Business_Process_Parameters")
    protected List<FinancialsBusinessProcessParametersType> businessProcessParameters;
    @XmlElement(name = "Position_Budget_Data")
    protected PositionBudgetDataType positionBudgetData;
    @XmlAttribute(name = "Add_Only", namespace = "urn:com.workday/bsvc")
    protected Boolean addOnly;
    @XmlAttribute(name = "version", namespace = "urn:com.workday/bsvc")
    protected String version;

    /**
     * Gets the value of the positionBudgetReference property.
     * 
     * @return
     *     possible object is
     *     {@link UniqueIdentifierObjectType }
     *     
     */
    public UniqueIdentifierObjectType getPositionBudgetReference() {
        return positionBudgetReference;
    }

    /**
     * Sets the value of the positionBudgetReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link UniqueIdentifierObjectType }
     *     
     */
    public void setPositionBudgetReference(UniqueIdentifierObjectType value) {
        this.positionBudgetReference = value;
    }

    /**
     * Gets the value of the businessProcessParameters property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the businessProcessParameters property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getBusinessProcessParameters().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link FinancialsBusinessProcessParametersType }
     * 
     * 
     */
    public List<FinancialsBusinessProcessParametersType> getBusinessProcessParameters() {
        if (businessProcessParameters == null) {
            businessProcessParameters = new ArrayList<FinancialsBusinessProcessParametersType>();
        }
        return this.businessProcessParameters;
    }

    /**
     * Gets the value of the positionBudgetData property.
     * 
     * @return
     *     possible object is
     *     {@link PositionBudgetDataType }
     *     
     */
    public PositionBudgetDataType getPositionBudgetData() {
        return positionBudgetData;
    }

    /**
     * Sets the value of the positionBudgetData property.
     * 
     * @param value
     *     allowed object is
     *     {@link PositionBudgetDataType }
     *     
     */
    public void setPositionBudgetData(PositionBudgetDataType value) {
        this.positionBudgetData = value;
    }

    /**
     * Gets the value of the addOnly property.
     * This getter has been renamed from isAddOnly() to getAddOnly() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getAddOnly() {
        return addOnly;
    }

    /**
     * Sets the value of the addOnly property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setAddOnly(Boolean value) {
        this.addOnly = value;
    }

    /**
     * Gets the value of the version property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getVersion() {
        return version;
    }

    /**
     * Sets the value of the version property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setVersion(String value) {
        this.version = value;
    }

    /**
     * Sets the value of the businessProcessParameters property.
     * 
     * @param businessProcessParameters
     *     allowed object is
     *     {@link FinancialsBusinessProcessParametersType }
     *     
     */
    public void setBusinessProcessParameters(List<FinancialsBusinessProcessParametersType> businessProcessParameters) {
        this.businessProcessParameters = businessProcessParameters;
    }

}
