
package com.workday.financial;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;


/**
 * Element containing data for the statistic lines associated with a Statistic
 * 
 * <p>Java class for Statistic_Line_DataType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Statistic_Line_DataType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Company_Reference" type="{urn:com.workday/bsvc}CompanyObjectType" minOccurs="0"/>
 *         &lt;element name="Budget_Name_Reference" type="{urn:com.workday/bsvc}Custom_BudgetObjectType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Statistic_Line_Value" minOccurs="0">
 *           &lt;simpleType>
 *             &lt;restriction base="{http://www.w3.org/2001/XMLSchema}decimal">
 *               &lt;totalDigits value="18"/>
 *               &lt;fractionDigits value="6"/>
 *             &lt;/restriction>
 *           &lt;/simpleType>
 *         &lt;/element>
 *         &lt;element name="Worktag_Reference" type="{urn:com.workday/bsvc}Audited_Accounting_WorktagObjectType" maxOccurs="unbounded"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Statistic_Line_DataType", propOrder = {
    "companyReference",
    "budgetNameReference",
    "statisticLineValue",
    "worktagReference"
})
public class StatisticLineDataType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Company_Reference")
    protected CompanyObjectType companyReference;
    @XmlElement(name = "Budget_Name_Reference")
    protected List<CustomBudgetObjectType> budgetNameReference;
    @XmlElement(name = "Statistic_Line_Value")
    protected BigDecimal statisticLineValue;
    @XmlElement(name = "Worktag_Reference", required = true)
    protected List<AuditedAccountingWorktagObjectType> worktagReference;

    /**
     * Gets the value of the companyReference property.
     * 
     * @return
     *     possible object is
     *     {@link CompanyObjectType }
     *     
     */
    public CompanyObjectType getCompanyReference() {
        return companyReference;
    }

    /**
     * Sets the value of the companyReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link CompanyObjectType }
     *     
     */
    public void setCompanyReference(CompanyObjectType value) {
        this.companyReference = value;
    }

    /**
     * Gets the value of the budgetNameReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the budgetNameReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getBudgetNameReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link CustomBudgetObjectType }
     * 
     * 
     */
    public List<CustomBudgetObjectType> getBudgetNameReference() {
        if (budgetNameReference == null) {
            budgetNameReference = new ArrayList<CustomBudgetObjectType>();
        }
        return this.budgetNameReference;
    }

    /**
     * Gets the value of the statisticLineValue property.
     * 
     * @return
     *     possible object is
     *     {@link BigDecimal }
     *     
     */
    public BigDecimal getStatisticLineValue() {
        return statisticLineValue;
    }

    /**
     * Sets the value of the statisticLineValue property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigDecimal }
     *     
     */
    public void setStatisticLineValue(BigDecimal value) {
        this.statisticLineValue = value;
    }

    /**
     * Gets the value of the worktagReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the worktagReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getWorktagReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AuditedAccountingWorktagObjectType }
     * 
     * 
     */
    public List<AuditedAccountingWorktagObjectType> getWorktagReference() {
        if (worktagReference == null) {
            worktagReference = new ArrayList<AuditedAccountingWorktagObjectType>();
        }
        return this.worktagReference;
    }

    /**
     * Sets the value of the budgetNameReference property.
     * 
     * @param budgetNameReference
     *     allowed object is
     *     {@link CustomBudgetObjectType }
     *     
     */
    public void setBudgetNameReference(List<CustomBudgetObjectType> budgetNameReference) {
        this.budgetNameReference = budgetNameReference;
    }

    /**
     * Sets the value of the worktagReference property.
     * 
     * @param worktagReference
     *     allowed object is
     *     {@link AuditedAccountingWorktagObjectType }
     *     
     */
    public void setWorktagReference(List<AuditedAccountingWorktagObjectType> worktagReference) {
        this.worktagReference = worktagReference;
    }

}
