
package com.workday.financial;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;


/**
 * Element containing data for a statistic definition
 * 
 * <p>Java class for Statistic_Definition_DataType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Statistic_Definition_DataType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Statistic_Definition_ID" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Statistic_Definition_Name" type="{http://www.w3.org/2001/XMLSchema}string"/>
 *         &lt;element name="Statistic_Definition_Description" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Fiscal_Schedule_Reference" type="{urn:com.workday/bsvc}Fiscal_ScheduleObjectType"/>
 *         &lt;element name="Dimensions_Reference" type="{urn:com.workday/bsvc}Accounting_Worktag_TypeObjectType" maxOccurs="unbounded"/>
 *         &lt;element name="Ledger_Budget_Structure_Reference" type="{urn:com.workday/bsvc}Financial_Entry_TypeObjectType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Statistic_Definition_Requires_Company" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Statistic_Type_Reference" type="{urn:com.workday/bsvc}Statistic_TypeObjectType"/>
 *         &lt;element name="Inactive" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Statistic_Definition_DataType", propOrder = {
    "statisticDefinitionID",
    "statisticDefinitionName",
    "statisticDefinitionDescription",
    "fiscalScheduleReference",
    "dimensionsReference",
    "ledgerBudgetStructureReference",
    "statisticDefinitionRequiresCompany",
    "statisticTypeReference",
    "inactive"
})
public class StatisticDefinitionDataType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Statistic_Definition_ID")
    protected String statisticDefinitionID;
    @XmlElement(name = "Statistic_Definition_Name", required = true)
    protected String statisticDefinitionName;
    @XmlElement(name = "Statistic_Definition_Description")
    protected String statisticDefinitionDescription;
    @XmlElement(name = "Fiscal_Schedule_Reference", required = true)
    protected FiscalScheduleObjectType fiscalScheduleReference;
    @XmlElement(name = "Dimensions_Reference", required = true)
    protected List<AccountingWorktagTypeObjectType> dimensionsReference;
    @XmlElement(name = "Ledger_Budget_Structure_Reference")
    protected List<FinancialEntryTypeObjectType> ledgerBudgetStructureReference;
    @XmlElement(name = "Statistic_Definition_Requires_Company")
    protected Boolean statisticDefinitionRequiresCompany;
    @XmlElement(name = "Statistic_Type_Reference", required = true)
    protected StatisticTypeObjectType statisticTypeReference;
    @XmlElement(name = "Inactive")
    protected Boolean inactive;

    /**
     * Gets the value of the statisticDefinitionID property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getStatisticDefinitionID() {
        return statisticDefinitionID;
    }

    /**
     * Sets the value of the statisticDefinitionID property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setStatisticDefinitionID(String value) {
        this.statisticDefinitionID = value;
    }

    /**
     * Gets the value of the statisticDefinitionName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getStatisticDefinitionName() {
        return statisticDefinitionName;
    }

    /**
     * Sets the value of the statisticDefinitionName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setStatisticDefinitionName(String value) {
        this.statisticDefinitionName = value;
    }

    /**
     * Gets the value of the statisticDefinitionDescription property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getStatisticDefinitionDescription() {
        return statisticDefinitionDescription;
    }

    /**
     * Sets the value of the statisticDefinitionDescription property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setStatisticDefinitionDescription(String value) {
        this.statisticDefinitionDescription = value;
    }

    /**
     * Gets the value of the fiscalScheduleReference property.
     * 
     * @return
     *     possible object is
     *     {@link FiscalScheduleObjectType }
     *     
     */
    public FiscalScheduleObjectType getFiscalScheduleReference() {
        return fiscalScheduleReference;
    }

    /**
     * Sets the value of the fiscalScheduleReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link FiscalScheduleObjectType }
     *     
     */
    public void setFiscalScheduleReference(FiscalScheduleObjectType value) {
        this.fiscalScheduleReference = value;
    }

    /**
     * Gets the value of the dimensionsReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the dimensionsReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getDimensionsReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AccountingWorktagTypeObjectType }
     * 
     * 
     */
    public List<AccountingWorktagTypeObjectType> getDimensionsReference() {
        if (dimensionsReference == null) {
            dimensionsReference = new ArrayList<AccountingWorktagTypeObjectType>();
        }
        return this.dimensionsReference;
    }

    /**
     * Gets the value of the ledgerBudgetStructureReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the ledgerBudgetStructureReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getLedgerBudgetStructureReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link FinancialEntryTypeObjectType }
     * 
     * 
     */
    public List<FinancialEntryTypeObjectType> getLedgerBudgetStructureReference() {
        if (ledgerBudgetStructureReference == null) {
            ledgerBudgetStructureReference = new ArrayList<FinancialEntryTypeObjectType>();
        }
        return this.ledgerBudgetStructureReference;
    }

    /**
     * Gets the value of the statisticDefinitionRequiresCompany property.
     * This getter has been renamed from isStatisticDefinitionRequiresCompany() to getStatisticDefinitionRequiresCompany() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getStatisticDefinitionRequiresCompany() {
        return statisticDefinitionRequiresCompany;
    }

    /**
     * Sets the value of the statisticDefinitionRequiresCompany property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setStatisticDefinitionRequiresCompany(Boolean value) {
        this.statisticDefinitionRequiresCompany = value;
    }

    /**
     * Gets the value of the statisticTypeReference property.
     * 
     * @return
     *     possible object is
     *     {@link StatisticTypeObjectType }
     *     
     */
    public StatisticTypeObjectType getStatisticTypeReference() {
        return statisticTypeReference;
    }

    /**
     * Sets the value of the statisticTypeReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link StatisticTypeObjectType }
     *     
     */
    public void setStatisticTypeReference(StatisticTypeObjectType value) {
        this.statisticTypeReference = value;
    }

    /**
     * Gets the value of the inactive property.
     * This getter has been renamed from isInactive() to getInactive() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getInactive() {
        return inactive;
    }

    /**
     * Sets the value of the inactive property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setInactive(Boolean value) {
        this.inactive = value;
    }

    /**
     * Sets the value of the dimensionsReference property.
     * 
     * @param dimensionsReference
     *     allowed object is
     *     {@link AccountingWorktagTypeObjectType }
     *     
     */
    public void setDimensionsReference(List<AccountingWorktagTypeObjectType> dimensionsReference) {
        this.dimensionsReference = dimensionsReference;
    }

    /**
     * Sets the value of the ledgerBudgetStructureReference property.
     * 
     * @param ledgerBudgetStructureReference
     *     allowed object is
     *     {@link FinancialEntryTypeObjectType }
     *     
     */
    public void setLedgerBudgetStructureReference(List<FinancialEntryTypeObjectType> ledgerBudgetStructureReference) {
        this.ledgerBudgetStructureReference = ledgerBudgetStructureReference;
    }

}
