
package com.workday.financial;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;


/**
 * Element containing Statistics data
 * 
 * <p>Java class for Statistic_DataType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Statistic_DataType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Statistic_Definition_Reference" type="{urn:com.workday/bsvc}Statistic_DefinitionObjectType"/>
 *         &lt;element name="Ledger_Budget_Structure_Statistic_Reference" type="{urn:com.workday/bsvc}Financial_Entry_TypeObjectType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Fiscal_Period_Reference_Data" type="{urn:com.workday/bsvc}Fiscal_Period_Reference_DataType" minOccurs="0"/>
 *         &lt;element name="Fiscal_Summary_Year_Reference" type="{urn:com.workday/bsvc}Fiscal_YearObjectType" minOccurs="0"/>
 *         &lt;element name="Fiscal_Summary_Interval_Reference" type="{urn:com.workday/bsvc}Fiscal_Summary_IntervalObjectType" minOccurs="0"/>
 *         &lt;element name="Statistic_Memo" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Statistic_Values_Replacement_Data" type="{urn:com.workday/bsvc}Statistic_Line_DataType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Attachment_Data" type="{urn:com.workday/bsvc}Financials_Attachment_DataType" maxOccurs="unbounded" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Statistic_DataType", propOrder = {
    "statisticDefinitionReference",
    "ledgerBudgetStructureStatisticReference",
    "fiscalPeriodReferenceData",
    "fiscalSummaryYearReference",
    "fiscalSummaryIntervalReference",
    "statisticMemo",
    "statisticValuesReplacementData",
    "attachmentData"
})
public class StatisticDataType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Statistic_Definition_Reference", required = true)
    protected StatisticDefinitionObjectType statisticDefinitionReference;
    @XmlElement(name = "Ledger_Budget_Structure_Statistic_Reference")
    protected List<FinancialEntryTypeObjectType> ledgerBudgetStructureStatisticReference;
    @XmlElement(name = "Fiscal_Period_Reference_Data")
    protected FiscalPeriodReferenceDataType fiscalPeriodReferenceData;
    @XmlElement(name = "Fiscal_Summary_Year_Reference")
    protected FiscalYearObjectType fiscalSummaryYearReference;
    @XmlElement(name = "Fiscal_Summary_Interval_Reference")
    protected FiscalSummaryIntervalObjectType fiscalSummaryIntervalReference;
    @XmlElement(name = "Statistic_Memo")
    protected String statisticMemo;
    @XmlElement(name = "Statistic_Values_Replacement_Data")
    protected List<StatisticLineDataType> statisticValuesReplacementData;
    @XmlElement(name = "Attachment_Data")
    protected List<FinancialsAttachmentDataType> attachmentData;

    /**
     * Gets the value of the statisticDefinitionReference property.
     * 
     * @return
     *     possible object is
     *     {@link StatisticDefinitionObjectType }
     *     
     */
    public StatisticDefinitionObjectType getStatisticDefinitionReference() {
        return statisticDefinitionReference;
    }

    /**
     * Sets the value of the statisticDefinitionReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link StatisticDefinitionObjectType }
     *     
     */
    public void setStatisticDefinitionReference(StatisticDefinitionObjectType value) {
        this.statisticDefinitionReference = value;
    }

    /**
     * Gets the value of the ledgerBudgetStructureStatisticReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the ledgerBudgetStructureStatisticReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getLedgerBudgetStructureStatisticReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link FinancialEntryTypeObjectType }
     * 
     * 
     */
    public List<FinancialEntryTypeObjectType> getLedgerBudgetStructureStatisticReference() {
        if (ledgerBudgetStructureStatisticReference == null) {
            ledgerBudgetStructureStatisticReference = new ArrayList<FinancialEntryTypeObjectType>();
        }
        return this.ledgerBudgetStructureStatisticReference;
    }

    /**
     * Gets the value of the fiscalPeriodReferenceData property.
     * 
     * @return
     *     possible object is
     *     {@link FiscalPeriodReferenceDataType }
     *     
     */
    public FiscalPeriodReferenceDataType getFiscalPeriodReferenceData() {
        return fiscalPeriodReferenceData;
    }

    /**
     * Sets the value of the fiscalPeriodReferenceData property.
     * 
     * @param value
     *     allowed object is
     *     {@link FiscalPeriodReferenceDataType }
     *     
     */
    public void setFiscalPeriodReferenceData(FiscalPeriodReferenceDataType value) {
        this.fiscalPeriodReferenceData = value;
    }

    /**
     * Gets the value of the fiscalSummaryYearReference property.
     * 
     * @return
     *     possible object is
     *     {@link FiscalYearObjectType }
     *     
     */
    public FiscalYearObjectType getFiscalSummaryYearReference() {
        return fiscalSummaryYearReference;
    }

    /**
     * Sets the value of the fiscalSummaryYearReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link FiscalYearObjectType }
     *     
     */
    public void setFiscalSummaryYearReference(FiscalYearObjectType value) {
        this.fiscalSummaryYearReference = value;
    }

    /**
     * Gets the value of the fiscalSummaryIntervalReference property.
     * 
     * @return
     *     possible object is
     *     {@link FiscalSummaryIntervalObjectType }
     *     
     */
    public FiscalSummaryIntervalObjectType getFiscalSummaryIntervalReference() {
        return fiscalSummaryIntervalReference;
    }

    /**
     * Sets the value of the fiscalSummaryIntervalReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link FiscalSummaryIntervalObjectType }
     *     
     */
    public void setFiscalSummaryIntervalReference(FiscalSummaryIntervalObjectType value) {
        this.fiscalSummaryIntervalReference = value;
    }

    /**
     * Gets the value of the statisticMemo property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getStatisticMemo() {
        return statisticMemo;
    }

    /**
     * Sets the value of the statisticMemo property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setStatisticMemo(String value) {
        this.statisticMemo = value;
    }

    /**
     * Gets the value of the statisticValuesReplacementData property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the statisticValuesReplacementData property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getStatisticValuesReplacementData().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link StatisticLineDataType }
     * 
     * 
     */
    public List<StatisticLineDataType> getStatisticValuesReplacementData() {
        if (statisticValuesReplacementData == null) {
            statisticValuesReplacementData = new ArrayList<StatisticLineDataType>();
        }
        return this.statisticValuesReplacementData;
    }

    /**
     * Gets the value of the attachmentData property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the attachmentData property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getAttachmentData().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link FinancialsAttachmentDataType }
     * 
     * 
     */
    public List<FinancialsAttachmentDataType> getAttachmentData() {
        if (attachmentData == null) {
            attachmentData = new ArrayList<FinancialsAttachmentDataType>();
        }
        return this.attachmentData;
    }

    /**
     * Sets the value of the ledgerBudgetStructureStatisticReference property.
     * 
     * @param ledgerBudgetStructureStatisticReference
     *     allowed object is
     *     {@link FinancialEntryTypeObjectType }
     *     
     */
    public void setLedgerBudgetStructureStatisticReference(List<FinancialEntryTypeObjectType> ledgerBudgetStructureStatisticReference) {
        this.ledgerBudgetStructureStatisticReference = ledgerBudgetStructureStatisticReference;
    }

    /**
     * Sets the value of the statisticValuesReplacementData property.
     * 
     * @param statisticValuesReplacementData
     *     allowed object is
     *     {@link StatisticLineDataType }
     *     
     */
    public void setStatisticValuesReplacementData(List<StatisticLineDataType> statisticValuesReplacementData) {
        this.statisticValuesReplacementData = statisticValuesReplacementData;
    }

    /**
     * Sets the value of the attachmentData property.
     * 
     * @param attachmentData
     *     allowed object is
     *     {@link FinancialsAttachmentDataType }
     *     
     */
    public void setAttachmentData(List<FinancialsAttachmentDataType> attachmentData) {
        this.attachmentData = attachmentData;
    }

}
