
package com.workday.financial;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;


/**
 * Element containing all Spend Category Hierarchy data
 * 
 * <p>Java class for Spend_Category_Hierarchy_DataType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Spend_Category_Hierarchy_DataType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Spend_Category_Hierarchy_ID" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Spend_Category_Hierarchy_Names" type="{http://www.w3.org/2001/XMLSchema}string"/>
 *         &lt;element name="Hierarchy_Level_Reference" type="{urn:com.workday/bsvc}Hierarchy_LevelObjectType" minOccurs="0"/>
 *         &lt;element name="Parent_Reference" type="{urn:com.workday/bsvc}Spend_Category_HierarchyObjectType" minOccurs="0"/>
 *         &lt;element name="Included_Spend_Categories_Reference" type="{urn:com.workday/bsvc}Spend_CategoryObjectType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Commodity_Code" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Description" type="{urn:com.workday/bsvc}RichText" minOccurs="0"/>
 *         &lt;element name="Inactive" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Spend_Category_Hierarchy_Display_Option_Reference" type="{urn:com.workday/bsvc}Spend_Category_or_Hierarchy_Display_OptionObjectType" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Spend_Category_Hierarchy_DataType", propOrder = {
    "spendCategoryHierarchyID",
    "spendCategoryHierarchyNames",
    "hierarchyLevelReference",
    "parentReference",
    "includedSpendCategoriesReference",
    "commodityCode",
    "description",
    "inactive",
    "spendCategoryHierarchyDisplayOptionReference"
})
public class SpendCategoryHierarchyDataType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Spend_Category_Hierarchy_ID")
    protected String spendCategoryHierarchyID;
    @XmlElement(name = "Spend_Category_Hierarchy_Names", required = true)
    protected String spendCategoryHierarchyNames;
    @XmlElement(name = "Hierarchy_Level_Reference")
    protected HierarchyLevelObjectType hierarchyLevelReference;
    @XmlElement(name = "Parent_Reference")
    protected SpendCategoryHierarchyObjectType parentReference;
    @XmlElement(name = "Included_Spend_Categories_Reference")
    protected List<SpendCategoryObjectType> includedSpendCategoriesReference;
    @XmlElement(name = "Commodity_Code")
    protected String commodityCode;
    @XmlElement(name = "Description")
    protected String description;
    @XmlElement(name = "Inactive")
    protected Boolean inactive;
    @XmlElement(name = "Spend_Category_Hierarchy_Display_Option_Reference")
    protected SpendCategoryOrHierarchyDisplayOptionObjectType spendCategoryHierarchyDisplayOptionReference;

    /**
     * Gets the value of the spendCategoryHierarchyID property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getSpendCategoryHierarchyID() {
        return spendCategoryHierarchyID;
    }

    /**
     * Sets the value of the spendCategoryHierarchyID property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setSpendCategoryHierarchyID(String value) {
        this.spendCategoryHierarchyID = value;
    }

    /**
     * Gets the value of the spendCategoryHierarchyNames property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getSpendCategoryHierarchyNames() {
        return spendCategoryHierarchyNames;
    }

    /**
     * Sets the value of the spendCategoryHierarchyNames property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setSpendCategoryHierarchyNames(String value) {
        this.spendCategoryHierarchyNames = value;
    }

    /**
     * Gets the value of the hierarchyLevelReference property.
     * 
     * @return
     *     possible object is
     *     {@link HierarchyLevelObjectType }
     *     
     */
    public HierarchyLevelObjectType getHierarchyLevelReference() {
        return hierarchyLevelReference;
    }

    /**
     * Sets the value of the hierarchyLevelReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link HierarchyLevelObjectType }
     *     
     */
    public void setHierarchyLevelReference(HierarchyLevelObjectType value) {
        this.hierarchyLevelReference = value;
    }

    /**
     * Gets the value of the parentReference property.
     * 
     * @return
     *     possible object is
     *     {@link SpendCategoryHierarchyObjectType }
     *     
     */
    public SpendCategoryHierarchyObjectType getParentReference() {
        return parentReference;
    }

    /**
     * Sets the value of the parentReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link SpendCategoryHierarchyObjectType }
     *     
     */
    public void setParentReference(SpendCategoryHierarchyObjectType value) {
        this.parentReference = value;
    }

    /**
     * Gets the value of the includedSpendCategoriesReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the includedSpendCategoriesReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getIncludedSpendCategoriesReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link SpendCategoryObjectType }
     * 
     * 
     */
    public List<SpendCategoryObjectType> getIncludedSpendCategoriesReference() {
        if (includedSpendCategoriesReference == null) {
            includedSpendCategoriesReference = new ArrayList<SpendCategoryObjectType>();
        }
        return this.includedSpendCategoriesReference;
    }

    /**
     * Gets the value of the commodityCode property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getCommodityCode() {
        return commodityCode;
    }

    /**
     * Sets the value of the commodityCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setCommodityCode(String value) {
        this.commodityCode = value;
    }

    /**
     * Gets the value of the description property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getDescription() {
        return description;
    }

    /**
     * Sets the value of the description property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setDescription(String value) {
        this.description = value;
    }

    /**
     * Gets the value of the inactive property.
     * This getter has been renamed from isInactive() to getInactive() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getInactive() {
        return inactive;
    }

    /**
     * Sets the value of the inactive property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setInactive(Boolean value) {
        this.inactive = value;
    }

    /**
     * Gets the value of the spendCategoryHierarchyDisplayOptionReference property.
     * 
     * @return
     *     possible object is
     *     {@link SpendCategoryOrHierarchyDisplayOptionObjectType }
     *     
     */
    public SpendCategoryOrHierarchyDisplayOptionObjectType getSpendCategoryHierarchyDisplayOptionReference() {
        return spendCategoryHierarchyDisplayOptionReference;
    }

    /**
     * Sets the value of the spendCategoryHierarchyDisplayOptionReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link SpendCategoryOrHierarchyDisplayOptionObjectType }
     *     
     */
    public void setSpendCategoryHierarchyDisplayOptionReference(SpendCategoryOrHierarchyDisplayOptionObjectType value) {
        this.spendCategoryHierarchyDisplayOptionReference = value;
    }

    /**
     * Sets the value of the includedSpendCategoriesReference property.
     * 
     * @param includedSpendCategoriesReference
     *     allowed object is
     *     {@link SpendCategoryObjectType }
     *     
     */
    public void setIncludedSpendCategoriesReference(List<SpendCategoryObjectType> includedSpendCategoriesReference) {
        this.includedSpendCategoriesReference = includedSpendCategoriesReference;
    }

}
