
package com.workday.financial;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;


/**
 * Element containing all Spend Category data
 * 
 * <p>Java class for Spend_Category_DataType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Spend_Category_DataType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Resource_Category_ID" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Resource_Category_Name" type="{http://www.w3.org/2001/XMLSchema}string"/>
 *         &lt;element name="Procurement_Usage" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Expense_Usage" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Tax_Applicability_Reference" type="{urn:com.workday/bsvc}Tax_ApplicabilityObjectType" minOccurs="0"/>
 *         &lt;element name="Allocate_Freight" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Allocate_Other_Charges" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Track_Items" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Accounting_Treatment_Reference" type="{urn:com.workday/bsvc}Accounting_TreatmentObjectType"/>
 *         &lt;element name="Depreciation_Profile_Reference" type="{urn:com.workday/bsvc}Depreciation_ProfileObjectType" minOccurs="0"/>
 *         &lt;element name="UNSPSC_Code_Range" type="{urn:com.workday/bsvc}UNSPSC_Code_RangeType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Asset_Type_Reference" type="{urn:com.workday/bsvc}Asset_TypeObjectType" minOccurs="0"/>
 *         &lt;element name="Asset_Class_Reference" type="{urn:com.workday/bsvc}Asset_ClassObjectType" minOccurs="0"/>
 *         &lt;element name="Intangible_Reference" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Commodity_Code" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Description" type="{urn:com.workday/bsvc}RichText" minOccurs="0"/>
 *         &lt;element name="Spend_Category_Display_Option_Reference" type="{urn:com.workday/bsvc}Spend_Category_or_Hierarchy_Display_OptionObjectType" minOccurs="0"/>
 *         &lt;element name="Inactive" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Related_Worktags_for_Resource_Category_Data" type="{urn:com.workday/bsvc}Related_Worktags_for_Webservices_EditType" maxOccurs="unbounded" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Spend_Category_DataType", propOrder = {
    "resourceCategoryID",
    "resourceCategoryName",
    "procurementUsage",
    "expenseUsage",
    "taxApplicabilityReference",
    "allocateFreight",
    "allocateOtherCharges",
    "trackItems",
    "accountingTreatmentReference",
    "depreciationProfileReference",
    "unspscCodeRange",
    "assetTypeReference",
    "assetClassReference",
    "intangibleReference",
    "commodityCode",
    "description",
    "spendCategoryDisplayOptionReference",
    "inactive",
    "relatedWorktagsForResourceCategoryData"
})
public class SpendCategoryDataType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Resource_Category_ID")
    protected String resourceCategoryID;
    @XmlElement(name = "Resource_Category_Name", required = true)
    protected String resourceCategoryName;
    @XmlElement(name = "Procurement_Usage")
    protected Boolean procurementUsage;
    @XmlElement(name = "Expense_Usage")
    protected Boolean expenseUsage;
    @XmlElement(name = "Tax_Applicability_Reference")
    protected TaxApplicabilityObjectType taxApplicabilityReference;
    @XmlElement(name = "Allocate_Freight")
    protected Boolean allocateFreight;
    @XmlElement(name = "Allocate_Other_Charges")
    protected Boolean allocateOtherCharges;
    @XmlElement(name = "Track_Items")
    protected Boolean trackItems;
    @XmlElement(name = "Accounting_Treatment_Reference", required = true)
    protected AccountingTreatmentObjectType accountingTreatmentReference;
    @XmlElement(name = "Depreciation_Profile_Reference")
    protected DepreciationProfileObjectType depreciationProfileReference;
    @XmlElement(name = "UNSPSC_Code_Range")
    protected List<UNSPSCCodeRangeType> unspscCodeRange;
    @XmlElement(name = "Asset_Type_Reference")
    protected AssetTypeObjectType assetTypeReference;
    @XmlElement(name = "Asset_Class_Reference")
    protected AssetClassObjectType assetClassReference;
    @XmlElement(name = "Intangible_Reference")
    protected Boolean intangibleReference;
    @XmlElement(name = "Commodity_Code")
    protected String commodityCode;
    @XmlElement(name = "Description")
    protected String description;
    @XmlElement(name = "Spend_Category_Display_Option_Reference")
    protected SpendCategoryOrHierarchyDisplayOptionObjectType spendCategoryDisplayOptionReference;
    @XmlElement(name = "Inactive")
    protected Boolean inactive;
    @XmlElement(name = "Related_Worktags_for_Resource_Category_Data")
    protected List<RelatedWorktagsForWebservicesEditType> relatedWorktagsForResourceCategoryData;

    /**
     * Gets the value of the resourceCategoryID property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getResourceCategoryID() {
        return resourceCategoryID;
    }

    /**
     * Sets the value of the resourceCategoryID property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setResourceCategoryID(String value) {
        this.resourceCategoryID = value;
    }

    /**
     * Gets the value of the resourceCategoryName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getResourceCategoryName() {
        return resourceCategoryName;
    }

    /**
     * Sets the value of the resourceCategoryName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setResourceCategoryName(String value) {
        this.resourceCategoryName = value;
    }

    /**
     * Gets the value of the procurementUsage property.
     * This getter has been renamed from isProcurementUsage() to getProcurementUsage() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getProcurementUsage() {
        return procurementUsage;
    }

    /**
     * Sets the value of the procurementUsage property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setProcurementUsage(Boolean value) {
        this.procurementUsage = value;
    }

    /**
     * Gets the value of the expenseUsage property.
     * This getter has been renamed from isExpenseUsage() to getExpenseUsage() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getExpenseUsage() {
        return expenseUsage;
    }

    /**
     * Sets the value of the expenseUsage property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setExpenseUsage(Boolean value) {
        this.expenseUsage = value;
    }

    /**
     * Gets the value of the taxApplicabilityReference property.
     * 
     * @return
     *     possible object is
     *     {@link TaxApplicabilityObjectType }
     *     
     */
    public TaxApplicabilityObjectType getTaxApplicabilityReference() {
        return taxApplicabilityReference;
    }

    /**
     * Sets the value of the taxApplicabilityReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link TaxApplicabilityObjectType }
     *     
     */
    public void setTaxApplicabilityReference(TaxApplicabilityObjectType value) {
        this.taxApplicabilityReference = value;
    }

    /**
     * Gets the value of the allocateFreight property.
     * This getter has been renamed from isAllocateFreight() to getAllocateFreight() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getAllocateFreight() {
        return allocateFreight;
    }

    /**
     * Sets the value of the allocateFreight property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setAllocateFreight(Boolean value) {
        this.allocateFreight = value;
    }

    /**
     * Gets the value of the allocateOtherCharges property.
     * This getter has been renamed from isAllocateOtherCharges() to getAllocateOtherCharges() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getAllocateOtherCharges() {
        return allocateOtherCharges;
    }

    /**
     * Sets the value of the allocateOtherCharges property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setAllocateOtherCharges(Boolean value) {
        this.allocateOtherCharges = value;
    }

    /**
     * Gets the value of the trackItems property.
     * This getter has been renamed from isTrackItems() to getTrackItems() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getTrackItems() {
        return trackItems;
    }

    /**
     * Sets the value of the trackItems property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setTrackItems(Boolean value) {
        this.trackItems = value;
    }

    /**
     * Gets the value of the accountingTreatmentReference property.
     * 
     * @return
     *     possible object is
     *     {@link AccountingTreatmentObjectType }
     *     
     */
    public AccountingTreatmentObjectType getAccountingTreatmentReference() {
        return accountingTreatmentReference;
    }

    /**
     * Sets the value of the accountingTreatmentReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link AccountingTreatmentObjectType }
     *     
     */
    public void setAccountingTreatmentReference(AccountingTreatmentObjectType value) {
        this.accountingTreatmentReference = value;
    }

    /**
     * Gets the value of the depreciationProfileReference property.
     * 
     * @return
     *     possible object is
     *     {@link DepreciationProfileObjectType }
     *     
     */
    public DepreciationProfileObjectType getDepreciationProfileReference() {
        return depreciationProfileReference;
    }

    /**
     * Sets the value of the depreciationProfileReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link DepreciationProfileObjectType }
     *     
     */
    public void setDepreciationProfileReference(DepreciationProfileObjectType value) {
        this.depreciationProfileReference = value;
    }

    /**
     * Gets the value of the unspscCodeRange property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the unspscCodeRange property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getUNSPSCCodeRange().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link UNSPSCCodeRangeType }
     * 
     * 
     */
    public List<UNSPSCCodeRangeType> getUNSPSCCodeRange() {
        if (unspscCodeRange == null) {
            unspscCodeRange = new ArrayList<UNSPSCCodeRangeType>();
        }
        return this.unspscCodeRange;
    }

    /**
     * Gets the value of the assetTypeReference property.
     * 
     * @return
     *     possible object is
     *     {@link AssetTypeObjectType }
     *     
     */
    public AssetTypeObjectType getAssetTypeReference() {
        return assetTypeReference;
    }

    /**
     * Sets the value of the assetTypeReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link AssetTypeObjectType }
     *     
     */
    public void setAssetTypeReference(AssetTypeObjectType value) {
        this.assetTypeReference = value;
    }

    /**
     * Gets the value of the assetClassReference property.
     * 
     * @return
     *     possible object is
     *     {@link AssetClassObjectType }
     *     
     */
    public AssetClassObjectType getAssetClassReference() {
        return assetClassReference;
    }

    /**
     * Sets the value of the assetClassReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link AssetClassObjectType }
     *     
     */
    public void setAssetClassReference(AssetClassObjectType value) {
        this.assetClassReference = value;
    }

    /**
     * Gets the value of the intangibleReference property.
     * This getter has been renamed from isIntangibleReference() to getIntangibleReference() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getIntangibleReference() {
        return intangibleReference;
    }

    /**
     * Sets the value of the intangibleReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setIntangibleReference(Boolean value) {
        this.intangibleReference = value;
    }

    /**
     * Gets the value of the commodityCode property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getCommodityCode() {
        return commodityCode;
    }

    /**
     * Sets the value of the commodityCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setCommodityCode(String value) {
        this.commodityCode = value;
    }

    /**
     * Gets the value of the description property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getDescription() {
        return description;
    }

    /**
     * Sets the value of the description property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setDescription(String value) {
        this.description = value;
    }

    /**
     * Gets the value of the spendCategoryDisplayOptionReference property.
     * 
     * @return
     *     possible object is
     *     {@link SpendCategoryOrHierarchyDisplayOptionObjectType }
     *     
     */
    public SpendCategoryOrHierarchyDisplayOptionObjectType getSpendCategoryDisplayOptionReference() {
        return spendCategoryDisplayOptionReference;
    }

    /**
     * Sets the value of the spendCategoryDisplayOptionReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link SpendCategoryOrHierarchyDisplayOptionObjectType }
     *     
     */
    public void setSpendCategoryDisplayOptionReference(SpendCategoryOrHierarchyDisplayOptionObjectType value) {
        this.spendCategoryDisplayOptionReference = value;
    }

    /**
     * Gets the value of the inactive property.
     * This getter has been renamed from isInactive() to getInactive() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getInactive() {
        return inactive;
    }

    /**
     * Sets the value of the inactive property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setInactive(Boolean value) {
        this.inactive = value;
    }

    /**
     * Gets the value of the relatedWorktagsForResourceCategoryData property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the relatedWorktagsForResourceCategoryData property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getRelatedWorktagsForResourceCategoryData().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link RelatedWorktagsForWebservicesEditType }
     * 
     * 
     */
    public List<RelatedWorktagsForWebservicesEditType> getRelatedWorktagsForResourceCategoryData() {
        if (relatedWorktagsForResourceCategoryData == null) {
            relatedWorktagsForResourceCategoryData = new ArrayList<RelatedWorktagsForWebservicesEditType>();
        }
        return this.relatedWorktagsForResourceCategoryData;
    }

    /**
     * Sets the value of the unspscCodeRange property.
     * 
     * @param unspscCodeRange
     *     allowed object is
     *     {@link UNSPSCCodeRangeType }
     *     
     */
    public void setUNSPSCCodeRange(List<UNSPSCCodeRangeType> unspscCodeRange) {
        this.unspscCodeRange = unspscCodeRange;
    }

    /**
     * Sets the value of the relatedWorktagsForResourceCategoryData property.
     * 
     * @param relatedWorktagsForResourceCategoryData
     *     allowed object is
     *     {@link RelatedWorktagsForWebservicesEditType }
     *     
     */
    public void setRelatedWorktagsForResourceCategoryData(List<RelatedWorktagsForWebservicesEditType> relatedWorktagsForResourceCategoryData) {
        this.relatedWorktagsForResourceCategoryData = relatedWorktagsForResourceCategoryData;
    }

}
