
package com.workday.financial;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;


/**
 * Settlement Account information including Bank Account Type, Currency, Routing Transit Number, etc.
 * 
 * <p>Java class for Settlement_Account_WWS_DataType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Settlement_Account_WWS_DataType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Country_Reference" type="{urn:com.workday/bsvc}CountryObjectType" minOccurs="0"/>
 *         &lt;element name="Currency_Reference" type="{urn:com.workday/bsvc}CurrencyObjectType" minOccurs="0"/>
 *         &lt;element name="Bank_Account_Nickname" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Bank_Account_Type_Reference" type="{urn:com.workday/bsvc}Bank_Account_TypeObjectType" minOccurs="0"/>
 *         &lt;element name="Bank_Name" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Routing_Transit_Number" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Branch_ID" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Branch_Name" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Bank_Account_Number" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Check_Digit" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Bank_Account_Name" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Roll_Number" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="IBAN" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="SWIFT_Bank_Identification_Code" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Payment_Types_Reference" type="{urn:com.workday/bsvc}Payment_TypeObjectType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Inactive" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Bank_Instructions" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Intermediary_Bank_Data" type="{urn:com.workday/bsvc}Intermediary_Bank_Account_WWS_DataType" maxOccurs="unbounded" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Settlement_Account_WWS_DataType", propOrder = {
    "countryReference",
    "currencyReference",
    "bankAccountNickname",
    "bankAccountTypeReference",
    "bankName",
    "routingTransitNumber",
    "branchID",
    "branchName",
    "bankAccountNumber",
    "checkDigit",
    "bankAccountName",
    "rollNumber",
    "iban",
    "swiftBankIdentificationCode",
    "paymentTypesReference",
    "inactive",
    "bankInstructions",
    "intermediaryBankData"
})
public class SettlementAccountWWSDataType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Country_Reference")
    protected CountryObjectType countryReference;
    @XmlElement(name = "Currency_Reference")
    protected CurrencyObjectType currencyReference;
    @XmlElement(name = "Bank_Account_Nickname")
    protected String bankAccountNickname;
    @XmlElement(name = "Bank_Account_Type_Reference")
    protected BankAccountTypeObjectType bankAccountTypeReference;
    @XmlElement(name = "Bank_Name")
    protected String bankName;
    @XmlElement(name = "Routing_Transit_Number")
    protected String routingTransitNumber;
    @XmlElement(name = "Branch_ID")
    protected String branchID;
    @XmlElement(name = "Branch_Name")
    protected String branchName;
    @XmlElement(name = "Bank_Account_Number")
    protected String bankAccountNumber;
    @XmlElement(name = "Check_Digit")
    protected String checkDigit;
    @XmlElement(name = "Bank_Account_Name")
    protected String bankAccountName;
    @XmlElement(name = "Roll_Number")
    protected String rollNumber;
    @XmlElement(name = "IBAN")
    protected String iban;
    @XmlElement(name = "SWIFT_Bank_Identification_Code")
    protected String swiftBankIdentificationCode;
    @XmlElement(name = "Payment_Types_Reference")
    protected List<PaymentTypeObjectType> paymentTypesReference;
    @XmlElement(name = "Inactive")
    protected Boolean inactive;
    @XmlElement(name = "Bank_Instructions")
    protected String bankInstructions;
    @XmlElement(name = "Intermediary_Bank_Data")
    protected List<IntermediaryBankAccountWWSDataType> intermediaryBankData;

    /**
     * Gets the value of the countryReference property.
     * 
     * @return
     *     possible object is
     *     {@link CountryObjectType }
     *     
     */
    public CountryObjectType getCountryReference() {
        return countryReference;
    }

    /**
     * Sets the value of the countryReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link CountryObjectType }
     *     
     */
    public void setCountryReference(CountryObjectType value) {
        this.countryReference = value;
    }

    /**
     * Gets the value of the currencyReference property.
     * 
     * @return
     *     possible object is
     *     {@link CurrencyObjectType }
     *     
     */
    public CurrencyObjectType getCurrencyReference() {
        return currencyReference;
    }

    /**
     * Sets the value of the currencyReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link CurrencyObjectType }
     *     
     */
    public void setCurrencyReference(CurrencyObjectType value) {
        this.currencyReference = value;
    }

    /**
     * Gets the value of the bankAccountNickname property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getBankAccountNickname() {
        return bankAccountNickname;
    }

    /**
     * Sets the value of the bankAccountNickname property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setBankAccountNickname(String value) {
        this.bankAccountNickname = value;
    }

    /**
     * Gets the value of the bankAccountTypeReference property.
     * 
     * @return
     *     possible object is
     *     {@link BankAccountTypeObjectType }
     *     
     */
    public BankAccountTypeObjectType getBankAccountTypeReference() {
        return bankAccountTypeReference;
    }

    /**
     * Sets the value of the bankAccountTypeReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link BankAccountTypeObjectType }
     *     
     */
    public void setBankAccountTypeReference(BankAccountTypeObjectType value) {
        this.bankAccountTypeReference = value;
    }

    /**
     * Gets the value of the bankName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getBankName() {
        return bankName;
    }

    /**
     * Sets the value of the bankName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setBankName(String value) {
        this.bankName = value;
    }

    /**
     * Gets the value of the routingTransitNumber property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getRoutingTransitNumber() {
        return routingTransitNumber;
    }

    /**
     * Sets the value of the routingTransitNumber property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setRoutingTransitNumber(String value) {
        this.routingTransitNumber = value;
    }

    /**
     * Gets the value of the branchID property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getBranchID() {
        return branchID;
    }

    /**
     * Sets the value of the branchID property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setBranchID(String value) {
        this.branchID = value;
    }

    /**
     * Gets the value of the branchName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getBranchName() {
        return branchName;
    }

    /**
     * Sets the value of the branchName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setBranchName(String value) {
        this.branchName = value;
    }

    /**
     * Gets the value of the bankAccountNumber property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getBankAccountNumber() {
        return bankAccountNumber;
    }

    /**
     * Sets the value of the bankAccountNumber property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setBankAccountNumber(String value) {
        this.bankAccountNumber = value;
    }

    /**
     * Gets the value of the checkDigit property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getCheckDigit() {
        return checkDigit;
    }

    /**
     * Sets the value of the checkDigit property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setCheckDigit(String value) {
        this.checkDigit = value;
    }

    /**
     * Gets the value of the bankAccountName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getBankAccountName() {
        return bankAccountName;
    }

    /**
     * Sets the value of the bankAccountName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setBankAccountName(String value) {
        this.bankAccountName = value;
    }

    /**
     * Gets the value of the rollNumber property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getRollNumber() {
        return rollNumber;
    }

    /**
     * Sets the value of the rollNumber property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setRollNumber(String value) {
        this.rollNumber = value;
    }

    /**
     * Gets the value of the iban property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getIBAN() {
        return iban;
    }

    /**
     * Sets the value of the iban property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setIBAN(String value) {
        this.iban = value;
    }

    /**
     * Gets the value of the swiftBankIdentificationCode property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getSWIFTBankIdentificationCode() {
        return swiftBankIdentificationCode;
    }

    /**
     * Sets the value of the swiftBankIdentificationCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setSWIFTBankIdentificationCode(String value) {
        this.swiftBankIdentificationCode = value;
    }

    /**
     * Gets the value of the paymentTypesReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the paymentTypesReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getPaymentTypesReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link PaymentTypeObjectType }
     * 
     * 
     */
    public List<PaymentTypeObjectType> getPaymentTypesReference() {
        if (paymentTypesReference == null) {
            paymentTypesReference = new ArrayList<PaymentTypeObjectType>();
        }
        return this.paymentTypesReference;
    }

    /**
     * Gets the value of the inactive property.
     * This getter has been renamed from isInactive() to getInactive() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getInactive() {
        return inactive;
    }

    /**
     * Sets the value of the inactive property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setInactive(Boolean value) {
        this.inactive = value;
    }

    /**
     * Gets the value of the bankInstructions property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getBankInstructions() {
        return bankInstructions;
    }

    /**
     * Sets the value of the bankInstructions property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setBankInstructions(String value) {
        this.bankInstructions = value;
    }

    /**
     * Gets the value of the intermediaryBankData property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the intermediaryBankData property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getIntermediaryBankData().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link IntermediaryBankAccountWWSDataType }
     * 
     * 
     */
    public List<IntermediaryBankAccountWWSDataType> getIntermediaryBankData() {
        if (intermediaryBankData == null) {
            intermediaryBankData = new ArrayList<IntermediaryBankAccountWWSDataType>();
        }
        return this.intermediaryBankData;
    }

    /**
     * Sets the value of the paymentTypesReference property.
     * 
     * @param paymentTypesReference
     *     allowed object is
     *     {@link PaymentTypeObjectType }
     *     
     */
    public void setPaymentTypesReference(List<PaymentTypeObjectType> paymentTypesReference) {
        this.paymentTypesReference = paymentTypesReference;
    }

    /**
     * Sets the value of the intermediaryBankData property.
     * 
     * @param intermediaryBankData
     *     allowed object is
     *     {@link IntermediaryBankAccountWWSDataType }
     *     
     */
    public void setIntermediaryBankData(List<IntermediaryBankAccountWWSDataType> intermediaryBankData) {
        this.intermediaryBankData = intermediaryBankData;
    }

}
