
package com.workday.financial;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;


/**
 * Revenue Category Hierarchy Data
 * 
 * <p>Java class for Revenue_Category_Hierarchy_DataType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Revenue_Category_Hierarchy_DataType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="ID" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Revenue_Category_Hierarchy_Name" type="{http://www.w3.org/2001/XMLSchema}string"/>
 *         &lt;element name="Hierarchy_Level_Reference" type="{urn:com.workday/bsvc}Hierarchy_LevelObjectType" minOccurs="0"/>
 *         &lt;element name="Parent_Revenue__Category_Hierarchy_Reference" type="{urn:com.workday/bsvc}Revenue_Category_HierarchyObjectType" minOccurs="0"/>
 *         &lt;element name="Revenue_Categories_Included_Reference" type="{urn:com.workday/bsvc}Revenue_CategoryObjectType" maxOccurs="unbounded" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Revenue_Category_Hierarchy_DataType", propOrder = {
    "id",
    "revenueCategoryHierarchyName",
    "hierarchyLevelReference",
    "parentRevenueCategoryHierarchyReference",
    "revenueCategoriesIncludedReference"
})
public class RevenueCategoryHierarchyDataType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "ID")
    protected String id;
    @XmlElement(name = "Revenue_Category_Hierarchy_Name", required = true)
    protected String revenueCategoryHierarchyName;
    @XmlElement(name = "Hierarchy_Level_Reference")
    protected HierarchyLevelObjectType hierarchyLevelReference;
    @XmlElement(name = "Parent_Revenue__Category_Hierarchy_Reference")
    protected RevenueCategoryHierarchyObjectType parentRevenueCategoryHierarchyReference;
    @XmlElement(name = "Revenue_Categories_Included_Reference")
    protected List<RevenueCategoryObjectType> revenueCategoriesIncludedReference;

    /**
     * Gets the value of the id property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getID() {
        return id;
    }

    /**
     * Sets the value of the id property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setID(String value) {
        this.id = value;
    }

    /**
     * Gets the value of the revenueCategoryHierarchyName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getRevenueCategoryHierarchyName() {
        return revenueCategoryHierarchyName;
    }

    /**
     * Sets the value of the revenueCategoryHierarchyName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setRevenueCategoryHierarchyName(String value) {
        this.revenueCategoryHierarchyName = value;
    }

    /**
     * Gets the value of the hierarchyLevelReference property.
     * 
     * @return
     *     possible object is
     *     {@link HierarchyLevelObjectType }
     *     
     */
    public HierarchyLevelObjectType getHierarchyLevelReference() {
        return hierarchyLevelReference;
    }

    /**
     * Sets the value of the hierarchyLevelReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link HierarchyLevelObjectType }
     *     
     */
    public void setHierarchyLevelReference(HierarchyLevelObjectType value) {
        this.hierarchyLevelReference = value;
    }

    /**
     * Gets the value of the parentRevenueCategoryHierarchyReference property.
     * 
     * @return
     *     possible object is
     *     {@link RevenueCategoryHierarchyObjectType }
     *     
     */
    public RevenueCategoryHierarchyObjectType getParentRevenueCategoryHierarchyReference() {
        return parentRevenueCategoryHierarchyReference;
    }

    /**
     * Sets the value of the parentRevenueCategoryHierarchyReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link RevenueCategoryHierarchyObjectType }
     *     
     */
    public void setParentRevenueCategoryHierarchyReference(RevenueCategoryHierarchyObjectType value) {
        this.parentRevenueCategoryHierarchyReference = value;
    }

    /**
     * Gets the value of the revenueCategoriesIncludedReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the revenueCategoriesIncludedReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getRevenueCategoriesIncludedReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link RevenueCategoryObjectType }
     * 
     * 
     */
    public List<RevenueCategoryObjectType> getRevenueCategoriesIncludedReference() {
        if (revenueCategoriesIncludedReference == null) {
            revenueCategoriesIncludedReference = new ArrayList<RevenueCategoryObjectType>();
        }
        return this.revenueCategoriesIncludedReference;
    }

    /**
     * Sets the value of the revenueCategoriesIncludedReference property.
     * 
     * @param revenueCategoriesIncludedReference
     *     allowed object is
     *     {@link RevenueCategoryObjectType }
     *     
     */
    public void setRevenueCategoriesIncludedReference(List<RevenueCategoryObjectType> revenueCategoriesIncludedReference) {
        this.revenueCategoriesIncludedReference = revenueCategoriesIncludedReference;
    }

}
