
package com.workday.financial;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;


/**
 * Element containing all Revenue Category data
 * 
 * <p>Java class for Revenue_Category_DataType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Revenue_Category_DataType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Revenue_Category_ID" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Revenue_Category_Name" type="{http://www.w3.org/2001/XMLSchema}string"/>
 *         &lt;element name="Tax_Applicability_Reference" type="{urn:com.workday/bsvc}Tax_ApplicabilityObjectType" minOccurs="0"/>
 *         &lt;element name="Related_Worktags_Reference" type="{urn:com.workday/bsvc}Accounting_WorktagObjectType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Revenue_Category_Inactive" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Revenue_Category_DataType", propOrder = {
    "revenueCategoryID",
    "revenueCategoryName",
    "taxApplicabilityReference",
    "relatedWorktagsReference",
    "revenueCategoryInactive"
})
public class RevenueCategoryDataType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Revenue_Category_ID")
    protected String revenueCategoryID;
    @XmlElement(name = "Revenue_Category_Name", required = true)
    protected String revenueCategoryName;
    @XmlElement(name = "Tax_Applicability_Reference")
    protected TaxApplicabilityObjectType taxApplicabilityReference;
    @XmlElement(name = "Related_Worktags_Reference")
    protected List<AccountingWorktagObjectType> relatedWorktagsReference;
    @XmlElement(name = "Revenue_Category_Inactive")
    protected Boolean revenueCategoryInactive;

    /**
     * Gets the value of the revenueCategoryID property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getRevenueCategoryID() {
        return revenueCategoryID;
    }

    /**
     * Sets the value of the revenueCategoryID property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setRevenueCategoryID(String value) {
        this.revenueCategoryID = value;
    }

    /**
     * Gets the value of the revenueCategoryName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getRevenueCategoryName() {
        return revenueCategoryName;
    }

    /**
     * Sets the value of the revenueCategoryName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setRevenueCategoryName(String value) {
        this.revenueCategoryName = value;
    }

    /**
     * Gets the value of the taxApplicabilityReference property.
     * 
     * @return
     *     possible object is
     *     {@link TaxApplicabilityObjectType }
     *     
     */
    public TaxApplicabilityObjectType getTaxApplicabilityReference() {
        return taxApplicabilityReference;
    }

    /**
     * Sets the value of the taxApplicabilityReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link TaxApplicabilityObjectType }
     *     
     */
    public void setTaxApplicabilityReference(TaxApplicabilityObjectType value) {
        this.taxApplicabilityReference = value;
    }

    /**
     * Gets the value of the relatedWorktagsReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the relatedWorktagsReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getRelatedWorktagsReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AccountingWorktagObjectType }
     * 
     * 
     */
    public List<AccountingWorktagObjectType> getRelatedWorktagsReference() {
        if (relatedWorktagsReference == null) {
            relatedWorktagsReference = new ArrayList<AccountingWorktagObjectType>();
        }
        return this.relatedWorktagsReference;
    }

    /**
     * Gets the value of the revenueCategoryInactive property.
     * This getter has been renamed from isRevenueCategoryInactive() to getRevenueCategoryInactive() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getRevenueCategoryInactive() {
        return revenueCategoryInactive;
    }

    /**
     * Sets the value of the revenueCategoryInactive property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setRevenueCategoryInactive(Boolean value) {
        this.revenueCategoryInactive = value;
    }

    /**
     * Sets the value of the relatedWorktagsReference property.
     * 
     * @param relatedWorktagsReference
     *     allowed object is
     *     {@link AccountingWorktagObjectType }
     *     
     */
    public void setRelatedWorktagsReference(List<AccountingWorktagObjectType> relatedWorktagsReference) {
        this.relatedWorktagsReference = relatedWorktagsReference;
    }

}
