
package com.workday.financial;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.datatype.XMLGregorianCalendar;


/**
 * Element containing all Recurring Journal Template data
 * 
 * <p>Java class for Recurring_Journal_Template_DataType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Recurring_Journal_Template_DataType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Recurring_Journal_Template_ID" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Round_Ledger_Amounts" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Recurring_Journal_Template_Name" type="{http://www.w3.org/2001/XMLSchema}string"/>
 *         &lt;element name="Currency_Reference" type="{urn:com.workday/bsvc}CurrencyObjectType"/>
 *         &lt;element name="Currency_Rate_Type_Reference" type="{urn:com.workday/bsvc}Currency_Rate_TypeObjectType" minOccurs="0"/>
 *         &lt;element name="Display_Account_Set_Reference" type="{urn:com.workday/bsvc}Account_SetObjectType" minOccurs="0"/>
 *         &lt;element name="Ledger_Reference_Data" type="{urn:com.workday/bsvc}Ledger_ReferenceType"/>
 *         &lt;element name="Recurring_Journal_Template_Start_Date" type="{http://www.w3.org/2001/XMLSchema}date"/>
 *         &lt;element name="Recurring_Journal_Template_End_Date" type="{http://www.w3.org/2001/XMLSchema}date"/>
 *         &lt;element name="Reset_Currency_Rate_at_Journal_Generation" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Automatically_Submit_Journals_Generated_from_Recurring_Journal_Template" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;choice>
 *           &lt;element name="Generate_Once_Per_Period" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *           &lt;element name="Summary_Schedule_Reference" type="{urn:com.workday/bsvc}Fiscal_Summary_ScheduleObjectType" minOccurs="0"/>
 *         &lt;/choice>
 *         &lt;element name="Journal_Entry_Memo" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Control_Total_Amount" minOccurs="0">
 *           &lt;simpleType>
 *             &lt;restriction base="{http://www.w3.org/2001/XMLSchema}decimal">
 *               &lt;totalDigits value="26"/>
 *               &lt;fractionDigits value="6"/>
 *             &lt;/restriction>
 *           &lt;/simpleType>
 *         &lt;/element>
 *         &lt;element name="Journal_Source_Reference" type="{urn:com.workday/bsvc}Journal_SourceObjectType"/>
 *         &lt;element name="Book_Code_Reference" type="{urn:com.workday/bsvc}Book_CodeObjectType" minOccurs="0"/>
 *         &lt;element name="Balancing_Worktag_Reference" type="{urn:com.workday/bsvc}Balancing_WorktagObjectType" minOccurs="0"/>
 *         &lt;element name="Journal_Entry_Line_Replacement_Data" type="{urn:com.workday/bsvc}Journal_Entry_Line_DataType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Company_Reference" type="{urn:com.workday/bsvc}CompanyObjectType"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Recurring_Journal_Template_DataType", propOrder = {
    "recurringJournalTemplateID",
    "roundLedgerAmounts",
    "recurringJournalTemplateName",
    "currencyReference",
    "currencyRateTypeReference",
    "displayAccountSetReference",
    "ledgerReferenceData",
    "recurringJournalTemplateStartDate",
    "recurringJournalTemplateEndDate",
    "resetCurrencyRateAtJournalGeneration",
    "automaticallySubmitJournalsGeneratedFromRecurringJournalTemplate",
    "generateOncePerPeriod",
    "summaryScheduleReference",
    "journalEntryMemo",
    "controlTotalAmount",
    "journalSourceReference",
    "bookCodeReference",
    "balancingWorktagReference",
    "journalEntryLineReplacementData",
    "companyReference"
})
public class RecurringJournalTemplateDataType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Recurring_Journal_Template_ID")
    protected String recurringJournalTemplateID;
    @XmlElement(name = "Round_Ledger_Amounts")
    protected Boolean roundLedgerAmounts;
    @XmlElement(name = "Recurring_Journal_Template_Name", required = true)
    protected String recurringJournalTemplateName;
    @XmlElement(name = "Currency_Reference", required = true)
    protected CurrencyObjectType currencyReference;
    @XmlElement(name = "Currency_Rate_Type_Reference")
    protected CurrencyRateTypeObjectType currencyRateTypeReference;
    @XmlElement(name = "Display_Account_Set_Reference")
    protected AccountSetObjectType displayAccountSetReference;
    @XmlElement(name = "Ledger_Reference_Data", required = true)
    protected LedgerReferenceType ledgerReferenceData;
    @XmlElement(name = "Recurring_Journal_Template_Start_Date", required = true)
    @XmlSchemaType(name = "date")
    protected XMLGregorianCalendar recurringJournalTemplateStartDate;
    @XmlElement(name = "Recurring_Journal_Template_End_Date", required = true)
    @XmlSchemaType(name = "date")
    protected XMLGregorianCalendar recurringJournalTemplateEndDate;
    @XmlElement(name = "Reset_Currency_Rate_at_Journal_Generation")
    protected Boolean resetCurrencyRateAtJournalGeneration;
    @XmlElement(name = "Automatically_Submit_Journals_Generated_from_Recurring_Journal_Template")
    protected Boolean automaticallySubmitJournalsGeneratedFromRecurringJournalTemplate;
    @XmlElement(name = "Generate_Once_Per_Period")
    protected Boolean generateOncePerPeriod;
    @XmlElement(name = "Summary_Schedule_Reference")
    protected FiscalSummaryScheduleObjectType summaryScheduleReference;
    @XmlElement(name = "Journal_Entry_Memo")
    protected String journalEntryMemo;
    @XmlElement(name = "Control_Total_Amount")
    protected BigDecimal controlTotalAmount;
    @XmlElement(name = "Journal_Source_Reference", required = true)
    protected JournalSourceObjectType journalSourceReference;
    @XmlElement(name = "Book_Code_Reference")
    protected BookCodeObjectType bookCodeReference;
    @XmlElement(name = "Balancing_Worktag_Reference")
    protected BalancingWorktagObjectType balancingWorktagReference;
    @XmlElement(name = "Journal_Entry_Line_Replacement_Data")
    protected List<JournalEntryLineDataType> journalEntryLineReplacementData;
    @XmlElement(name = "Company_Reference", required = true)
    protected CompanyObjectType companyReference;

    /**
     * Gets the value of the recurringJournalTemplateID property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getRecurringJournalTemplateID() {
        return recurringJournalTemplateID;
    }

    /**
     * Sets the value of the recurringJournalTemplateID property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setRecurringJournalTemplateID(String value) {
        this.recurringJournalTemplateID = value;
    }

    /**
     * Gets the value of the roundLedgerAmounts property.
     * This getter has been renamed from isRoundLedgerAmounts() to getRoundLedgerAmounts() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getRoundLedgerAmounts() {
        return roundLedgerAmounts;
    }

    /**
     * Sets the value of the roundLedgerAmounts property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setRoundLedgerAmounts(Boolean value) {
        this.roundLedgerAmounts = value;
    }

    /**
     * Gets the value of the recurringJournalTemplateName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getRecurringJournalTemplateName() {
        return recurringJournalTemplateName;
    }

    /**
     * Sets the value of the recurringJournalTemplateName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setRecurringJournalTemplateName(String value) {
        this.recurringJournalTemplateName = value;
    }

    /**
     * Gets the value of the currencyReference property.
     * 
     * @return
     *     possible object is
     *     {@link CurrencyObjectType }
     *     
     */
    public CurrencyObjectType getCurrencyReference() {
        return currencyReference;
    }

    /**
     * Sets the value of the currencyReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link CurrencyObjectType }
     *     
     */
    public void setCurrencyReference(CurrencyObjectType value) {
        this.currencyReference = value;
    }

    /**
     * Gets the value of the currencyRateTypeReference property.
     * 
     * @return
     *     possible object is
     *     {@link CurrencyRateTypeObjectType }
     *     
     */
    public CurrencyRateTypeObjectType getCurrencyRateTypeReference() {
        return currencyRateTypeReference;
    }

    /**
     * Sets the value of the currencyRateTypeReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link CurrencyRateTypeObjectType }
     *     
     */
    public void setCurrencyRateTypeReference(CurrencyRateTypeObjectType value) {
        this.currencyRateTypeReference = value;
    }

    /**
     * Gets the value of the displayAccountSetReference property.
     * 
     * @return
     *     possible object is
     *     {@link AccountSetObjectType }
     *     
     */
    public AccountSetObjectType getDisplayAccountSetReference() {
        return displayAccountSetReference;
    }

    /**
     * Sets the value of the displayAccountSetReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link AccountSetObjectType }
     *     
     */
    public void setDisplayAccountSetReference(AccountSetObjectType value) {
        this.displayAccountSetReference = value;
    }

    /**
     * Gets the value of the ledgerReferenceData property.
     * 
     * @return
     *     possible object is
     *     {@link LedgerReferenceType }
     *     
     */
    public LedgerReferenceType getLedgerReferenceData() {
        return ledgerReferenceData;
    }

    /**
     * Sets the value of the ledgerReferenceData property.
     * 
     * @param value
     *     allowed object is
     *     {@link LedgerReferenceType }
     *     
     */
    public void setLedgerReferenceData(LedgerReferenceType value) {
        this.ledgerReferenceData = value;
    }

    /**
     * Gets the value of the recurringJournalTemplateStartDate property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getRecurringJournalTemplateStartDate() {
        return recurringJournalTemplateStartDate;
    }

    /**
     * Sets the value of the recurringJournalTemplateStartDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setRecurringJournalTemplateStartDate(XMLGregorianCalendar value) {
        this.recurringJournalTemplateStartDate = value;
    }

    /**
     * Gets the value of the recurringJournalTemplateEndDate property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getRecurringJournalTemplateEndDate() {
        return recurringJournalTemplateEndDate;
    }

    /**
     * Sets the value of the recurringJournalTemplateEndDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setRecurringJournalTemplateEndDate(XMLGregorianCalendar value) {
        this.recurringJournalTemplateEndDate = value;
    }

    /**
     * Gets the value of the resetCurrencyRateAtJournalGeneration property.
     * This getter has been renamed from isResetCurrencyRateAtJournalGeneration() to getResetCurrencyRateAtJournalGeneration() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getResetCurrencyRateAtJournalGeneration() {
        return resetCurrencyRateAtJournalGeneration;
    }

    /**
     * Sets the value of the resetCurrencyRateAtJournalGeneration property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setResetCurrencyRateAtJournalGeneration(Boolean value) {
        this.resetCurrencyRateAtJournalGeneration = value;
    }

    /**
     * Gets the value of the automaticallySubmitJournalsGeneratedFromRecurringJournalTemplate property.
     * This getter has been renamed from isAutomaticallySubmitJournalsGeneratedFromRecurringJournalTemplate() to getAutomaticallySubmitJournalsGeneratedFromRecurringJournalTemplate() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getAutomaticallySubmitJournalsGeneratedFromRecurringJournalTemplate() {
        return automaticallySubmitJournalsGeneratedFromRecurringJournalTemplate;
    }

    /**
     * Sets the value of the automaticallySubmitJournalsGeneratedFromRecurringJournalTemplate property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setAutomaticallySubmitJournalsGeneratedFromRecurringJournalTemplate(Boolean value) {
        this.automaticallySubmitJournalsGeneratedFromRecurringJournalTemplate = value;
    }

    /**
     * Gets the value of the generateOncePerPeriod property.
     * This getter has been renamed from isGenerateOncePerPeriod() to getGenerateOncePerPeriod() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getGenerateOncePerPeriod() {
        return generateOncePerPeriod;
    }

    /**
     * Sets the value of the generateOncePerPeriod property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setGenerateOncePerPeriod(Boolean value) {
        this.generateOncePerPeriod = value;
    }

    /**
     * Gets the value of the summaryScheduleReference property.
     * 
     * @return
     *     possible object is
     *     {@link FiscalSummaryScheduleObjectType }
     *     
     */
    public FiscalSummaryScheduleObjectType getSummaryScheduleReference() {
        return summaryScheduleReference;
    }

    /**
     * Sets the value of the summaryScheduleReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link FiscalSummaryScheduleObjectType }
     *     
     */
    public void setSummaryScheduleReference(FiscalSummaryScheduleObjectType value) {
        this.summaryScheduleReference = value;
    }

    /**
     * Gets the value of the journalEntryMemo property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getJournalEntryMemo() {
        return journalEntryMemo;
    }

    /**
     * Sets the value of the journalEntryMemo property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setJournalEntryMemo(String value) {
        this.journalEntryMemo = value;
    }

    /**
     * Gets the value of the controlTotalAmount property.
     * 
     * @return
     *     possible object is
     *     {@link BigDecimal }
     *     
     */
    public BigDecimal getControlTotalAmount() {
        return controlTotalAmount;
    }

    /**
     * Sets the value of the controlTotalAmount property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigDecimal }
     *     
     */
    public void setControlTotalAmount(BigDecimal value) {
        this.controlTotalAmount = value;
    }

    /**
     * Gets the value of the journalSourceReference property.
     * 
     * @return
     *     possible object is
     *     {@link JournalSourceObjectType }
     *     
     */
    public JournalSourceObjectType getJournalSourceReference() {
        return journalSourceReference;
    }

    /**
     * Sets the value of the journalSourceReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link JournalSourceObjectType }
     *     
     */
    public void setJournalSourceReference(JournalSourceObjectType value) {
        this.journalSourceReference = value;
    }

    /**
     * Gets the value of the bookCodeReference property.
     * 
     * @return
     *     possible object is
     *     {@link BookCodeObjectType }
     *     
     */
    public BookCodeObjectType getBookCodeReference() {
        return bookCodeReference;
    }

    /**
     * Sets the value of the bookCodeReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link BookCodeObjectType }
     *     
     */
    public void setBookCodeReference(BookCodeObjectType value) {
        this.bookCodeReference = value;
    }

    /**
     * Gets the value of the balancingWorktagReference property.
     * 
     * @return
     *     possible object is
     *     {@link BalancingWorktagObjectType }
     *     
     */
    public BalancingWorktagObjectType getBalancingWorktagReference() {
        return balancingWorktagReference;
    }

    /**
     * Sets the value of the balancingWorktagReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link BalancingWorktagObjectType }
     *     
     */
    public void setBalancingWorktagReference(BalancingWorktagObjectType value) {
        this.balancingWorktagReference = value;
    }

    /**
     * Gets the value of the journalEntryLineReplacementData property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the journalEntryLineReplacementData property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getJournalEntryLineReplacementData().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link JournalEntryLineDataType }
     * 
     * 
     */
    public List<JournalEntryLineDataType> getJournalEntryLineReplacementData() {
        if (journalEntryLineReplacementData == null) {
            journalEntryLineReplacementData = new ArrayList<JournalEntryLineDataType>();
        }
        return this.journalEntryLineReplacementData;
    }

    /**
     * Gets the value of the companyReference property.
     * 
     * @return
     *     possible object is
     *     {@link CompanyObjectType }
     *     
     */
    public CompanyObjectType getCompanyReference() {
        return companyReference;
    }

    /**
     * Sets the value of the companyReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link CompanyObjectType }
     *     
     */
    public void setCompanyReference(CompanyObjectType value) {
        this.companyReference = value;
    }

    /**
     * Sets the value of the journalEntryLineReplacementData property.
     * 
     * @param journalEntryLineReplacementData
     *     allowed object is
     *     {@link JournalEntryLineDataType }
     *     
     */
    public void setJournalEntryLineReplacementData(List<JournalEntryLineDataType> journalEntryLineReplacementData) {
        this.journalEntryLineReplacementData = journalEntryLineReplacementData;
    }

}
