
package com.workday.financial;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;


/**
 * Receiving Party Data
 * 
 * <p>Java class for Receiving_Party_WWS_DataType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Receiving_Party_WWS_DataType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Payee_Name" type="{http://www.w3.org/2001/XMLSchema}string"/>
 *         &lt;element name="Payee_Legal_Name" type="{http://www.w3.org/2001/XMLSchema}string"/>
 *         &lt;element name="Payee_Preferred_Name" type="{http://www.w3.org/2001/XMLSchema}string"/>
 *         &lt;element name="Payee_ID" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Expense_Payee_Employee_Number" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Tax_ID" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Corporate_Credit_Card_Account_Number" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Market_Code" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Country_Reference" type="{urn:com.workday/bsvc}CountryObjectType" minOccurs="0"/>
 *         &lt;element name="Payee_Alternate_Name" type="{urn:com.workday/bsvc}Business_Entity_Alternate_Name_DataType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Address_Information_Data" type="{urn:com.workday/bsvc}Address_Information_DataType" maxOccurs="unbounded" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Receiving_Party_WWS_DataType", propOrder = {
    "payeeName",
    "payeeLegalName",
    "payeePreferredName",
    "payeeID",
    "expensePayeeEmployeeNumber",
    "taxID",
    "corporateCreditCardAccountNumber",
    "marketCode",
    "countryReference",
    "payeeAlternateName",
    "addressInformationData"
})
public class ReceivingPartyWWSDataType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Payee_Name", required = true)
    protected String payeeName;
    @XmlElement(name = "Payee_Legal_Name", required = true)
    protected String payeeLegalName;
    @XmlElement(name = "Payee_Preferred_Name", required = true)
    protected String payeePreferredName;
    @XmlElement(name = "Payee_ID")
    protected String payeeID;
    @XmlElement(name = "Expense_Payee_Employee_Number")
    protected String expensePayeeEmployeeNumber;
    @XmlElement(name = "Tax_ID")
    protected String taxID;
    @XmlElement(name = "Corporate_Credit_Card_Account_Number")
    protected String corporateCreditCardAccountNumber;
    @XmlElement(name = "Market_Code")
    protected String marketCode;
    @XmlElement(name = "Country_Reference")
    protected CountryObjectType countryReference;
    @XmlElement(name = "Payee_Alternate_Name")
    protected List<BusinessEntityAlternateNameDataType> payeeAlternateName;
    @XmlElement(name = "Address_Information_Data")
    protected List<AddressInformationDataType> addressInformationData;

    /**
     * Gets the value of the payeeName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getPayeeName() {
        return payeeName;
    }

    /**
     * Sets the value of the payeeName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setPayeeName(String value) {
        this.payeeName = value;
    }

    /**
     * Gets the value of the payeeLegalName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getPayeeLegalName() {
        return payeeLegalName;
    }

    /**
     * Sets the value of the payeeLegalName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setPayeeLegalName(String value) {
        this.payeeLegalName = value;
    }

    /**
     * Gets the value of the payeePreferredName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getPayeePreferredName() {
        return payeePreferredName;
    }

    /**
     * Sets the value of the payeePreferredName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setPayeePreferredName(String value) {
        this.payeePreferredName = value;
    }

    /**
     * Gets the value of the payeeID property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getPayeeID() {
        return payeeID;
    }

    /**
     * Sets the value of the payeeID property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setPayeeID(String value) {
        this.payeeID = value;
    }

    /**
     * Gets the value of the expensePayeeEmployeeNumber property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getExpensePayeeEmployeeNumber() {
        return expensePayeeEmployeeNumber;
    }

    /**
     * Sets the value of the expensePayeeEmployeeNumber property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setExpensePayeeEmployeeNumber(String value) {
        this.expensePayeeEmployeeNumber = value;
    }

    /**
     * Gets the value of the taxID property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getTaxID() {
        return taxID;
    }

    /**
     * Sets the value of the taxID property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setTaxID(String value) {
        this.taxID = value;
    }

    /**
     * Gets the value of the corporateCreditCardAccountNumber property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getCorporateCreditCardAccountNumber() {
        return corporateCreditCardAccountNumber;
    }

    /**
     * Sets the value of the corporateCreditCardAccountNumber property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setCorporateCreditCardAccountNumber(String value) {
        this.corporateCreditCardAccountNumber = value;
    }

    /**
     * Gets the value of the marketCode property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getMarketCode() {
        return marketCode;
    }

    /**
     * Sets the value of the marketCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setMarketCode(String value) {
        this.marketCode = value;
    }

    /**
     * Gets the value of the countryReference property.
     * 
     * @return
     *     possible object is
     *     {@link CountryObjectType }
     *     
     */
    public CountryObjectType getCountryReference() {
        return countryReference;
    }

    /**
     * Sets the value of the countryReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link CountryObjectType }
     *     
     */
    public void setCountryReference(CountryObjectType value) {
        this.countryReference = value;
    }

    /**
     * Gets the value of the payeeAlternateName property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the payeeAlternateName property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getPayeeAlternateName().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link BusinessEntityAlternateNameDataType }
     * 
     * 
     */
    public List<BusinessEntityAlternateNameDataType> getPayeeAlternateName() {
        if (payeeAlternateName == null) {
            payeeAlternateName = new ArrayList<BusinessEntityAlternateNameDataType>();
        }
        return this.payeeAlternateName;
    }

    /**
     * Gets the value of the addressInformationData property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the addressInformationData property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getAddressInformationData().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AddressInformationDataType }
     * 
     * 
     */
    public List<AddressInformationDataType> getAddressInformationData() {
        if (addressInformationData == null) {
            addressInformationData = new ArrayList<AddressInformationDataType>();
        }
        return this.addressInformationData;
    }

    /**
     * Sets the value of the payeeAlternateName property.
     * 
     * @param payeeAlternateName
     *     allowed object is
     *     {@link BusinessEntityAlternateNameDataType }
     *     
     */
    public void setPayeeAlternateName(List<BusinessEntityAlternateNameDataType> payeeAlternateName) {
        this.payeeAlternateName = payeeAlternateName;
    }

    /**
     * Sets the value of the addressInformationData property.
     * 
     * @param addressInformationData
     *     allowed object is
     *     {@link AddressInformationDataType }
     *     
     */
    public void setAddressInformationData(List<AddressInformationDataType> addressInformationData) {
        this.addressInformationData = addressInformationData;
    }

}
