
package com.workday.financial;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;


/**
 * Receiving Party Bank Data
 * 
 * <p>Java class for Receiving_Party_Bank_DataType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Receiving_Party_Bank_DataType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Bank_Account_Nickname" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Account_Number" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Masked_Account_Number" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Account_Type" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Bank_Name" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="IBAN" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Bank_ID_Number" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="BIC" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Branch_Name" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Branch_ID_Number" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Country_Reference" type="{urn:com.workday/bsvc}CountryObjectType" minOccurs="0"/>
 *         &lt;element name="Currency_Reference" type="{urn:com.workday/bsvc}InstanceObjectType" minOccurs="0"/>
 *         &lt;element name="Bank_Account_Name" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Check_Digit" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Roll_Number" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Bank_Instructions" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Intermediary_Bank_Data" type="{urn:com.workday/bsvc}Intermediary_Bank_Account_WWS_DataType" maxOccurs="unbounded" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Receiving_Party_Bank_DataType", propOrder = {
    "bankAccountNickname",
    "accountNumber",
    "maskedAccountNumber",
    "accountType",
    "bankName",
    "iban",
    "bankIDNumber",
    "bic",
    "branchName",
    "branchIDNumber",
    "countryReference",
    "currencyReference",
    "bankAccountName",
    "checkDigit",
    "rollNumber",
    "bankInstructions",
    "intermediaryBankData"
})
public class ReceivingPartyBankDataType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Bank_Account_Nickname")
    protected String bankAccountNickname;
    @XmlElement(name = "Account_Number")
    protected String accountNumber;
    @XmlElement(name = "Masked_Account_Number")
    protected String maskedAccountNumber;
    @XmlElement(name = "Account_Type")
    protected String accountType;
    @XmlElement(name = "Bank_Name")
    protected String bankName;
    @XmlElement(name = "IBAN")
    protected String iban;
    @XmlElement(name = "Bank_ID_Number")
    protected String bankIDNumber;
    @XmlElement(name = "BIC")
    protected String bic;
    @XmlElement(name = "Branch_Name")
    protected String branchName;
    @XmlElement(name = "Branch_ID_Number")
    protected String branchIDNumber;
    @XmlElement(name = "Country_Reference")
    protected CountryObjectType countryReference;
    @XmlElement(name = "Currency_Reference")
    protected InstanceObjectType currencyReference;
    @XmlElement(name = "Bank_Account_Name")
    protected String bankAccountName;
    @XmlElement(name = "Check_Digit")
    protected String checkDigit;
    @XmlElement(name = "Roll_Number")
    protected String rollNumber;
    @XmlElement(name = "Bank_Instructions")
    protected String bankInstructions;
    @XmlElement(name = "Intermediary_Bank_Data")
    protected List<IntermediaryBankAccountWWSDataType> intermediaryBankData;

    /**
     * Gets the value of the bankAccountNickname property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getBankAccountNickname() {
        return bankAccountNickname;
    }

    /**
     * Sets the value of the bankAccountNickname property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setBankAccountNickname(String value) {
        this.bankAccountNickname = value;
    }

    /**
     * Gets the value of the accountNumber property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getAccountNumber() {
        return accountNumber;
    }

    /**
     * Sets the value of the accountNumber property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setAccountNumber(String value) {
        this.accountNumber = value;
    }

    /**
     * Gets the value of the maskedAccountNumber property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getMaskedAccountNumber() {
        return maskedAccountNumber;
    }

    /**
     * Sets the value of the maskedAccountNumber property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setMaskedAccountNumber(String value) {
        this.maskedAccountNumber = value;
    }

    /**
     * Gets the value of the accountType property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getAccountType() {
        return accountType;
    }

    /**
     * Sets the value of the accountType property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setAccountType(String value) {
        this.accountType = value;
    }

    /**
     * Gets the value of the bankName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getBankName() {
        return bankName;
    }

    /**
     * Sets the value of the bankName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setBankName(String value) {
        this.bankName = value;
    }

    /**
     * Gets the value of the iban property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getIBAN() {
        return iban;
    }

    /**
     * Sets the value of the iban property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setIBAN(String value) {
        this.iban = value;
    }

    /**
     * Gets the value of the bankIDNumber property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getBankIDNumber() {
        return bankIDNumber;
    }

    /**
     * Sets the value of the bankIDNumber property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setBankIDNumber(String value) {
        this.bankIDNumber = value;
    }

    /**
     * Gets the value of the bic property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getBIC() {
        return bic;
    }

    /**
     * Sets the value of the bic property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setBIC(String value) {
        this.bic = value;
    }

    /**
     * Gets the value of the branchName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getBranchName() {
        return branchName;
    }

    /**
     * Sets the value of the branchName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setBranchName(String value) {
        this.branchName = value;
    }

    /**
     * Gets the value of the branchIDNumber property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getBranchIDNumber() {
        return branchIDNumber;
    }

    /**
     * Sets the value of the branchIDNumber property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setBranchIDNumber(String value) {
        this.branchIDNumber = value;
    }

    /**
     * Gets the value of the countryReference property.
     * 
     * @return
     *     possible object is
     *     {@link CountryObjectType }
     *     
     */
    public CountryObjectType getCountryReference() {
        return countryReference;
    }

    /**
     * Sets the value of the countryReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link CountryObjectType }
     *     
     */
    public void setCountryReference(CountryObjectType value) {
        this.countryReference = value;
    }

    /**
     * Gets the value of the currencyReference property.
     * 
     * @return
     *     possible object is
     *     {@link InstanceObjectType }
     *     
     */
    public InstanceObjectType getCurrencyReference() {
        return currencyReference;
    }

    /**
     * Sets the value of the currencyReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link InstanceObjectType }
     *     
     */
    public void setCurrencyReference(InstanceObjectType value) {
        this.currencyReference = value;
    }

    /**
     * Gets the value of the bankAccountName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getBankAccountName() {
        return bankAccountName;
    }

    /**
     * Sets the value of the bankAccountName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setBankAccountName(String value) {
        this.bankAccountName = value;
    }

    /**
     * Gets the value of the checkDigit property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getCheckDigit() {
        return checkDigit;
    }

    /**
     * Sets the value of the checkDigit property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setCheckDigit(String value) {
        this.checkDigit = value;
    }

    /**
     * Gets the value of the rollNumber property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getRollNumber() {
        return rollNumber;
    }

    /**
     * Sets the value of the rollNumber property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setRollNumber(String value) {
        this.rollNumber = value;
    }

    /**
     * Gets the value of the bankInstructions property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getBankInstructions() {
        return bankInstructions;
    }

    /**
     * Sets the value of the bankInstructions property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setBankInstructions(String value) {
        this.bankInstructions = value;
    }

    /**
     * Gets the value of the intermediaryBankData property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the intermediaryBankData property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getIntermediaryBankData().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link IntermediaryBankAccountWWSDataType }
     * 
     * 
     */
    public List<IntermediaryBankAccountWWSDataType> getIntermediaryBankData() {
        if (intermediaryBankData == null) {
            intermediaryBankData = new ArrayList<IntermediaryBankAccountWWSDataType>();
        }
        return this.intermediaryBankData;
    }

    /**
     * Sets the value of the intermediaryBankData property.
     * 
     * @param intermediaryBankData
     *     allowed object is
     *     {@link IntermediaryBankAccountWWSDataType }
     *     
     */
    public void setIntermediaryBankData(List<IntermediaryBankAccountWWSDataType> intermediaryBankData) {
        this.intermediaryBankData = intermediaryBankData;
    }

}
