
package com.workday.financial;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;


/**
 * Element containing Program Hierarchy reference for update and all Program Hierarchy data items
 * 
 * <p>Java class for Put_Program_Hierarchy_RequestType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Put_Program_Hierarchy_RequestType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Program_Hierarchy_Reference" type="{urn:com.workday/bsvc}Program_HierarchyObjectType" minOccurs="0"/>
 *         &lt;element name="Program_Hierarchy_Data" type="{urn:com.workday/bsvc}Program_Hierarchy_DataType" maxOccurs="unbounded" minOccurs="0"/>
 *       &lt;/sequence>
 *       &lt;attribute name="Add_Only" type="{http://www.w3.org/2001/XMLSchema}boolean" />
 *       &lt;attribute ref="{urn:com.workday/bsvc}version"/>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Put_Program_Hierarchy_RequestType", propOrder = {
    "programHierarchyReference",
    "programHierarchyData"
})
public class PutProgramHierarchyRequestType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Program_Hierarchy_Reference")
    protected ProgramHierarchyObjectType programHierarchyReference;
    @XmlElement(name = "Program_Hierarchy_Data")
    protected List<ProgramHierarchyDataType> programHierarchyData;
    @XmlAttribute(name = "Add_Only", namespace = "urn:com.workday/bsvc")
    protected Boolean addOnly;
    @XmlAttribute(name = "version", namespace = "urn:com.workday/bsvc")
    protected String version;

    /**
     * Gets the value of the programHierarchyReference property.
     * 
     * @return
     *     possible object is
     *     {@link ProgramHierarchyObjectType }
     *     
     */
    public ProgramHierarchyObjectType getProgramHierarchyReference() {
        return programHierarchyReference;
    }

    /**
     * Sets the value of the programHierarchyReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link ProgramHierarchyObjectType }
     *     
     */
    public void setProgramHierarchyReference(ProgramHierarchyObjectType value) {
        this.programHierarchyReference = value;
    }

    /**
     * Gets the value of the programHierarchyData property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the programHierarchyData property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getProgramHierarchyData().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ProgramHierarchyDataType }
     * 
     * 
     */
    public List<ProgramHierarchyDataType> getProgramHierarchyData() {
        if (programHierarchyData == null) {
            programHierarchyData = new ArrayList<ProgramHierarchyDataType>();
        }
        return this.programHierarchyData;
    }

    /**
     * Gets the value of the addOnly property.
     * This getter has been renamed from isAddOnly() to getAddOnly() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getAddOnly() {
        return addOnly;
    }

    /**
     * Sets the value of the addOnly property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setAddOnly(Boolean value) {
        this.addOnly = value;
    }

    /**
     * Gets the value of the version property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getVersion() {
        return version;
    }

    /**
     * Sets the value of the version property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setVersion(String value) {
        this.version = value;
    }

    /**
     * Sets the value of the programHierarchyData property.
     * 
     * @param programHierarchyData
     *     allowed object is
     *     {@link ProgramHierarchyDataType }
     *     
     */
    public void setProgramHierarchyData(List<ProgramHierarchyDataType> programHierarchyData) {
        this.programHierarchyData = programHierarchyData;
    }

}
