
package com.workday.financial;

import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;


/**
 * Contains data for creating or updating Business Plan Details, also called the Business Plan Entry, data.   A unique instance of the Business Plan Details is identified by the Reference ID or the Business Plan Period.  A Business Plan period is identified by the Business Plan (Business Plan type and the Company) and the Fiscal Period (Fiscal Year and Company's Fiscal Schedule and Fiscal Posting Interval ie: 2009-Jan).
 * 
 * <p>Java class for Put_Business_Plan_Details_RequestType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Put_Business_Plan_Details_RequestType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Business_Plan_Details_Reference" type="{urn:com.workday/bsvc}Unique_IdentifierObjectType" minOccurs="0"/>
 *         &lt;element name="Business_Plan_Details_Data" type="{urn:com.workday/bsvc}Business_Plan_Details_DataType" minOccurs="0"/>
 *       &lt;/sequence>
 *       &lt;attribute name="Add_Only" type="{http://www.w3.org/2001/XMLSchema}boolean" />
 *       &lt;attribute ref="{urn:com.workday/bsvc}version"/>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Put_Business_Plan_Details_RequestType", propOrder = {
    "businessPlanDetailsReference",
    "businessPlanDetailsData"
})
public class PutBusinessPlanDetailsRequestType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Business_Plan_Details_Reference")
    protected UniqueIdentifierObjectType businessPlanDetailsReference;
    @XmlElement(name = "Business_Plan_Details_Data")
    protected BusinessPlanDetailsDataType businessPlanDetailsData;
    @XmlAttribute(name = "Add_Only", namespace = "urn:com.workday/bsvc")
    protected Boolean addOnly;
    @XmlAttribute(name = "version", namespace = "urn:com.workday/bsvc")
    protected String version;

    /**
     * Gets the value of the businessPlanDetailsReference property.
     * 
     * @return
     *     possible object is
     *     {@link UniqueIdentifierObjectType }
     *     
     */
    public UniqueIdentifierObjectType getBusinessPlanDetailsReference() {
        return businessPlanDetailsReference;
    }

    /**
     * Sets the value of the businessPlanDetailsReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link UniqueIdentifierObjectType }
     *     
     */
    public void setBusinessPlanDetailsReference(UniqueIdentifierObjectType value) {
        this.businessPlanDetailsReference = value;
    }

    /**
     * Gets the value of the businessPlanDetailsData property.
     * 
     * @return
     *     possible object is
     *     {@link BusinessPlanDetailsDataType }
     *     
     */
    public BusinessPlanDetailsDataType getBusinessPlanDetailsData() {
        return businessPlanDetailsData;
    }

    /**
     * Sets the value of the businessPlanDetailsData property.
     * 
     * @param value
     *     allowed object is
     *     {@link BusinessPlanDetailsDataType }
     *     
     */
    public void setBusinessPlanDetailsData(BusinessPlanDetailsDataType value) {
        this.businessPlanDetailsData = value;
    }

    /**
     * Gets the value of the addOnly property.
     * This getter has been renamed from isAddOnly() to getAddOnly() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getAddOnly() {
        return addOnly;
    }

    /**
     * Sets the value of the addOnly property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setAddOnly(Boolean value) {
        this.addOnly = value;
    }

    /**
     * Gets the value of the version property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getVersion() {
        return version;
    }

    /**
     * Sets the value of the version property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setVersion(String value) {
        this.version = value;
    }

}
