
package com.workday.financial;

import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;


/**
 * Contains data updating Budget data.   A unique instance of the Budget is identified by the Reference ID or the Budget Period.  A Budget period is identified by the Budget (Budget type and the Company) and the Fiscal Period (Fiscal Year and Company's Fiscal Schedule and Fiscal Posting Interval ie: 2009-Jan).
 * 
 * <p>Java class for Put_Budget_Incremental_RequestType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Put_Budget_Incremental_RequestType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Budget_Reference" type="{urn:com.workday/bsvc}Unique_IdentifierObjectType" minOccurs="0"/>
 *         &lt;element name="Budget_Data" type="{urn:com.workday/bsvc}Budget_Incremental_DataType" minOccurs="0"/>
 *       &lt;/sequence>
 *       &lt;attribute name="Add_Only" type="{http://www.w3.org/2001/XMLSchema}boolean" />
 *       &lt;attribute ref="{urn:com.workday/bsvc}version"/>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Put_Budget_Incremental_RequestType", propOrder = {
    "budgetReference",
    "budgetData"
})
public class PutBudgetIncrementalRequestType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Budget_Reference")
    protected UniqueIdentifierObjectType budgetReference;
    @XmlElement(name = "Budget_Data")
    protected BudgetIncrementalDataType budgetData;
    @XmlAttribute(name = "Add_Only", namespace = "urn:com.workday/bsvc")
    protected Boolean addOnly;
    @XmlAttribute(name = "version", namespace = "urn:com.workday/bsvc")
    protected String version;

    /**
     * Gets the value of the budgetReference property.
     * 
     * @return
     *     possible object is
     *     {@link UniqueIdentifierObjectType }
     *     
     */
    public UniqueIdentifierObjectType getBudgetReference() {
        return budgetReference;
    }

    /**
     * Sets the value of the budgetReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link UniqueIdentifierObjectType }
     *     
     */
    public void setBudgetReference(UniqueIdentifierObjectType value) {
        this.budgetReference = value;
    }

    /**
     * Gets the value of the budgetData property.
     * 
     * @return
     *     possible object is
     *     {@link BudgetIncrementalDataType }
     *     
     */
    public BudgetIncrementalDataType getBudgetData() {
        return budgetData;
    }

    /**
     * Sets the value of the budgetData property.
     * 
     * @param value
     *     allowed object is
     *     {@link BudgetIncrementalDataType }
     *     
     */
    public void setBudgetData(BudgetIncrementalDataType value) {
        this.budgetData = value;
    }

    /**
     * Gets the value of the addOnly property.
     * This getter has been renamed from isAddOnly() to getAddOnly() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getAddOnly() {
        return addOnly;
    }

    /**
     * Sets the value of the addOnly property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setAddOnly(Boolean value) {
        this.addOnly = value;
    }

    /**
     * Gets the value of the version property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getVersion() {
        return version;
    }

    /**
     * Sets the value of the version property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setVersion(String value) {
        this.version = value;
    }

}
