
package com.workday.financial;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;


/**
 * Wrapper Element that includes Program Instance and Data
 * 
 * <p>Java class for ProgramType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="ProgramType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Program_Reference" type="{urn:com.workday/bsvc}ProgramObjectType" minOccurs="0"/>
 *         &lt;element name="Program_Data" type="{urn:com.workday/bsvc}Program_DataType" maxOccurs="unbounded" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "ProgramType", propOrder = {
    "programReference",
    "programData"
})
public class ProgramType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Program_Reference")
    protected ProgramObjectType programReference;
    @XmlElement(name = "Program_Data")
    protected List<ProgramDataType> programData;

    /**
     * Gets the value of the programReference property.
     * 
     * @return
     *     possible object is
     *     {@link ProgramObjectType }
     *     
     */
    public ProgramObjectType getProgramReference() {
        return programReference;
    }

    /**
     * Sets the value of the programReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link ProgramObjectType }
     *     
     */
    public void setProgramReference(ProgramObjectType value) {
        this.programReference = value;
    }

    /**
     * Gets the value of the programData property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the programData property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getProgramData().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ProgramDataType }
     * 
     * 
     */
    public List<ProgramDataType> getProgramData() {
        if (programData == null) {
            programData = new ArrayList<ProgramDataType>();
        }
        return this.programData;
    }

    /**
     * Sets the value of the programData property.
     * 
     * @param programData
     *     allowed object is
     *     {@link ProgramDataType }
     *     
     */
    public void setProgramData(List<ProgramDataType> programData) {
        this.programData = programData;
    }

}
