
package com.workday.financial;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;


/**
 * Element containing all Program Hierarchy data
 * 
 * <p>Java class for Program_Hierarchy_DataType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Program_Hierarchy_DataType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Program_Hierarchy_ID" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Program_Hierarchy_Name" type="{http://www.w3.org/2001/XMLSchema}string"/>
 *         &lt;element name="Include_Program_Hierarchy_ID_In_Name" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Program_Hierarchy_is_Inactive" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Organization_Subtype_Reference" type="{urn:com.workday/bsvc}Organization_SubtypeObjectType" minOccurs="0"/>
 *         &lt;element name="Parent_Program_Hierarchy_Reference" type="{urn:com.workday/bsvc}Program_HierarchyObjectType" minOccurs="0"/>
 *         &lt;element name="Contains_Program_Reference" type="{urn:com.workday/bsvc}ProgramObjectType" maxOccurs="unbounded" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Program_Hierarchy_DataType", propOrder = {
    "programHierarchyID",
    "programHierarchyName",
    "includeProgramHierarchyIDInName",
    "programHierarchyIsInactive",
    "organizationSubtypeReference",
    "parentProgramHierarchyReference",
    "containsProgramReference"
})
public class ProgramHierarchyDataType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Program_Hierarchy_ID")
    protected String programHierarchyID;
    @XmlElement(name = "Program_Hierarchy_Name", required = true)
    protected String programHierarchyName;
    @XmlElement(name = "Include_Program_Hierarchy_ID_In_Name")
    protected Boolean includeProgramHierarchyIDInName;
    @XmlElement(name = "Program_Hierarchy_is_Inactive")
    protected Boolean programHierarchyIsInactive;
    @XmlElement(name = "Organization_Subtype_Reference")
    protected OrganizationSubtypeObjectType organizationSubtypeReference;
    @XmlElement(name = "Parent_Program_Hierarchy_Reference")
    protected ProgramHierarchyObjectType parentProgramHierarchyReference;
    @XmlElement(name = "Contains_Program_Reference")
    protected List<ProgramObjectType> containsProgramReference;

    /**
     * Gets the value of the programHierarchyID property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getProgramHierarchyID() {
        return programHierarchyID;
    }

    /**
     * Sets the value of the programHierarchyID property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setProgramHierarchyID(String value) {
        this.programHierarchyID = value;
    }

    /**
     * Gets the value of the programHierarchyName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getProgramHierarchyName() {
        return programHierarchyName;
    }

    /**
     * Sets the value of the programHierarchyName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setProgramHierarchyName(String value) {
        this.programHierarchyName = value;
    }

    /**
     * Gets the value of the includeProgramHierarchyIDInName property.
     * This getter has been renamed from isIncludeProgramHierarchyIDInName() to getIncludeProgramHierarchyIDInName() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getIncludeProgramHierarchyIDInName() {
        return includeProgramHierarchyIDInName;
    }

    /**
     * Sets the value of the includeProgramHierarchyIDInName property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setIncludeProgramHierarchyIDInName(Boolean value) {
        this.includeProgramHierarchyIDInName = value;
    }

    /**
     * Gets the value of the programHierarchyIsInactive property.
     * This getter has been renamed from isProgramHierarchyIsInactive() to getProgramHierarchyIsInactive() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getProgramHierarchyIsInactive() {
        return programHierarchyIsInactive;
    }

    /**
     * Sets the value of the programHierarchyIsInactive property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setProgramHierarchyIsInactive(Boolean value) {
        this.programHierarchyIsInactive = value;
    }

    /**
     * Gets the value of the organizationSubtypeReference property.
     * 
     * @return
     *     possible object is
     *     {@link OrganizationSubtypeObjectType }
     *     
     */
    public OrganizationSubtypeObjectType getOrganizationSubtypeReference() {
        return organizationSubtypeReference;
    }

    /**
     * Sets the value of the organizationSubtypeReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link OrganizationSubtypeObjectType }
     *     
     */
    public void setOrganizationSubtypeReference(OrganizationSubtypeObjectType value) {
        this.organizationSubtypeReference = value;
    }

    /**
     * Gets the value of the parentProgramHierarchyReference property.
     * 
     * @return
     *     possible object is
     *     {@link ProgramHierarchyObjectType }
     *     
     */
    public ProgramHierarchyObjectType getParentProgramHierarchyReference() {
        return parentProgramHierarchyReference;
    }

    /**
     * Sets the value of the parentProgramHierarchyReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link ProgramHierarchyObjectType }
     *     
     */
    public void setParentProgramHierarchyReference(ProgramHierarchyObjectType value) {
        this.parentProgramHierarchyReference = value;
    }

    /**
     * Gets the value of the containsProgramReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the containsProgramReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getContainsProgramReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ProgramObjectType }
     * 
     * 
     */
    public List<ProgramObjectType> getContainsProgramReference() {
        if (containsProgramReference == null) {
            containsProgramReference = new ArrayList<ProgramObjectType>();
        }
        return this.containsProgramReference;
    }

    /**
     * Sets the value of the containsProgramReference property.
     * 
     * @param containsProgramReference
     *     allowed object is
     *     {@link ProgramObjectType }
     *     
     */
    public void setContainsProgramReference(List<ProgramObjectType> containsProgramReference) {
        this.containsProgramReference = containsProgramReference;
    }

}
