
package com.workday.financial;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;


/**
 * Element containing all Program Data.
 * 
 * <p>Java class for Program_DataType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Program_DataType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Program_ID" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Program_Name" type="{http://www.w3.org/2001/XMLSchema}string"/>
 *         &lt;element name="Include_Program_ID_in_Name" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Program_is_Inactive" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Related_Worktags_for_Program_Data" type="{urn:com.workday/bsvc}Related_Worktags_for_Webservices_EditType" maxOccurs="unbounded" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Program_DataType", propOrder = {
    "programID",
    "programName",
    "includeProgramIDInName",
    "programIsInactive",
    "relatedWorktagsForProgramData"
})
public class ProgramDataType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Program_ID")
    protected String programID;
    @XmlElement(name = "Program_Name", required = true)
    protected String programName;
    @XmlElement(name = "Include_Program_ID_in_Name")
    protected Boolean includeProgramIDInName;
    @XmlElement(name = "Program_is_Inactive")
    protected Boolean programIsInactive;
    @XmlElement(name = "Related_Worktags_for_Program_Data")
    protected List<RelatedWorktagsForWebservicesEditType> relatedWorktagsForProgramData;

    /**
     * Gets the value of the programID property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getProgramID() {
        return programID;
    }

    /**
     * Sets the value of the programID property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setProgramID(String value) {
        this.programID = value;
    }

    /**
     * Gets the value of the programName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getProgramName() {
        return programName;
    }

    /**
     * Sets the value of the programName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setProgramName(String value) {
        this.programName = value;
    }

    /**
     * Gets the value of the includeProgramIDInName property.
     * This getter has been renamed from isIncludeProgramIDInName() to getIncludeProgramIDInName() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getIncludeProgramIDInName() {
        return includeProgramIDInName;
    }

    /**
     * Sets the value of the includeProgramIDInName property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setIncludeProgramIDInName(Boolean value) {
        this.includeProgramIDInName = value;
    }

    /**
     * Gets the value of the programIsInactive property.
     * This getter has been renamed from isProgramIsInactive() to getProgramIsInactive() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getProgramIsInactive() {
        return programIsInactive;
    }

    /**
     * Sets the value of the programIsInactive property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setProgramIsInactive(Boolean value) {
        this.programIsInactive = value;
    }

    /**
     * Gets the value of the relatedWorktagsForProgramData property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the relatedWorktagsForProgramData property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getRelatedWorktagsForProgramData().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link RelatedWorktagsForWebservicesEditType }
     * 
     * 
     */
    public List<RelatedWorktagsForWebservicesEditType> getRelatedWorktagsForProgramData() {
        if (relatedWorktagsForProgramData == null) {
            relatedWorktagsForProgramData = new ArrayList<RelatedWorktagsForWebservicesEditType>();
        }
        return this.relatedWorktagsForProgramData;
    }

    /**
     * Sets the value of the relatedWorktagsForProgramData property.
     * 
     * @param relatedWorktagsForProgramData
     *     allowed object is
     *     {@link RelatedWorktagsForWebservicesEditType }
     *     
     */
    public void setRelatedWorktagsForProgramData(List<RelatedWorktagsForWebservicesEditType> relatedWorktagsForProgramData) {
        this.relatedWorktagsForProgramData = relatedWorktagsForProgramData;
    }

}
