
package com.workday.financial;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;


/**
 * Get Position Budget Request Criteria.
 * 
 * <p>Java class for Position_Budget_Request_CriteriaType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Position_Budget_Request_CriteriaType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Company_Reference" type="{urn:com.workday/bsvc}CompanyObjectType"/>
 *         &lt;element name="Business_Plan_Structure_Reference" type="{urn:com.workday/bsvc}Budget_StructureObjectType"/>
 *         &lt;element name="Fiscal_Year_Reference" type="{urn:com.workday/bsvc}Fiscal_YearObjectType"/>
 *         &lt;element name="Position_Reference" type="{urn:com.workday/bsvc}Position_RestrictionsObjectType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Employee_Reference" type="{urn:com.workday/bsvc}WorkerObjectType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Version_Status_Reference" type="{urn:com.workday/bsvc}Document_StatusObjectType" maxOccurs="unbounded" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Position_Budget_Request_CriteriaType", propOrder = {
    "companyReference",
    "businessPlanStructureReference",
    "fiscalYearReference",
    "positionReference",
    "employeeReference",
    "versionStatusReference"
})
public class PositionBudgetRequestCriteriaType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Company_Reference", required = true)
    protected CompanyObjectType companyReference;
    @XmlElement(name = "Business_Plan_Structure_Reference", required = true)
    protected BudgetStructureObjectType businessPlanStructureReference;
    @XmlElement(name = "Fiscal_Year_Reference", required = true)
    protected FiscalYearObjectType fiscalYearReference;
    @XmlElement(name = "Position_Reference")
    protected List<PositionRestrictionsObjectType> positionReference;
    @XmlElement(name = "Employee_Reference")
    protected List<WorkerObjectType> employeeReference;
    @XmlElement(name = "Version_Status_Reference")
    protected List<DocumentStatusObjectType> versionStatusReference;

    /**
     * Gets the value of the companyReference property.
     * 
     * @return
     *     possible object is
     *     {@link CompanyObjectType }
     *     
     */
    public CompanyObjectType getCompanyReference() {
        return companyReference;
    }

    /**
     * Sets the value of the companyReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link CompanyObjectType }
     *     
     */
    public void setCompanyReference(CompanyObjectType value) {
        this.companyReference = value;
    }

    /**
     * Gets the value of the businessPlanStructureReference property.
     * 
     * @return
     *     possible object is
     *     {@link BudgetStructureObjectType }
     *     
     */
    public BudgetStructureObjectType getBusinessPlanStructureReference() {
        return businessPlanStructureReference;
    }

    /**
     * Sets the value of the businessPlanStructureReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link BudgetStructureObjectType }
     *     
     */
    public void setBusinessPlanStructureReference(BudgetStructureObjectType value) {
        this.businessPlanStructureReference = value;
    }

    /**
     * Gets the value of the fiscalYearReference property.
     * 
     * @return
     *     possible object is
     *     {@link FiscalYearObjectType }
     *     
     */
    public FiscalYearObjectType getFiscalYearReference() {
        return fiscalYearReference;
    }

    /**
     * Sets the value of the fiscalYearReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link FiscalYearObjectType }
     *     
     */
    public void setFiscalYearReference(FiscalYearObjectType value) {
        this.fiscalYearReference = value;
    }

    /**
     * Gets the value of the positionReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the positionReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getPositionReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link PositionRestrictionsObjectType }
     * 
     * 
     */
    public List<PositionRestrictionsObjectType> getPositionReference() {
        if (positionReference == null) {
            positionReference = new ArrayList<PositionRestrictionsObjectType>();
        }
        return this.positionReference;
    }

    /**
     * Gets the value of the employeeReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the employeeReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getEmployeeReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link WorkerObjectType }
     * 
     * 
     */
    public List<WorkerObjectType> getEmployeeReference() {
        if (employeeReference == null) {
            employeeReference = new ArrayList<WorkerObjectType>();
        }
        return this.employeeReference;
    }

    /**
     * Gets the value of the versionStatusReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the versionStatusReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getVersionStatusReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link DocumentStatusObjectType }
     * 
     * 
     */
    public List<DocumentStatusObjectType> getVersionStatusReference() {
        if (versionStatusReference == null) {
            versionStatusReference = new ArrayList<DocumentStatusObjectType>();
        }
        return this.versionStatusReference;
    }

    /**
     * Sets the value of the positionReference property.
     * 
     * @param positionReference
     *     allowed object is
     *     {@link PositionRestrictionsObjectType }
     *     
     */
    public void setPositionReference(List<PositionRestrictionsObjectType> positionReference) {
        this.positionReference = positionReference;
    }

    /**
     * Sets the value of the employeeReference property.
     * 
     * @param employeeReference
     *     allowed object is
     *     {@link WorkerObjectType }
     *     
     */
    public void setEmployeeReference(List<WorkerObjectType> employeeReference) {
        this.employeeReference = employeeReference;
    }

    /**
     * Sets the value of the versionStatusReference property.
     * 
     * @param versionStatusReference
     *     allowed object is
     *     {@link DocumentStatusObjectType }
     *     
     */
    public void setVersionStatusReference(List<DocumentStatusObjectType> versionStatusReference) {
        this.versionStatusReference = versionStatusReference;
    }

}
