
package com.workday.financial;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;


/**
 * Contains data for a Position Budget Line.  A Position Budget may have multiple Position Budget Lines.
 * 
 * <p>Java class for Position_Budget_Line_Replacement_DataType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Position_Budget_Line_Replacement_DataType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Line_Order" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Budget_Line_Type_Reference" type="{urn:com.workday/bsvc}Budget_Line_TypeObjectType"/>
 *         &lt;element name="Ledger_Account_Reference" type="{urn:com.workday/bsvc}Ledger_AccountObjectType"/>
 *         &lt;element name="Amount" minOccurs="0">
 *           &lt;simpleType>
 *             &lt;restriction base="{http://www.w3.org/2001/XMLSchema}decimal">
 *               &lt;totalDigits value="18"/>
 *               &lt;fractionDigits value="3"/>
 *             &lt;/restriction>
 *           &lt;/simpleType>
 *         &lt;/element>
 *         &lt;element name="Accounting_Worktag_Reference" type="{urn:com.workday/bsvc}Accounting_WorktagObjectType" maxOccurs="unbounded" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Position_Budget_Line_Replacement_DataType", propOrder = {
    "lineOrder",
    "budgetLineTypeReference",
    "ledgerAccountReference",
    "amount",
    "accountingWorktagReference"
})
public class PositionBudgetLineReplacementDataType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Line_Order")
    protected String lineOrder;
    @XmlElement(name = "Budget_Line_Type_Reference", required = true)
    protected BudgetLineTypeObjectType budgetLineTypeReference;
    @XmlElement(name = "Ledger_Account_Reference", required = true)
    protected LedgerAccountObjectType ledgerAccountReference;
    @XmlElement(name = "Amount")
    protected BigDecimal amount;
    @XmlElement(name = "Accounting_Worktag_Reference")
    protected List<AccountingWorktagObjectType> accountingWorktagReference;

    /**
     * Gets the value of the lineOrder property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getLineOrder() {
        return lineOrder;
    }

    /**
     * Sets the value of the lineOrder property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setLineOrder(String value) {
        this.lineOrder = value;
    }

    /**
     * Gets the value of the budgetLineTypeReference property.
     * 
     * @return
     *     possible object is
     *     {@link BudgetLineTypeObjectType }
     *     
     */
    public BudgetLineTypeObjectType getBudgetLineTypeReference() {
        return budgetLineTypeReference;
    }

    /**
     * Sets the value of the budgetLineTypeReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link BudgetLineTypeObjectType }
     *     
     */
    public void setBudgetLineTypeReference(BudgetLineTypeObjectType value) {
        this.budgetLineTypeReference = value;
    }

    /**
     * Gets the value of the ledgerAccountReference property.
     * 
     * @return
     *     possible object is
     *     {@link LedgerAccountObjectType }
     *     
     */
    public LedgerAccountObjectType getLedgerAccountReference() {
        return ledgerAccountReference;
    }

    /**
     * Sets the value of the ledgerAccountReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link LedgerAccountObjectType }
     *     
     */
    public void setLedgerAccountReference(LedgerAccountObjectType value) {
        this.ledgerAccountReference = value;
    }

    /**
     * Gets the value of the amount property.
     * 
     * @return
     *     possible object is
     *     {@link BigDecimal }
     *     
     */
    public BigDecimal getAmount() {
        return amount;
    }

    /**
     * Sets the value of the amount property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigDecimal }
     *     
     */
    public void setAmount(BigDecimal value) {
        this.amount = value;
    }

    /**
     * Gets the value of the accountingWorktagReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the accountingWorktagReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getAccountingWorktagReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AccountingWorktagObjectType }
     * 
     * 
     */
    public List<AccountingWorktagObjectType> getAccountingWorktagReference() {
        if (accountingWorktagReference == null) {
            accountingWorktagReference = new ArrayList<AccountingWorktagObjectType>();
        }
        return this.accountingWorktagReference;
    }

    /**
     * Sets the value of the accountingWorktagReference property.
     * 
     * @param accountingWorktagReference
     *     allowed object is
     *     {@link AccountingWorktagObjectType }
     *     
     */
    public void setAccountingWorktagReference(List<AccountingWorktagObjectType> accountingWorktagReference) {
        this.accountingWorktagReference = accountingWorktagReference;
    }

}
