
package com.workday.financial;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;


/**
 * Element containing Position Budget data.
 * 
 * <p>Java class for Position_Budget_DataType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Position_Budget_DataType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Locked_in_Workday_Reference" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Company_Reference" type="{urn:com.workday/bsvc}CompanyObjectType"/>
 *         &lt;element name="Business_Plan_Structure_Reference" type="{urn:com.workday/bsvc}Budget_StructureObjectType"/>
 *         &lt;element name="Currency_Reference" type="{urn:com.workday/bsvc}CurrencyObjectType" minOccurs="0"/>
 *         &lt;element name="Fiscal_Year_Number">
 *           &lt;simpleType>
 *             &lt;restriction base="{http://www.w3.org/2001/XMLSchema}decimal">
 *               &lt;totalDigits value="4"/>
 *               &lt;minInclusive value="0"/>
 *               &lt;fractionDigits value="0"/>
 *             &lt;/restriction>
 *           &lt;/simpleType>
 *         &lt;/element>
 *         &lt;element name="Fiscal_Time_Interval_Reference" type="{urn:com.workday/bsvc}Fiscal_Time_IntervalObjectType"/>
 *         &lt;element name="Position_Reference" type="{urn:com.workday/bsvc}Position_RestrictionsObjectType"/>
 *         &lt;element name="Position_Budget_Group_Load_Reference" type="{urn:com.workday/bsvc}Position_Budget_Group_EventObjectType" minOccurs="0"/>
 *         &lt;element name="Compensation_Budget" minOccurs="0">
 *           &lt;simpleType>
 *             &lt;restriction base="{http://www.w3.org/2001/XMLSchema}decimal">
 *               &lt;totalDigits value="26"/>
 *               &lt;fractionDigits value="6"/>
 *             &lt;/restriction>
 *           &lt;/simpleType>
 *         &lt;/element>
 *         &lt;element name="Fringe_Benefit_Budget" minOccurs="0">
 *           &lt;simpleType>
 *             &lt;restriction base="{http://www.w3.org/2001/XMLSchema}decimal">
 *               &lt;totalDigits value="26"/>
 *               &lt;fractionDigits value="6"/>
 *             &lt;/restriction>
 *           &lt;/simpleType>
 *         &lt;/element>
 *         &lt;element name="Business_Plan_Amendment_Type_Reference" type="{urn:com.workday/bsvc}Budget_Amendment_TypeObjectType" minOccurs="0"/>
 *         &lt;element name="Memo" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Position_Budget_Line_Replacement_Data" type="{urn:com.workday/bsvc}Position_Budget_Line_Replacement_DataType" maxOccurs="unbounded"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Position_Budget_DataType", propOrder = {
    "lockedInWorkdayReference",
    "companyReference",
    "businessPlanStructureReference",
    "currencyReference",
    "fiscalYearNumber",
    "fiscalTimeIntervalReference",
    "positionReference",
    "positionBudgetGroupLoadReference",
    "compensationBudget",
    "fringeBenefitBudget",
    "businessPlanAmendmentTypeReference",
    "memo",
    "positionBudgetLineReplacementData"
})
public class PositionBudgetDataType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Locked_in_Workday_Reference")
    protected Boolean lockedInWorkdayReference;
    @XmlElement(name = "Company_Reference", required = true)
    protected CompanyObjectType companyReference;
    @XmlElement(name = "Business_Plan_Structure_Reference", required = true)
    protected BudgetStructureObjectType businessPlanStructureReference;
    @XmlElement(name = "Currency_Reference")
    protected CurrencyObjectType currencyReference;
    @XmlElement(name = "Fiscal_Year_Number", required = true)
    protected BigDecimal fiscalYearNumber;
    @XmlElement(name = "Fiscal_Time_Interval_Reference", required = true)
    protected FiscalTimeIntervalObjectType fiscalTimeIntervalReference;
    @XmlElement(name = "Position_Reference", required = true)
    protected PositionRestrictionsObjectType positionReference;
    @XmlElement(name = "Position_Budget_Group_Load_Reference")
    protected PositionBudgetGroupEventObjectType positionBudgetGroupLoadReference;
    @XmlElement(name = "Compensation_Budget")
    protected BigDecimal compensationBudget;
    @XmlElement(name = "Fringe_Benefit_Budget")
    protected BigDecimal fringeBenefitBudget;
    @XmlElement(name = "Business_Plan_Amendment_Type_Reference")
    protected BudgetAmendmentTypeObjectType businessPlanAmendmentTypeReference;
    @XmlElement(name = "Memo")
    protected String memo;
    @XmlElement(name = "Position_Budget_Line_Replacement_Data", required = true)
    protected List<PositionBudgetLineReplacementDataType> positionBudgetLineReplacementData;

    /**
     * Gets the value of the lockedInWorkdayReference property.
     * This getter has been renamed from isLockedInWorkdayReference() to getLockedInWorkdayReference() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getLockedInWorkdayReference() {
        return lockedInWorkdayReference;
    }

    /**
     * Sets the value of the lockedInWorkdayReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setLockedInWorkdayReference(Boolean value) {
        this.lockedInWorkdayReference = value;
    }

    /**
     * Gets the value of the companyReference property.
     * 
     * @return
     *     possible object is
     *     {@link CompanyObjectType }
     *     
     */
    public CompanyObjectType getCompanyReference() {
        return companyReference;
    }

    /**
     * Sets the value of the companyReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link CompanyObjectType }
     *     
     */
    public void setCompanyReference(CompanyObjectType value) {
        this.companyReference = value;
    }

    /**
     * Gets the value of the businessPlanStructureReference property.
     * 
     * @return
     *     possible object is
     *     {@link BudgetStructureObjectType }
     *     
     */
    public BudgetStructureObjectType getBusinessPlanStructureReference() {
        return businessPlanStructureReference;
    }

    /**
     * Sets the value of the businessPlanStructureReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link BudgetStructureObjectType }
     *     
     */
    public void setBusinessPlanStructureReference(BudgetStructureObjectType value) {
        this.businessPlanStructureReference = value;
    }

    /**
     * Gets the value of the currencyReference property.
     * 
     * @return
     *     possible object is
     *     {@link CurrencyObjectType }
     *     
     */
    public CurrencyObjectType getCurrencyReference() {
        return currencyReference;
    }

    /**
     * Sets the value of the currencyReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link CurrencyObjectType }
     *     
     */
    public void setCurrencyReference(CurrencyObjectType value) {
        this.currencyReference = value;
    }

    /**
     * Gets the value of the fiscalYearNumber property.
     * 
     * @return
     *     possible object is
     *     {@link BigDecimal }
     *     
     */
    public BigDecimal getFiscalYearNumber() {
        return fiscalYearNumber;
    }

    /**
     * Sets the value of the fiscalYearNumber property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigDecimal }
     *     
     */
    public void setFiscalYearNumber(BigDecimal value) {
        this.fiscalYearNumber = value;
    }

    /**
     * Gets the value of the fiscalTimeIntervalReference property.
     * 
     * @return
     *     possible object is
     *     {@link FiscalTimeIntervalObjectType }
     *     
     */
    public FiscalTimeIntervalObjectType getFiscalTimeIntervalReference() {
        return fiscalTimeIntervalReference;
    }

    /**
     * Sets the value of the fiscalTimeIntervalReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link FiscalTimeIntervalObjectType }
     *     
     */
    public void setFiscalTimeIntervalReference(FiscalTimeIntervalObjectType value) {
        this.fiscalTimeIntervalReference = value;
    }

    /**
     * Gets the value of the positionReference property.
     * 
     * @return
     *     possible object is
     *     {@link PositionRestrictionsObjectType }
     *     
     */
    public PositionRestrictionsObjectType getPositionReference() {
        return positionReference;
    }

    /**
     * Sets the value of the positionReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link PositionRestrictionsObjectType }
     *     
     */
    public void setPositionReference(PositionRestrictionsObjectType value) {
        this.positionReference = value;
    }

    /**
     * Gets the value of the positionBudgetGroupLoadReference property.
     * 
     * @return
     *     possible object is
     *     {@link PositionBudgetGroupEventObjectType }
     *     
     */
    public PositionBudgetGroupEventObjectType getPositionBudgetGroupLoadReference() {
        return positionBudgetGroupLoadReference;
    }

    /**
     * Sets the value of the positionBudgetGroupLoadReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link PositionBudgetGroupEventObjectType }
     *     
     */
    public void setPositionBudgetGroupLoadReference(PositionBudgetGroupEventObjectType value) {
        this.positionBudgetGroupLoadReference = value;
    }

    /**
     * Gets the value of the compensationBudget property.
     * 
     * @return
     *     possible object is
     *     {@link BigDecimal }
     *     
     */
    public BigDecimal getCompensationBudget() {
        return compensationBudget;
    }

    /**
     * Sets the value of the compensationBudget property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigDecimal }
     *     
     */
    public void setCompensationBudget(BigDecimal value) {
        this.compensationBudget = value;
    }

    /**
     * Gets the value of the fringeBenefitBudget property.
     * 
     * @return
     *     possible object is
     *     {@link BigDecimal }
     *     
     */
    public BigDecimal getFringeBenefitBudget() {
        return fringeBenefitBudget;
    }

    /**
     * Sets the value of the fringeBenefitBudget property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigDecimal }
     *     
     */
    public void setFringeBenefitBudget(BigDecimal value) {
        this.fringeBenefitBudget = value;
    }

    /**
     * Gets the value of the businessPlanAmendmentTypeReference property.
     * 
     * @return
     *     possible object is
     *     {@link BudgetAmendmentTypeObjectType }
     *     
     */
    public BudgetAmendmentTypeObjectType getBusinessPlanAmendmentTypeReference() {
        return businessPlanAmendmentTypeReference;
    }

    /**
     * Sets the value of the businessPlanAmendmentTypeReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link BudgetAmendmentTypeObjectType }
     *     
     */
    public void setBusinessPlanAmendmentTypeReference(BudgetAmendmentTypeObjectType value) {
        this.businessPlanAmendmentTypeReference = value;
    }

    /**
     * Gets the value of the memo property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getMemo() {
        return memo;
    }

    /**
     * Sets the value of the memo property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setMemo(String value) {
        this.memo = value;
    }

    /**
     * Gets the value of the positionBudgetLineReplacementData property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the positionBudgetLineReplacementData property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getPositionBudgetLineReplacementData().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link PositionBudgetLineReplacementDataType }
     * 
     * 
     */
    public List<PositionBudgetLineReplacementDataType> getPositionBudgetLineReplacementData() {
        if (positionBudgetLineReplacementData == null) {
            positionBudgetLineReplacementData = new ArrayList<PositionBudgetLineReplacementDataType>();
        }
        return this.positionBudgetLineReplacementData;
    }

    /**
     * Sets the value of the positionBudgetLineReplacementData property.
     * 
     * @param positionBudgetLineReplacementData
     *     allowed object is
     *     {@link PositionBudgetLineReplacementDataType }
     *     
     */
    public void setPositionBudgetLineReplacementData(List<PositionBudgetLineReplacementDataType> positionBudgetLineReplacementData) {
        this.positionBudgetLineReplacementData = positionBudgetLineReplacementData;
    }

}
