
package com.workday.financial;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;


/**
 * Phone Information
 * 
 * <p>Java class for Phone_Information_DataType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Phone_Information_DataType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Country_ISO_Code" minOccurs="0">
 *           &lt;simpleType>
 *             &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *               &lt;maxLength value="3"/>
 *             &lt;/restriction>
 *           &lt;/simpleType>
 *         &lt;/element>
 *         &lt;element name="International_Phone_Code" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Area_Code" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Phone_Number" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Phone_Extension" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Phone_Device_Type_Reference" type="{urn:com.workday/bsvc}Phone_Device_TypeObjectType" minOccurs="0"/>
 *         &lt;element name="Usage_Data" type="{urn:com.workday/bsvc}Communication_Method_Usage_Information_DataType" maxOccurs="unbounded"/>
 *       &lt;/sequence>
 *       &lt;attribute name="Formatted_Phone" type="{http://www.w3.org/2001/XMLSchema}string" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Phone_Information_DataType", propOrder = {
    "countryISOCode",
    "internationalPhoneCode",
    "areaCode",
    "phoneNumber",
    "phoneExtension",
    "phoneDeviceTypeReference",
    "usageData"
})
public class PhoneInformationDataType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Country_ISO_Code")
    protected String countryISOCode;
    @XmlElement(name = "International_Phone_Code")
    protected String internationalPhoneCode;
    @XmlElement(name = "Area_Code")
    protected String areaCode;
    @XmlElement(name = "Phone_Number")
    protected String phoneNumber;
    @XmlElement(name = "Phone_Extension")
    protected String phoneExtension;
    @XmlElement(name = "Phone_Device_Type_Reference")
    protected PhoneDeviceTypeObjectType phoneDeviceTypeReference;
    @XmlElement(name = "Usage_Data", required = true)
    protected List<CommunicationMethodUsageInformationDataType> usageData;
    @XmlAttribute(name = "Formatted_Phone", namespace = "urn:com.workday/bsvc")
    protected String formattedPhone;

    /**
     * Gets the value of the countryISOCode property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getCountryISOCode() {
        return countryISOCode;
    }

    /**
     * Sets the value of the countryISOCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setCountryISOCode(String value) {
        this.countryISOCode = value;
    }

    /**
     * Gets the value of the internationalPhoneCode property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getInternationalPhoneCode() {
        return internationalPhoneCode;
    }

    /**
     * Sets the value of the internationalPhoneCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setInternationalPhoneCode(String value) {
        this.internationalPhoneCode = value;
    }

    /**
     * Gets the value of the areaCode property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getAreaCode() {
        return areaCode;
    }

    /**
     * Sets the value of the areaCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setAreaCode(String value) {
        this.areaCode = value;
    }

    /**
     * Gets the value of the phoneNumber property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getPhoneNumber() {
        return phoneNumber;
    }

    /**
     * Sets the value of the phoneNumber property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setPhoneNumber(String value) {
        this.phoneNumber = value;
    }

    /**
     * Gets the value of the phoneExtension property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getPhoneExtension() {
        return phoneExtension;
    }

    /**
     * Sets the value of the phoneExtension property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setPhoneExtension(String value) {
        this.phoneExtension = value;
    }

    /**
     * Gets the value of the phoneDeviceTypeReference property.
     * 
     * @return
     *     possible object is
     *     {@link PhoneDeviceTypeObjectType }
     *     
     */
    public PhoneDeviceTypeObjectType getPhoneDeviceTypeReference() {
        return phoneDeviceTypeReference;
    }

    /**
     * Sets the value of the phoneDeviceTypeReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link PhoneDeviceTypeObjectType }
     *     
     */
    public void setPhoneDeviceTypeReference(PhoneDeviceTypeObjectType value) {
        this.phoneDeviceTypeReference = value;
    }

    /**
     * Gets the value of the usageData property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the usageData property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getUsageData().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link CommunicationMethodUsageInformationDataType }
     * 
     * 
     */
    public List<CommunicationMethodUsageInformationDataType> getUsageData() {
        if (usageData == null) {
            usageData = new ArrayList<CommunicationMethodUsageInformationDataType>();
        }
        return this.usageData;
    }

    /**
     * Gets the value of the formattedPhone property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getFormattedPhone() {
        return formattedPhone;
    }

    /**
     * Sets the value of the formattedPhone property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setFormattedPhone(String value) {
        this.formattedPhone = value;
    }

    /**
     * Sets the value of the usageData property.
     * 
     * @param usageData
     *     allowed object is
     *     {@link CommunicationMethodUsageInformationDataType }
     *     
     */
    public void setUsageData(List<CommunicationMethodUsageInformationDataType> usageData) {
        this.usageData = usageData;
    }

}
