
package com.workday.financial;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.datatype.XMLGregorianCalendar;


/**
 * Payroll Remittance Data
 * 
 * <p>Java class for Payroll_Remittance_Worker_DataType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Payroll_Remittance_Worker_DataType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Employee_ID" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Employee_Name" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Preferred_Name" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Legal_Name" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Legal_First_Name" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Legal_Last_Name" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Legal_Middle_Name" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Date_of_Birth" type="{http://www.w3.org/2001/XMLSchema}date" minOccurs="0"/>
 *         &lt;element name="SSN" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Company" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Occupation" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Phone" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Location_Reference" type="{urn:com.workday/bsvc}LocationObjectType" minOccurs="0"/>
 *         &lt;element name="Department_Name_Reference" type="{urn:com.workday/bsvc}Supervisory_OrganizationObjectType" minOccurs="0"/>
 *         &lt;element name="Supervisory_Organization_ID" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Region_Reference" type="{urn:com.workday/bsvc}RegionObjectType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Region_ID" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Cost_Center_Reference" type="{urn:com.workday/bsvc}Cost_CenterObjectType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Cost_Center_ID" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Manager_Reference" type="{urn:com.workday/bsvc}WorkerObjectType" minOccurs="0"/>
 *         &lt;element name="Home_Address_Data" type="{urn:com.workday/bsvc}Address_Information_DataType" maxOccurs="unbounded" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Payroll_Remittance_Worker_DataType", propOrder = {
    "employeeID",
    "employeeName",
    "preferredName",
    "legalName",
    "legalFirstName",
    "legalLastName",
    "legalMiddleName",
    "dateOfBirth",
    "ssn",
    "company",
    "occupation",
    "phone",
    "locationReference",
    "departmentNameReference",
    "supervisoryOrganizationID",
    "regionReference",
    "regionID",
    "costCenterReference",
    "costCenterID",
    "managerReference",
    "homeAddressData"
})
public class PayrollRemittanceWorkerDataType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Employee_ID")
    protected String employeeID;
    @XmlElement(name = "Employee_Name")
    protected String employeeName;
    @XmlElement(name = "Preferred_Name")
    protected String preferredName;
    @XmlElement(name = "Legal_Name")
    protected String legalName;
    @XmlElement(name = "Legal_First_Name")
    protected String legalFirstName;
    @XmlElement(name = "Legal_Last_Name")
    protected String legalLastName;
    @XmlElement(name = "Legal_Middle_Name")
    protected String legalMiddleName;
    @XmlElement(name = "Date_of_Birth")
    @XmlSchemaType(name = "date")
    protected XMLGregorianCalendar dateOfBirth;
    @XmlElement(name = "SSN")
    protected String ssn;
    @XmlElement(name = "Company")
    protected String company;
    @XmlElement(name = "Occupation")
    protected String occupation;
    @XmlElement(name = "Phone")
    protected String phone;
    @XmlElement(name = "Location_Reference")
    protected LocationObjectType locationReference;
    @XmlElement(name = "Department_Name_Reference")
    protected SupervisoryOrganizationObjectType departmentNameReference;
    @XmlElement(name = "Supervisory_Organization_ID")
    protected String supervisoryOrganizationID;
    @XmlElement(name = "Region_Reference")
    protected List<RegionObjectType> regionReference;
    @XmlElement(name = "Region_ID")
    protected String regionID;
    @XmlElement(name = "Cost_Center_Reference")
    protected List<CostCenterObjectType> costCenterReference;
    @XmlElement(name = "Cost_Center_ID")
    protected String costCenterID;
    @XmlElement(name = "Manager_Reference")
    protected WorkerObjectType managerReference;
    @XmlElement(name = "Home_Address_Data")
    protected List<AddressInformationDataType> homeAddressData;

    /**
     * Gets the value of the employeeID property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getEmployeeID() {
        return employeeID;
    }

    /**
     * Sets the value of the employeeID property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setEmployeeID(String value) {
        this.employeeID = value;
    }

    /**
     * Gets the value of the employeeName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * Sets the value of the employeeName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setEmployeeName(String value) {
        this.employeeName = value;
    }

    /**
     * Gets the value of the preferredName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getPreferredName() {
        return preferredName;
    }

    /**
     * Sets the value of the preferredName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setPreferredName(String value) {
        this.preferredName = value;
    }

    /**
     * Gets the value of the legalName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getLegalName() {
        return legalName;
    }

    /**
     * Sets the value of the legalName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setLegalName(String value) {
        this.legalName = value;
    }

    /**
     * Gets the value of the legalFirstName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getLegalFirstName() {
        return legalFirstName;
    }

    /**
     * Sets the value of the legalFirstName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setLegalFirstName(String value) {
        this.legalFirstName = value;
    }

    /**
     * Gets the value of the legalLastName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getLegalLastName() {
        return legalLastName;
    }

    /**
     * Sets the value of the legalLastName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setLegalLastName(String value) {
        this.legalLastName = value;
    }

    /**
     * Gets the value of the legalMiddleName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getLegalMiddleName() {
        return legalMiddleName;
    }

    /**
     * Sets the value of the legalMiddleName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setLegalMiddleName(String value) {
        this.legalMiddleName = value;
    }

    /**
     * Gets the value of the dateOfBirth property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getDateOfBirth() {
        return dateOfBirth;
    }

    /**
     * Sets the value of the dateOfBirth property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setDateOfBirth(XMLGregorianCalendar value) {
        this.dateOfBirth = value;
    }

    /**
     * Gets the value of the ssn property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getSSN() {
        return ssn;
    }

    /**
     * Sets the value of the ssn property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setSSN(String value) {
        this.ssn = value;
    }

    /**
     * Gets the value of the company property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getCompany() {
        return company;
    }

    /**
     * Sets the value of the company property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setCompany(String value) {
        this.company = value;
    }

    /**
     * Gets the value of the occupation property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getOccupation() {
        return occupation;
    }

    /**
     * Sets the value of the occupation property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setOccupation(String value) {
        this.occupation = value;
    }

    /**
     * Gets the value of the phone property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getPhone() {
        return phone;
    }

    /**
     * Sets the value of the phone property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setPhone(String value) {
        this.phone = value;
    }

    /**
     * Gets the value of the locationReference property.
     * 
     * @return
     *     possible object is
     *     {@link LocationObjectType }
     *     
     */
    public LocationObjectType getLocationReference() {
        return locationReference;
    }

    /**
     * Sets the value of the locationReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link LocationObjectType }
     *     
     */
    public void setLocationReference(LocationObjectType value) {
        this.locationReference = value;
    }

    /**
     * Gets the value of the departmentNameReference property.
     * 
     * @return
     *     possible object is
     *     {@link SupervisoryOrganizationObjectType }
     *     
     */
    public SupervisoryOrganizationObjectType getDepartmentNameReference() {
        return departmentNameReference;
    }

    /**
     * Sets the value of the departmentNameReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link SupervisoryOrganizationObjectType }
     *     
     */
    public void setDepartmentNameReference(SupervisoryOrganizationObjectType value) {
        this.departmentNameReference = value;
    }

    /**
     * Gets the value of the supervisoryOrganizationID property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getSupervisoryOrganizationID() {
        return supervisoryOrganizationID;
    }

    /**
     * Sets the value of the supervisoryOrganizationID property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setSupervisoryOrganizationID(String value) {
        this.supervisoryOrganizationID = value;
    }

    /**
     * Gets the value of the regionReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the regionReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getRegionReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link RegionObjectType }
     * 
     * 
     */
    public List<RegionObjectType> getRegionReference() {
        if (regionReference == null) {
            regionReference = new ArrayList<RegionObjectType>();
        }
        return this.regionReference;
    }

    /**
     * Gets the value of the regionID property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getRegionID() {
        return regionID;
    }

    /**
     * Sets the value of the regionID property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setRegionID(String value) {
        this.regionID = value;
    }

    /**
     * Gets the value of the costCenterReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the costCenterReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getCostCenterReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link CostCenterObjectType }
     * 
     * 
     */
    public List<CostCenterObjectType> getCostCenterReference() {
        if (costCenterReference == null) {
            costCenterReference = new ArrayList<CostCenterObjectType>();
        }
        return this.costCenterReference;
    }

    /**
     * Gets the value of the costCenterID property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getCostCenterID() {
        return costCenterID;
    }

    /**
     * Sets the value of the costCenterID property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setCostCenterID(String value) {
        this.costCenterID = value;
    }

    /**
     * Gets the value of the managerReference property.
     * 
     * @return
     *     possible object is
     *     {@link WorkerObjectType }
     *     
     */
    public WorkerObjectType getManagerReference() {
        return managerReference;
    }

    /**
     * Sets the value of the managerReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link WorkerObjectType }
     *     
     */
    public void setManagerReference(WorkerObjectType value) {
        this.managerReference = value;
    }

    /**
     * Gets the value of the homeAddressData property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the homeAddressData property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getHomeAddressData().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AddressInformationDataType }
     * 
     * 
     */
    public List<AddressInformationDataType> getHomeAddressData() {
        if (homeAddressData == null) {
            homeAddressData = new ArrayList<AddressInformationDataType>();
        }
        return this.homeAddressData;
    }

    /**
     * Sets the value of the regionReference property.
     * 
     * @param regionReference
     *     allowed object is
     *     {@link RegionObjectType }
     *     
     */
    public void setRegionReference(List<RegionObjectType> regionReference) {
        this.regionReference = regionReference;
    }

    /**
     * Sets the value of the costCenterReference property.
     * 
     * @param costCenterReference
     *     allowed object is
     *     {@link CostCenterObjectType }
     *     
     */
    public void setCostCenterReference(List<CostCenterObjectType> costCenterReference) {
        this.costCenterReference = costCenterReference;
    }

    /**
     * Sets the value of the homeAddressData property.
     * 
     * @param homeAddressData
     *     allowed object is
     *     {@link AddressInformationDataType }
     *     
     */
    public void setHomeAddressData(List<AddressInformationDataType> homeAddressData) {
        this.homeAddressData = homeAddressData;
    }

}
