
package com.workday.financial;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.datatype.XMLGregorianCalendar;


/**
 * Payroll Remittance Employee Taxes Data
 * 
 * <p>Java class for Payroll_Remittance_Employee_Taxes_DataType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Payroll_Remittance_Employee_Taxes_DataType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="GB_Name" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Pay_Component_Reference" type="{urn:com.workday/bsvc}Pay_Component_ReferenceType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Pay_Component" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Start_Date" type="{http://www.w3.org/2001/XMLSchema}date" minOccurs="0"/>
 *         &lt;element name="End_Date" type="{http://www.w3.org/2001/XMLSchema}date" minOccurs="0"/>
 *         &lt;element name="Payroll_Worktags_Reference" type="{urn:com.workday/bsvc}Payroll_WorktagObjectType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Amount" minOccurs="0">
 *           &lt;simpleType>
 *             &lt;restriction base="{http://www.w3.org/2001/XMLSchema}decimal">
 *               &lt;totalDigits value="26"/>
 *               &lt;fractionDigits value="6"/>
 *             &lt;/restriction>
 *           &lt;/simpleType>
 *         &lt;/element>
 *         &lt;element name="YTD" minOccurs="0">
 *           &lt;simpleType>
 *             &lt;restriction base="{http://www.w3.org/2001/XMLSchema}decimal">
 *               &lt;totalDigits value="26"/>
 *               &lt;fractionDigits value="6"/>
 *             &lt;/restriction>
 *           &lt;/simpleType>
 *         &lt;/element>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Payroll_Remittance_Employee_Taxes_DataType", propOrder = {
    "gbName",
    "payComponentReference",
    "payComponent",
    "startDate",
    "endDate",
    "payrollWorktagsReference",
    "amount",
    "ytd"
})
public class PayrollRemittanceEmployeeTaxesDataType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "GB_Name")
    protected String gbName;
    @XmlElement(name = "Pay_Component_Reference")
    protected List<PayComponentReferenceType> payComponentReference;
    @XmlElement(name = "Pay_Component")
    protected String payComponent;
    @XmlElement(name = "Start_Date")
    @XmlSchemaType(name = "date")
    protected XMLGregorianCalendar startDate;
    @XmlElement(name = "End_Date")
    @XmlSchemaType(name = "date")
    protected XMLGregorianCalendar endDate;
    @XmlElement(name = "Payroll_Worktags_Reference")
    protected List<PayrollWorktagObjectType> payrollWorktagsReference;
    @XmlElement(name = "Amount")
    protected BigDecimal amount;
    @XmlElement(name = "YTD")
    protected BigDecimal ytd;

    /**
     * Gets the value of the gbName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getGBName() {
        return gbName;
    }

    /**
     * Sets the value of the gbName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setGBName(String value) {
        this.gbName = value;
    }

    /**
     * Gets the value of the payComponentReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the payComponentReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getPayComponentReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link PayComponentReferenceType }
     * 
     * 
     */
    public List<PayComponentReferenceType> getPayComponentReference() {
        if (payComponentReference == null) {
            payComponentReference = new ArrayList<PayComponentReferenceType>();
        }
        return this.payComponentReference;
    }

    /**
     * Gets the value of the payComponent property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getPayComponent() {
        return payComponent;
    }

    /**
     * Sets the value of the payComponent property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setPayComponent(String value) {
        this.payComponent = value;
    }

    /**
     * Gets the value of the startDate property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getStartDate() {
        return startDate;
    }

    /**
     * Sets the value of the startDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setStartDate(XMLGregorianCalendar value) {
        this.startDate = value;
    }

    /**
     * Gets the value of the endDate property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getEndDate() {
        return endDate;
    }

    /**
     * Sets the value of the endDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setEndDate(XMLGregorianCalendar value) {
        this.endDate = value;
    }

    /**
     * Gets the value of the payrollWorktagsReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the payrollWorktagsReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getPayrollWorktagsReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link PayrollWorktagObjectType }
     * 
     * 
     */
    public List<PayrollWorktagObjectType> getPayrollWorktagsReference() {
        if (payrollWorktagsReference == null) {
            payrollWorktagsReference = new ArrayList<PayrollWorktagObjectType>();
        }
        return this.payrollWorktagsReference;
    }

    /**
     * Gets the value of the amount property.
     * 
     * @return
     *     possible object is
     *     {@link BigDecimal }
     *     
     */
    public BigDecimal getAmount() {
        return amount;
    }

    /**
     * Sets the value of the amount property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigDecimal }
     *     
     */
    public void setAmount(BigDecimal value) {
        this.amount = value;
    }

    /**
     * Gets the value of the ytd property.
     * 
     * @return
     *     possible object is
     *     {@link BigDecimal }
     *     
     */
    public BigDecimal getYTD() {
        return ytd;
    }

    /**
     * Sets the value of the ytd property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigDecimal }
     *     
     */
    public void setYTD(BigDecimal value) {
        this.ytd = value;
    }

    /**
     * Sets the value of the payComponentReference property.
     * 
     * @param payComponentReference
     *     allowed object is
     *     {@link PayComponentReferenceType }
     *     
     */
    public void setPayComponentReference(List<PayComponentReferenceType> payComponentReference) {
        this.payComponentReference = payComponentReference;
    }

    /**
     * Sets the value of the payrollWorktagsReference property.
     * 
     * @param payrollWorktagsReference
     *     allowed object is
     *     {@link PayrollWorktagObjectType }
     *     
     */
    public void setPayrollWorktagsReference(List<PayrollWorktagObjectType> payrollWorktagsReference) {
        this.payrollWorktagsReference = payrollWorktagsReference;
    }

}
