
package com.workday.financial;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.datatype.XMLGregorianCalendar;


/**
 * Payroll Remittance Data. Will always be included in the Get Payroll Payslips web service.  Can be conditionally returned by setting the "Include Payroll Remittance Data" grouping flag in the Get Payments web service.
 * 
 * <p>Java class for Payroll_Remittance_DataType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Payroll_Remittance_DataType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Period_Start_Date" type="{http://www.w3.org/2001/XMLSchema}date" minOccurs="0"/>
 *         &lt;element name="Period_End_Date" type="{http://www.w3.org/2001/XMLSchema}date" minOccurs="0"/>
 *         &lt;element name="Federal_Marital_Status_Reference" type="{urn:com.workday/bsvc}Payroll_Withholding_StatusObjectType" minOccurs="0"/>
 *         &lt;element name="Federal_Allowance" minOccurs="0">
 *           &lt;simpleType>
 *             &lt;restriction base="{http://www.w3.org/2001/XMLSchema}decimal">
 *               &lt;totalDigits value="12"/>
 *               &lt;minInclusive value="0"/>
 *               &lt;fractionDigits value="0"/>
 *             &lt;/restriction>
 *           &lt;/simpleType>
 *         &lt;/element>
 *         &lt;element name="Federal_Additional_Allowance" minOccurs="0">
 *           &lt;simpleType>
 *             &lt;restriction base="{http://www.w3.org/2001/XMLSchema}decimal">
 *               &lt;totalDigits value="8"/>
 *               &lt;minInclusive value="0"/>
 *               &lt;fractionDigits value="2"/>
 *             &lt;/restriction>
 *           &lt;/simpleType>
 *         &lt;/element>
 *         &lt;element name="Work_State_Marital_Status_Reference" type="{urn:com.workday/bsvc}Payroll_Withholding_StatusObjectType" minOccurs="0"/>
 *         &lt;element name="Work_State_Allowance" minOccurs="0">
 *           &lt;simpleType>
 *             &lt;restriction base="{http://www.w3.org/2001/XMLSchema}decimal">
 *               &lt;totalDigits value="12"/>
 *               &lt;minInclusive value="0"/>
 *               &lt;fractionDigits value="0"/>
 *             &lt;/restriction>
 *           &lt;/simpleType>
 *         &lt;/element>
 *         &lt;element name="Work_State_Additional_Amount" minOccurs="0">
 *           &lt;simpleType>
 *             &lt;restriction base="{http://www.w3.org/2001/XMLSchema}decimal">
 *               &lt;totalDigits value="18"/>
 *               &lt;minInclusive value="0"/>
 *               &lt;fractionDigits value="6"/>
 *             &lt;/restriction>
 *           &lt;/simpleType>
 *         &lt;/element>
 *         &lt;element name="Federal_Total_Claim_Amount" minOccurs="0">
 *           &lt;simpleType>
 *             &lt;restriction base="{http://www.w3.org/2001/XMLSchema}decimal">
 *               &lt;totalDigits value="14"/>
 *               &lt;minInclusive value="0"/>
 *               &lt;fractionDigits value="2"/>
 *             &lt;/restriction>
 *           &lt;/simpleType>
 *         &lt;/element>
 *         &lt;element name="Province_Total_Claim_Amount" minOccurs="0">
 *           &lt;simpleType>
 *             &lt;restriction base="{http://www.w3.org/2001/XMLSchema}decimal">
 *               &lt;totalDigits value="26"/>
 *               &lt;fractionDigits value="6"/>
 *             &lt;/restriction>
 *           &lt;/simpleType>
 *         &lt;/element>
 *         &lt;element name="Federal_Living_Prescribed_Zone" minOccurs="0">
 *           &lt;simpleType>
 *             &lt;restriction base="{http://www.w3.org/2001/XMLSchema}decimal">
 *               &lt;totalDigits value="26"/>
 *               &lt;fractionDigits value="6"/>
 *             &lt;/restriction>
 *           &lt;/simpleType>
 *         &lt;/element>
 *         &lt;element name="Province_Living_Prescribed_Zone" minOccurs="0">
 *           &lt;simpleType>
 *             &lt;restriction base="{http://www.w3.org/2001/XMLSchema}decimal">
 *               &lt;totalDigits value="26"/>
 *               &lt;fractionDigits value="6"/>
 *             &lt;/restriction>
 *           &lt;/simpleType>
 *         &lt;/element>
 *         &lt;element name="Federal_Additional_Tax_Amounts" minOccurs="0">
 *           &lt;simpleType>
 *             &lt;restriction base="{http://www.w3.org/2001/XMLSchema}decimal">
 *               &lt;totalDigits value="14"/>
 *               &lt;minInclusive value="0"/>
 *               &lt;fractionDigits value="2"/>
 *             &lt;/restriction>
 *           &lt;/simpleType>
 *         &lt;/element>
 *         &lt;element name="Province_Additional_Tax_Amounts" minOccurs="0">
 *           &lt;simpleType>
 *             &lt;restriction base="{http://www.w3.org/2001/XMLSchema}decimal">
 *               &lt;totalDigits value="26"/>
 *               &lt;fractionDigits value="6"/>
 *             &lt;/restriction>
 *           &lt;/simpleType>
 *         &lt;/element>
 *         &lt;element name="Federal_Annual_Deductions_Credits" minOccurs="0">
 *           &lt;simpleType>
 *             &lt;restriction base="{http://www.w3.org/2001/XMLSchema}decimal">
 *               &lt;totalDigits value="14"/>
 *               &lt;minInclusive value="0"/>
 *               &lt;fractionDigits value="2"/>
 *             &lt;/restriction>
 *           &lt;/simpleType>
 *         &lt;/element>
 *         &lt;element name="Province_Annual_Deductions_Credits" minOccurs="0">
 *           &lt;simpleType>
 *             &lt;restriction base="{http://www.w3.org/2001/XMLSchema}decimal">
 *               &lt;totalDigits value="26"/>
 *               &lt;fractionDigits value="6"/>
 *             &lt;/restriction>
 *           &lt;/simpleType>
 *         &lt;/element>
 *         &lt;element name="Federal_Labour_Sponsored_Fund" minOccurs="0">
 *           &lt;simpleType>
 *             &lt;restriction base="{http://www.w3.org/2001/XMLSchema}decimal">
 *               &lt;totalDigits value="14"/>
 *               &lt;minInclusive value="0"/>
 *               &lt;fractionDigits value="2"/>
 *             &lt;/restriction>
 *           &lt;/simpleType>
 *         &lt;/element>
 *         &lt;element name="Province_Labour_Sponsored_Fund" minOccurs="0">
 *           &lt;simpleType>
 *             &lt;restriction base="{http://www.w3.org/2001/XMLSchema}decimal">
 *               &lt;totalDigits value="26"/>
 *               &lt;fractionDigits value="6"/>
 *             &lt;/restriction>
 *           &lt;/simpleType>
 *         &lt;/element>
 *         &lt;element name="Pay_Group_Detail_Reference" type="{urn:com.workday/bsvc}Pay_Group_DetailObjectType" minOccurs="0"/>
 *         &lt;element name="Frequency_Name" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Gross_Amount" minOccurs="0">
 *           &lt;simpleType>
 *             &lt;restriction base="{http://www.w3.org/2001/XMLSchema}decimal">
 *               &lt;totalDigits value="18"/>
 *               &lt;fractionDigits value="6"/>
 *             &lt;/restriction>
 *           &lt;/simpleType>
 *         &lt;/element>
 *         &lt;element name="Total_Units" minOccurs="0">
 *           &lt;simpleType>
 *             &lt;restriction base="{http://www.w3.org/2001/XMLSchema}decimal">
 *               &lt;totalDigits value="26"/>
 *               &lt;fractionDigits value="6"/>
 *             &lt;/restriction>
 *           &lt;/simpleType>
 *         &lt;/element>
 *         &lt;element name="Net_Pay" minOccurs="0">
 *           &lt;simpleType>
 *             &lt;restriction base="{http://www.w3.org/2001/XMLSchema}decimal">
 *               &lt;totalDigits value="18"/>
 *               &lt;fractionDigits value="6"/>
 *             &lt;/restriction>
 *           &lt;/simpleType>
 *         &lt;/element>
 *         &lt;element name="Taxes_Deductions" minOccurs="0">
 *           &lt;simpleType>
 *             &lt;restriction base="{http://www.w3.org/2001/XMLSchema}decimal">
 *               &lt;totalDigits value="26"/>
 *               &lt;fractionDigits value="6"/>
 *             &lt;/restriction>
 *           &lt;/simpleType>
 *         &lt;/element>
 *         &lt;element name="Print_Payslip" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Print_Check_on_Payslip" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Payslip_Distribution_Sorting_Criteria" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Worker_Data" type="{urn:com.workday/bsvc}Payroll_Remittance_Worker_DataType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Work_Address_Data" type="{urn:com.workday/bsvc}Address_Information_DataType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Gross_And_Net_Data" type="{urn:com.workday/bsvc}Payroll_Remittance_Gross_And_Net_DataType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Total_Data" type="{urn:com.workday/bsvc}Payroll_Remittance_Total_DataType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Earnings_Data" type="{urn:com.workday/bsvc}Payroll_Remittance_Earnings_DataType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Pre_Tax_Deductions_Data" type="{urn:com.workday/bsvc}Payroll_Remittance_Pre_Tax_Deduction_DataType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Post_Tax_Deductions_Data" type="{urn:com.workday/bsvc}Payroll_Remittance_Post_Tax_DataType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Employee_Taxes_Data" type="{urn:com.workday/bsvc}Payroll_Remittance_Employee_Taxes_DataType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Employer_Paid_Benefits_Data" type="{urn:com.workday/bsvc}Payroll_Remittance_Employer_Paid_Benefits_DataType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Taxable_Wages_Data" type="{urn:com.workday/bsvc}Payroll_Remittance_Taxable_Wages_DataType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Absence_Plans_Data" type="{urn:com.workday/bsvc}Payroll_Remittance_Absence_PlanType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Payslip_Message_Data" type="{urn:com.workday/bsvc}Payroll_Remittance_Payslip_Message_DataType" maxOccurs="unbounded" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Payroll_Remittance_DataType", propOrder = {
    "periodStartDate",
    "periodEndDate",
    "federalMaritalStatusReference",
    "federalAllowance",
    "federalAdditionalAllowance",
    "workStateMaritalStatusReference",
    "workStateAllowance",
    "workStateAdditionalAmount",
    "federalTotalClaimAmount",
    "provinceTotalClaimAmount",
    "federalLivingPrescribedZone",
    "provinceLivingPrescribedZone",
    "federalAdditionalTaxAmounts",
    "provinceAdditionalTaxAmounts",
    "federalAnnualDeductionsCredits",
    "provinceAnnualDeductionsCredits",
    "federalLabourSponsoredFund",
    "provinceLabourSponsoredFund",
    "payGroupDetailReference",
    "frequencyName",
    "grossAmount",
    "totalUnits",
    "netPay",
    "taxesDeductions",
    "printPayslip",
    "printCheckOnPayslip",
    "payslipDistributionSortingCriteria",
    "workerData",
    "workAddressData",
    "grossAndNetData",
    "totalData",
    "earningsData",
    "preTaxDeductionsData",
    "postTaxDeductionsData",
    "employeeTaxesData",
    "employerPaidBenefitsData",
    "taxableWagesData",
    "absencePlansData",
    "payslipMessageData"
})
public class PayrollRemittanceDataType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Period_Start_Date")
    @XmlSchemaType(name = "date")
    protected XMLGregorianCalendar periodStartDate;
    @XmlElement(name = "Period_End_Date")
    @XmlSchemaType(name = "date")
    protected XMLGregorianCalendar periodEndDate;
    @XmlElement(name = "Federal_Marital_Status_Reference")
    protected PayrollWithholdingStatusObjectType federalMaritalStatusReference;
    @XmlElement(name = "Federal_Allowance")
    protected BigDecimal federalAllowance;
    @XmlElement(name = "Federal_Additional_Allowance")
    protected BigDecimal federalAdditionalAllowance;
    @XmlElement(name = "Work_State_Marital_Status_Reference")
    protected PayrollWithholdingStatusObjectType workStateMaritalStatusReference;
    @XmlElement(name = "Work_State_Allowance")
    protected BigDecimal workStateAllowance;
    @XmlElement(name = "Work_State_Additional_Amount")
    protected BigDecimal workStateAdditionalAmount;
    @XmlElement(name = "Federal_Total_Claim_Amount")
    protected BigDecimal federalTotalClaimAmount;
    @XmlElement(name = "Province_Total_Claim_Amount")
    protected BigDecimal provinceTotalClaimAmount;
    @XmlElement(name = "Federal_Living_Prescribed_Zone")
    protected BigDecimal federalLivingPrescribedZone;
    @XmlElement(name = "Province_Living_Prescribed_Zone")
    protected BigDecimal provinceLivingPrescribedZone;
    @XmlElement(name = "Federal_Additional_Tax_Amounts")
    protected BigDecimal federalAdditionalTaxAmounts;
    @XmlElement(name = "Province_Additional_Tax_Amounts")
    protected BigDecimal provinceAdditionalTaxAmounts;
    @XmlElement(name = "Federal_Annual_Deductions_Credits")
    protected BigDecimal federalAnnualDeductionsCredits;
    @XmlElement(name = "Province_Annual_Deductions_Credits")
    protected BigDecimal provinceAnnualDeductionsCredits;
    @XmlElement(name = "Federal_Labour_Sponsored_Fund")
    protected BigDecimal federalLabourSponsoredFund;
    @XmlElement(name = "Province_Labour_Sponsored_Fund")
    protected BigDecimal provinceLabourSponsoredFund;
    @XmlElement(name = "Pay_Group_Detail_Reference")
    protected PayGroupDetailObjectType payGroupDetailReference;
    @XmlElement(name = "Frequency_Name")
    protected String frequencyName;
    @XmlElement(name = "Gross_Amount")
    protected BigDecimal grossAmount;
    @XmlElement(name = "Total_Units")
    protected BigDecimal totalUnits;
    @XmlElement(name = "Net_Pay")
    protected BigDecimal netPay;
    @XmlElement(name = "Taxes_Deductions")
    protected BigDecimal taxesDeductions;
    @XmlElement(name = "Print_Payslip")
    protected Boolean printPayslip;
    @XmlElement(name = "Print_Check_on_Payslip")
    protected Boolean printCheckOnPayslip;
    @XmlElement(name = "Payslip_Distribution_Sorting_Criteria")
    protected String payslipDistributionSortingCriteria;
    @XmlElement(name = "Worker_Data")
    protected List<PayrollRemittanceWorkerDataType> workerData;
    @XmlElement(name = "Work_Address_Data")
    protected List<AddressInformationDataType> workAddressData;
    @XmlElement(name = "Gross_And_Net_Data")
    protected List<PayrollRemittanceGrossAndNetDataType> grossAndNetData;
    @XmlElement(name = "Total_Data")
    protected List<PayrollRemittanceTotalDataType> totalData;
    @XmlElement(name = "Earnings_Data")
    protected List<PayrollRemittanceEarningsDataType> earningsData;
    @XmlElement(name = "Pre_Tax_Deductions_Data")
    protected List<PayrollRemittancePreTaxDeductionDataType> preTaxDeductionsData;
    @XmlElement(name = "Post_Tax_Deductions_Data")
    protected List<PayrollRemittancePostTaxDataType> postTaxDeductionsData;
    @XmlElement(name = "Employee_Taxes_Data")
    protected List<PayrollRemittanceEmployeeTaxesDataType> employeeTaxesData;
    @XmlElement(name = "Employer_Paid_Benefits_Data")
    protected List<PayrollRemittanceEmployerPaidBenefitsDataType> employerPaidBenefitsData;
    @XmlElement(name = "Taxable_Wages_Data")
    protected List<PayrollRemittanceTaxableWagesDataType> taxableWagesData;
    @XmlElement(name = "Absence_Plans_Data")
    protected List<PayrollRemittanceAbsencePlanType> absencePlansData;
    @XmlElement(name = "Payslip_Message_Data")
    protected List<PayrollRemittancePayslipMessageDataType> payslipMessageData;

    /**
     * Gets the value of the periodStartDate property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getPeriodStartDate() {
        return periodStartDate;
    }

    /**
     * Sets the value of the periodStartDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setPeriodStartDate(XMLGregorianCalendar value) {
        this.periodStartDate = value;
    }

    /**
     * Gets the value of the periodEndDate property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getPeriodEndDate() {
        return periodEndDate;
    }

    /**
     * Sets the value of the periodEndDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setPeriodEndDate(XMLGregorianCalendar value) {
        this.periodEndDate = value;
    }

    /**
     * Gets the value of the federalMaritalStatusReference property.
     * 
     * @return
     *     possible object is
     *     {@link PayrollWithholdingStatusObjectType }
     *     
     */
    public PayrollWithholdingStatusObjectType getFederalMaritalStatusReference() {
        return federalMaritalStatusReference;
    }

    /**
     * Sets the value of the federalMaritalStatusReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link PayrollWithholdingStatusObjectType }
     *     
     */
    public void setFederalMaritalStatusReference(PayrollWithholdingStatusObjectType value) {
        this.federalMaritalStatusReference = value;
    }

    /**
     * Gets the value of the federalAllowance property.
     * 
     * @return
     *     possible object is
     *     {@link BigDecimal }
     *     
     */
    public BigDecimal getFederalAllowance() {
        return federalAllowance;
    }

    /**
     * Sets the value of the federalAllowance property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigDecimal }
     *     
     */
    public void setFederalAllowance(BigDecimal value) {
        this.federalAllowance = value;
    }

    /**
     * Gets the value of the federalAdditionalAllowance property.
     * 
     * @return
     *     possible object is
     *     {@link BigDecimal }
     *     
     */
    public BigDecimal getFederalAdditionalAllowance() {
        return federalAdditionalAllowance;
    }

    /**
     * Sets the value of the federalAdditionalAllowance property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigDecimal }
     *     
     */
    public void setFederalAdditionalAllowance(BigDecimal value) {
        this.federalAdditionalAllowance = value;
    }

    /**
     * Gets the value of the workStateMaritalStatusReference property.
     * 
     * @return
     *     possible object is
     *     {@link PayrollWithholdingStatusObjectType }
     *     
     */
    public PayrollWithholdingStatusObjectType getWorkStateMaritalStatusReference() {
        return workStateMaritalStatusReference;
    }

    /**
     * Sets the value of the workStateMaritalStatusReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link PayrollWithholdingStatusObjectType }
     *     
     */
    public void setWorkStateMaritalStatusReference(PayrollWithholdingStatusObjectType value) {
        this.workStateMaritalStatusReference = value;
    }

    /**
     * Gets the value of the workStateAllowance property.
     * 
     * @return
     *     possible object is
     *     {@link BigDecimal }
     *     
     */
    public BigDecimal getWorkStateAllowance() {
        return workStateAllowance;
    }

    /**
     * Sets the value of the workStateAllowance property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigDecimal }
     *     
     */
    public void setWorkStateAllowance(BigDecimal value) {
        this.workStateAllowance = value;
    }

    /**
     * Gets the value of the workStateAdditionalAmount property.
     * 
     * @return
     *     possible object is
     *     {@link BigDecimal }
     *     
     */
    public BigDecimal getWorkStateAdditionalAmount() {
        return workStateAdditionalAmount;
    }

    /**
     * Sets the value of the workStateAdditionalAmount property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigDecimal }
     *     
     */
    public void setWorkStateAdditionalAmount(BigDecimal value) {
        this.workStateAdditionalAmount = value;
    }

    /**
     * Gets the value of the federalTotalClaimAmount property.
     * 
     * @return
     *     possible object is
     *     {@link BigDecimal }
     *     
     */
    public BigDecimal getFederalTotalClaimAmount() {
        return federalTotalClaimAmount;
    }

    /**
     * Sets the value of the federalTotalClaimAmount property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigDecimal }
     *     
     */
    public void setFederalTotalClaimAmount(BigDecimal value) {
        this.federalTotalClaimAmount = value;
    }

    /**
     * Gets the value of the provinceTotalClaimAmount property.
     * 
     * @return
     *     possible object is
     *     {@link BigDecimal }
     *     
     */
    public BigDecimal getProvinceTotalClaimAmount() {
        return provinceTotalClaimAmount;
    }

    /**
     * Sets the value of the provinceTotalClaimAmount property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigDecimal }
     *     
     */
    public void setProvinceTotalClaimAmount(BigDecimal value) {
        this.provinceTotalClaimAmount = value;
    }

    /**
     * Gets the value of the federalLivingPrescribedZone property.
     * 
     * @return
     *     possible object is
     *     {@link BigDecimal }
     *     
     */
    public BigDecimal getFederalLivingPrescribedZone() {
        return federalLivingPrescribedZone;
    }

    /**
     * Sets the value of the federalLivingPrescribedZone property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigDecimal }
     *     
     */
    public void setFederalLivingPrescribedZone(BigDecimal value) {
        this.federalLivingPrescribedZone = value;
    }

    /**
     * Gets the value of the provinceLivingPrescribedZone property.
     * 
     * @return
     *     possible object is
     *     {@link BigDecimal }
     *     
     */
    public BigDecimal getProvinceLivingPrescribedZone() {
        return provinceLivingPrescribedZone;
    }

    /**
     * Sets the value of the provinceLivingPrescribedZone property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigDecimal }
     *     
     */
    public void setProvinceLivingPrescribedZone(BigDecimal value) {
        this.provinceLivingPrescribedZone = value;
    }

    /**
     * Gets the value of the federalAdditionalTaxAmounts property.
     * 
     * @return
     *     possible object is
     *     {@link BigDecimal }
     *     
     */
    public BigDecimal getFederalAdditionalTaxAmounts() {
        return federalAdditionalTaxAmounts;
    }

    /**
     * Sets the value of the federalAdditionalTaxAmounts property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigDecimal }
     *     
     */
    public void setFederalAdditionalTaxAmounts(BigDecimal value) {
        this.federalAdditionalTaxAmounts = value;
    }

    /**
     * Gets the value of the provinceAdditionalTaxAmounts property.
     * 
     * @return
     *     possible object is
     *     {@link BigDecimal }
     *     
     */
    public BigDecimal getProvinceAdditionalTaxAmounts() {
        return provinceAdditionalTaxAmounts;
    }

    /**
     * Sets the value of the provinceAdditionalTaxAmounts property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigDecimal }
     *     
     */
    public void setProvinceAdditionalTaxAmounts(BigDecimal value) {
        this.provinceAdditionalTaxAmounts = value;
    }

    /**
     * Gets the value of the federalAnnualDeductionsCredits property.
     * 
     * @return
     *     possible object is
     *     {@link BigDecimal }
     *     
     */
    public BigDecimal getFederalAnnualDeductionsCredits() {
        return federalAnnualDeductionsCredits;
    }

    /**
     * Sets the value of the federalAnnualDeductionsCredits property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigDecimal }
     *     
     */
    public void setFederalAnnualDeductionsCredits(BigDecimal value) {
        this.federalAnnualDeductionsCredits = value;
    }

    /**
     * Gets the value of the provinceAnnualDeductionsCredits property.
     * 
     * @return
     *     possible object is
     *     {@link BigDecimal }
     *     
     */
    public BigDecimal getProvinceAnnualDeductionsCredits() {
        return provinceAnnualDeductionsCredits;
    }

    /**
     * Sets the value of the provinceAnnualDeductionsCredits property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigDecimal }
     *     
     */
    public void setProvinceAnnualDeductionsCredits(BigDecimal value) {
        this.provinceAnnualDeductionsCredits = value;
    }

    /**
     * Gets the value of the federalLabourSponsoredFund property.
     * 
     * @return
     *     possible object is
     *     {@link BigDecimal }
     *     
     */
    public BigDecimal getFederalLabourSponsoredFund() {
        return federalLabourSponsoredFund;
    }

    /**
     * Sets the value of the federalLabourSponsoredFund property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigDecimal }
     *     
     */
    public void setFederalLabourSponsoredFund(BigDecimal value) {
        this.federalLabourSponsoredFund = value;
    }

    /**
     * Gets the value of the provinceLabourSponsoredFund property.
     * 
     * @return
     *     possible object is
     *     {@link BigDecimal }
     *     
     */
    public BigDecimal getProvinceLabourSponsoredFund() {
        return provinceLabourSponsoredFund;
    }

    /**
     * Sets the value of the provinceLabourSponsoredFund property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigDecimal }
     *     
     */
    public void setProvinceLabourSponsoredFund(BigDecimal value) {
        this.provinceLabourSponsoredFund = value;
    }

    /**
     * Gets the value of the payGroupDetailReference property.
     * 
     * @return
     *     possible object is
     *     {@link PayGroupDetailObjectType }
     *     
     */
    public PayGroupDetailObjectType getPayGroupDetailReference() {
        return payGroupDetailReference;
    }

    /**
     * Sets the value of the payGroupDetailReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link PayGroupDetailObjectType }
     *     
     */
    public void setPayGroupDetailReference(PayGroupDetailObjectType value) {
        this.payGroupDetailReference = value;
    }

    /**
     * Gets the value of the frequencyName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getFrequencyName() {
        return frequencyName;
    }

    /**
     * Sets the value of the frequencyName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setFrequencyName(String value) {
        this.frequencyName = value;
    }

    /**
     * Gets the value of the grossAmount property.
     * 
     * @return
     *     possible object is
     *     {@link BigDecimal }
     *     
     */
    public BigDecimal getGrossAmount() {
        return grossAmount;
    }

    /**
     * Sets the value of the grossAmount property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigDecimal }
     *     
     */
    public void setGrossAmount(BigDecimal value) {
        this.grossAmount = value;
    }

    /**
     * Gets the value of the totalUnits property.
     * 
     * @return
     *     possible object is
     *     {@link BigDecimal }
     *     
     */
    public BigDecimal getTotalUnits() {
        return totalUnits;
    }

    /**
     * Sets the value of the totalUnits property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigDecimal }
     *     
     */
    public void setTotalUnits(BigDecimal value) {
        this.totalUnits = value;
    }

    /**
     * Gets the value of the netPay property.
     * 
     * @return
     *     possible object is
     *     {@link BigDecimal }
     *     
     */
    public BigDecimal getNetPay() {
        return netPay;
    }

    /**
     * Sets the value of the netPay property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigDecimal }
     *     
     */
    public void setNetPay(BigDecimal value) {
        this.netPay = value;
    }

    /**
     * Gets the value of the taxesDeductions property.
     * 
     * @return
     *     possible object is
     *     {@link BigDecimal }
     *     
     */
    public BigDecimal getTaxesDeductions() {
        return taxesDeductions;
    }

    /**
     * Sets the value of the taxesDeductions property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigDecimal }
     *     
     */
    public void setTaxesDeductions(BigDecimal value) {
        this.taxesDeductions = value;
    }

    /**
     * Gets the value of the printPayslip property.
     * This getter has been renamed from isPrintPayslip() to getPrintPayslip() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getPrintPayslip() {
        return printPayslip;
    }

    /**
     * Sets the value of the printPayslip property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setPrintPayslip(Boolean value) {
        this.printPayslip = value;
    }

    /**
     * Gets the value of the printCheckOnPayslip property.
     * This getter has been renamed from isPrintCheckOnPayslip() to getPrintCheckOnPayslip() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getPrintCheckOnPayslip() {
        return printCheckOnPayslip;
    }

    /**
     * Sets the value of the printCheckOnPayslip property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setPrintCheckOnPayslip(Boolean value) {
        this.printCheckOnPayslip = value;
    }

    /**
     * Gets the value of the payslipDistributionSortingCriteria property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getPayslipDistributionSortingCriteria() {
        return payslipDistributionSortingCriteria;
    }

    /**
     * Sets the value of the payslipDistributionSortingCriteria property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setPayslipDistributionSortingCriteria(String value) {
        this.payslipDistributionSortingCriteria = value;
    }

    /**
     * Gets the value of the workerData property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the workerData property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getWorkerData().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link PayrollRemittanceWorkerDataType }
     * 
     * 
     */
    public List<PayrollRemittanceWorkerDataType> getWorkerData() {
        if (workerData == null) {
            workerData = new ArrayList<PayrollRemittanceWorkerDataType>();
        }
        return this.workerData;
    }

    /**
     * Gets the value of the workAddressData property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the workAddressData property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getWorkAddressData().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AddressInformationDataType }
     * 
     * 
     */
    public List<AddressInformationDataType> getWorkAddressData() {
        if (workAddressData == null) {
            workAddressData = new ArrayList<AddressInformationDataType>();
        }
        return this.workAddressData;
    }

    /**
     * Gets the value of the grossAndNetData property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the grossAndNetData property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getGrossAndNetData().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link PayrollRemittanceGrossAndNetDataType }
     * 
     * 
     */
    public List<PayrollRemittanceGrossAndNetDataType> getGrossAndNetData() {
        if (grossAndNetData == null) {
            grossAndNetData = new ArrayList<PayrollRemittanceGrossAndNetDataType>();
        }
        return this.grossAndNetData;
    }

    /**
     * Gets the value of the totalData property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the totalData property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getTotalData().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link PayrollRemittanceTotalDataType }
     * 
     * 
     */
    public List<PayrollRemittanceTotalDataType> getTotalData() {
        if (totalData == null) {
            totalData = new ArrayList<PayrollRemittanceTotalDataType>();
        }
        return this.totalData;
    }

    /**
     * Gets the value of the earningsData property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the earningsData property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getEarningsData().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link PayrollRemittanceEarningsDataType }
     * 
     * 
     */
    public List<PayrollRemittanceEarningsDataType> getEarningsData() {
        if (earningsData == null) {
            earningsData = new ArrayList<PayrollRemittanceEarningsDataType>();
        }
        return this.earningsData;
    }

    /**
     * Gets the value of the preTaxDeductionsData property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the preTaxDeductionsData property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getPreTaxDeductionsData().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link PayrollRemittancePreTaxDeductionDataType }
     * 
     * 
     */
    public List<PayrollRemittancePreTaxDeductionDataType> getPreTaxDeductionsData() {
        if (preTaxDeductionsData == null) {
            preTaxDeductionsData = new ArrayList<PayrollRemittancePreTaxDeductionDataType>();
        }
        return this.preTaxDeductionsData;
    }

    /**
     * Gets the value of the postTaxDeductionsData property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the postTaxDeductionsData property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getPostTaxDeductionsData().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link PayrollRemittancePostTaxDataType }
     * 
     * 
     */
    public List<PayrollRemittancePostTaxDataType> getPostTaxDeductionsData() {
        if (postTaxDeductionsData == null) {
            postTaxDeductionsData = new ArrayList<PayrollRemittancePostTaxDataType>();
        }
        return this.postTaxDeductionsData;
    }

    /**
     * Gets the value of the employeeTaxesData property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the employeeTaxesData property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getEmployeeTaxesData().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link PayrollRemittanceEmployeeTaxesDataType }
     * 
     * 
     */
    public List<PayrollRemittanceEmployeeTaxesDataType> getEmployeeTaxesData() {
        if (employeeTaxesData == null) {
            employeeTaxesData = new ArrayList<PayrollRemittanceEmployeeTaxesDataType>();
        }
        return this.employeeTaxesData;
    }

    /**
     * Gets the value of the employerPaidBenefitsData property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the employerPaidBenefitsData property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getEmployerPaidBenefitsData().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link PayrollRemittanceEmployerPaidBenefitsDataType }
     * 
     * 
     */
    public List<PayrollRemittanceEmployerPaidBenefitsDataType> getEmployerPaidBenefitsData() {
        if (employerPaidBenefitsData == null) {
            employerPaidBenefitsData = new ArrayList<PayrollRemittanceEmployerPaidBenefitsDataType>();
        }
        return this.employerPaidBenefitsData;
    }

    /**
     * Gets the value of the taxableWagesData property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the taxableWagesData property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getTaxableWagesData().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link PayrollRemittanceTaxableWagesDataType }
     * 
     * 
     */
    public List<PayrollRemittanceTaxableWagesDataType> getTaxableWagesData() {
        if (taxableWagesData == null) {
            taxableWagesData = new ArrayList<PayrollRemittanceTaxableWagesDataType>();
        }
        return this.taxableWagesData;
    }

    /**
     * Gets the value of the absencePlansData property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the absencePlansData property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getAbsencePlansData().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link PayrollRemittanceAbsencePlanType }
     * 
     * 
     */
    public List<PayrollRemittanceAbsencePlanType> getAbsencePlansData() {
        if (absencePlansData == null) {
            absencePlansData = new ArrayList<PayrollRemittanceAbsencePlanType>();
        }
        return this.absencePlansData;
    }

    /**
     * Gets the value of the payslipMessageData property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the payslipMessageData property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getPayslipMessageData().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link PayrollRemittancePayslipMessageDataType }
     * 
     * 
     */
    public List<PayrollRemittancePayslipMessageDataType> getPayslipMessageData() {
        if (payslipMessageData == null) {
            payslipMessageData = new ArrayList<PayrollRemittancePayslipMessageDataType>();
        }
        return this.payslipMessageData;
    }

    /**
     * Sets the value of the workerData property.
     * 
     * @param workerData
     *     allowed object is
     *     {@link PayrollRemittanceWorkerDataType }
     *     
     */
    public void setWorkerData(List<PayrollRemittanceWorkerDataType> workerData) {
        this.workerData = workerData;
    }

    /**
     * Sets the value of the workAddressData property.
     * 
     * @param workAddressData
     *     allowed object is
     *     {@link AddressInformationDataType }
     *     
     */
    public void setWorkAddressData(List<AddressInformationDataType> workAddressData) {
        this.workAddressData = workAddressData;
    }

    /**
     * Sets the value of the grossAndNetData property.
     * 
     * @param grossAndNetData
     *     allowed object is
     *     {@link PayrollRemittanceGrossAndNetDataType }
     *     
     */
    public void setGrossAndNetData(List<PayrollRemittanceGrossAndNetDataType> grossAndNetData) {
        this.grossAndNetData = grossAndNetData;
    }

    /**
     * Sets the value of the totalData property.
     * 
     * @param totalData
     *     allowed object is
     *     {@link PayrollRemittanceTotalDataType }
     *     
     */
    public void setTotalData(List<PayrollRemittanceTotalDataType> totalData) {
        this.totalData = totalData;
    }

    /**
     * Sets the value of the earningsData property.
     * 
     * @param earningsData
     *     allowed object is
     *     {@link PayrollRemittanceEarningsDataType }
     *     
     */
    public void setEarningsData(List<PayrollRemittanceEarningsDataType> earningsData) {
        this.earningsData = earningsData;
    }

    /**
     * Sets the value of the preTaxDeductionsData property.
     * 
     * @param preTaxDeductionsData
     *     allowed object is
     *     {@link PayrollRemittancePreTaxDeductionDataType }
     *     
     */
    public void setPreTaxDeductionsData(List<PayrollRemittancePreTaxDeductionDataType> preTaxDeductionsData) {
        this.preTaxDeductionsData = preTaxDeductionsData;
    }

    /**
     * Sets the value of the postTaxDeductionsData property.
     * 
     * @param postTaxDeductionsData
     *     allowed object is
     *     {@link PayrollRemittancePostTaxDataType }
     *     
     */
    public void setPostTaxDeductionsData(List<PayrollRemittancePostTaxDataType> postTaxDeductionsData) {
        this.postTaxDeductionsData = postTaxDeductionsData;
    }

    /**
     * Sets the value of the employeeTaxesData property.
     * 
     * @param employeeTaxesData
     *     allowed object is
     *     {@link PayrollRemittanceEmployeeTaxesDataType }
     *     
     */
    public void setEmployeeTaxesData(List<PayrollRemittanceEmployeeTaxesDataType> employeeTaxesData) {
        this.employeeTaxesData = employeeTaxesData;
    }

    /**
     * Sets the value of the employerPaidBenefitsData property.
     * 
     * @param employerPaidBenefitsData
     *     allowed object is
     *     {@link PayrollRemittanceEmployerPaidBenefitsDataType }
     *     
     */
    public void setEmployerPaidBenefitsData(List<PayrollRemittanceEmployerPaidBenefitsDataType> employerPaidBenefitsData) {
        this.employerPaidBenefitsData = employerPaidBenefitsData;
    }

    /**
     * Sets the value of the taxableWagesData property.
     * 
     * @param taxableWagesData
     *     allowed object is
     *     {@link PayrollRemittanceTaxableWagesDataType }
     *     
     */
    public void setTaxableWagesData(List<PayrollRemittanceTaxableWagesDataType> taxableWagesData) {
        this.taxableWagesData = taxableWagesData;
    }

    /**
     * Sets the value of the absencePlansData property.
     * 
     * @param absencePlansData
     *     allowed object is
     *     {@link PayrollRemittanceAbsencePlanType }
     *     
     */
    public void setAbsencePlansData(List<PayrollRemittanceAbsencePlanType> absencePlansData) {
        this.absencePlansData = absencePlansData;
    }

    /**
     * Sets the value of the payslipMessageData property.
     * 
     * @param payslipMessageData
     *     allowed object is
     *     {@link PayrollRemittancePayslipMessageDataType }
     *     
     */
    public void setPayslipMessageData(List<PayrollRemittancePayslipMessageDataType> payslipMessageData) {
        this.payslipMessageData = payslipMessageData;
    }

}
