
package com.workday.financial;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;


/**
 * Payment Data
 * 
 * <p>Java class for Payment_WWS_DataType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Payment_WWS_DataType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Payment_Group_Data" type="{urn:com.workday/bsvc}Payment_Group_DataType" minOccurs="0"/>
 *         &lt;element name="Settlement_Run_Reference" type="{urn:com.workday/bsvc}Unique_IdentifierObjectType" minOccurs="0"/>
 *         &lt;element name="Payment_Status" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Payment_Memo" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Payment_Reference_Number" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Payment_Amount" minOccurs="0">
 *           &lt;simpleType>
 *             &lt;restriction base="{http://www.w3.org/2001/XMLSchema}decimal">
 *               &lt;totalDigits value="26"/>
 *               &lt;fractionDigits value="6"/>
 *             &lt;/restriction>
 *           &lt;/simpleType>
 *         &lt;/element>
 *         &lt;element name="Amount_as_Text" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Discount_Taken" minOccurs="0">
 *           &lt;simpleType>
 *             &lt;restriction base="{http://www.w3.org/2001/XMLSchema}decimal">
 *               &lt;totalDigits value="26"/>
 *               &lt;fractionDigits value="6"/>
 *             &lt;/restriction>
 *           &lt;/simpleType>
 *         &lt;/element>
 *         &lt;element name="Currency_Reference" type="{urn:com.workday/bsvc}CurrencyObjectType" minOccurs="0"/>
 *         &lt;element name="Currency_Symbol" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Currency_Description" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Check_or_Advice_Number" minOccurs="0">
 *           &lt;simpleType>
 *             &lt;restriction base="{http://www.w3.org/2001/XMLSchema}decimal">
 *               &lt;totalDigits value="20"/>
 *               &lt;minInclusive value="0"/>
 *               &lt;fractionDigits value="0"/>
 *             &lt;/restriction>
 *           &lt;/simpleType>
 *         &lt;/element>
 *         &lt;element name="Check_Number" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Prenote_Flag" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Payroll_Payment_Display_Order" minOccurs="0">
 *           &lt;simpleType>
 *             &lt;restriction base="{http://www.w3.org/2001/XMLSchema}decimal">
 *               &lt;totalDigits value="6"/>
 *               &lt;minInclusive value="0"/>
 *               &lt;fractionDigits value="0"/>
 *             &lt;/restriction>
 *           &lt;/simpleType>
 *         &lt;/element>
 *         &lt;element name="Handling_Code_Reference" type="{urn:com.workday/bsvc}Payment_Handling_InstructionObjectType" minOccurs="0"/>
 *         &lt;element name="Tax_Code_Reference" type="{urn:com.workday/bsvc}Tax_CodeObjectType" minOccurs="0"/>
 *         &lt;element name="Company_Reference" type="{urn:com.workday/bsvc}CompanyObjectType" minOccurs="0"/>
 *         &lt;element name="On_Behalf_of_Company_Reference" type="{urn:com.workday/bsvc}CompanyObjectType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Originating_Contact_Data" type="{urn:com.workday/bsvc}Originating_Party_WWS_DataType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Originating_Bank_Data" type="{urn:com.workday/bsvc}Originating_Party_Bank_DataType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Receiving_Party_Reference" type="{urn:com.workday/bsvc}PayeeObjectType" minOccurs="0"/>
 *         &lt;element name="Receiving_Party_Contact_Data" type="{urn:com.workday/bsvc}Receiving_Party_WWS_DataType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Receiving_Party_Bank_Data" type="{urn:com.workday/bsvc}Receiving_Party_Bank_DataType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Receiving_Party_Credit_Card_Data" type="{urn:com.workday/bsvc}Receiving_Party_Credit_Card_DataType" minOccurs="0"/>
 *         &lt;element name="Remittance_Data" type="{urn:com.workday/bsvc}Remittance_DataType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Payroll_Remittance_Data" type="{urn:com.workday/bsvc}Payroll_Remittance_DataType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Integration_Field_Override_Data" type="{urn:com.workday/bsvc}Document_Field_Result_DataType" maxOccurs="unbounded" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Payment_WWS_DataType", propOrder = {
    "paymentGroupData",
    "settlementRunReference",
    "paymentStatus",
    "paymentMemo",
    "paymentReferenceNumber",
    "paymentAmount",
    "amountAsText",
    "discountTaken",
    "currencyReference",
    "currencySymbol",
    "currencyDescription",
    "checkOrAdviceNumber",
    "checkNumber",
    "prenoteFlag",
    "payrollPaymentDisplayOrder",
    "handlingCodeReference",
    "taxCodeReference",
    "companyReference",
    "onBehalfOfCompanyReference",
    "originatingContactData",
    "originatingBankData",
    "receivingPartyReference",
    "receivingPartyContactData",
    "receivingPartyBankData",
    "receivingPartyCreditCardData",
    "remittanceData",
    "payrollRemittanceData",
    "integrationFieldOverrideData"
})
public class PaymentWWSDataType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Payment_Group_Data")
    protected PaymentGroupDataType paymentGroupData;
    @XmlElement(name = "Settlement_Run_Reference")
    protected UniqueIdentifierObjectType settlementRunReference;
    @XmlElement(name = "Payment_Status")
    protected String paymentStatus;
    @XmlElement(name = "Payment_Memo")
    protected String paymentMemo;
    @XmlElement(name = "Payment_Reference_Number")
    protected String paymentReferenceNumber;
    @XmlElement(name = "Payment_Amount")
    protected BigDecimal paymentAmount;
    @XmlElement(name = "Amount_as_Text")
    protected String amountAsText;
    @XmlElement(name = "Discount_Taken")
    protected BigDecimal discountTaken;
    @XmlElement(name = "Currency_Reference")
    protected CurrencyObjectType currencyReference;
    @XmlElement(name = "Currency_Symbol")
    protected String currencySymbol;
    @XmlElement(name = "Currency_Description")
    protected String currencyDescription;
    @XmlElement(name = "Check_or_Advice_Number")
    protected BigDecimal checkOrAdviceNumber;
    @XmlElement(name = "Check_Number")
    protected String checkNumber;
    @XmlElement(name = "Prenote_Flag")
    protected Boolean prenoteFlag;
    @XmlElement(name = "Payroll_Payment_Display_Order")
    protected BigDecimal payrollPaymentDisplayOrder;
    @XmlElement(name = "Handling_Code_Reference")
    protected PaymentHandlingInstructionObjectType handlingCodeReference;
    @XmlElement(name = "Tax_Code_Reference")
    protected TaxCodeObjectType taxCodeReference;
    @XmlElement(name = "Company_Reference")
    protected CompanyObjectType companyReference;
    @XmlElement(name = "On_Behalf_of_Company_Reference")
    protected List<CompanyObjectType> onBehalfOfCompanyReference;
    @XmlElement(name = "Originating_Contact_Data")
    protected List<OriginatingPartyWWSDataType> originatingContactData;
    @XmlElement(name = "Originating_Bank_Data")
    protected List<OriginatingPartyBankDataType> originatingBankData;
    @XmlElement(name = "Receiving_Party_Reference")
    protected PayeeObjectType receivingPartyReference;
    @XmlElement(name = "Receiving_Party_Contact_Data")
    protected List<ReceivingPartyWWSDataType> receivingPartyContactData;
    @XmlElement(name = "Receiving_Party_Bank_Data")
    protected List<ReceivingPartyBankDataType> receivingPartyBankData;
    @XmlElement(name = "Receiving_Party_Credit_Card_Data")
    protected ReceivingPartyCreditCardDataType receivingPartyCreditCardData;
    @XmlElement(name = "Remittance_Data")
    protected List<RemittanceDataType> remittanceData;
    @XmlElement(name = "Payroll_Remittance_Data")
    protected List<PayrollRemittanceDataType> payrollRemittanceData;
    @XmlElement(name = "Integration_Field_Override_Data")
    protected List<DocumentFieldResultDataType> integrationFieldOverrideData;

    /**
     * Gets the value of the paymentGroupData property.
     * 
     * @return
     *     possible object is
     *     {@link PaymentGroupDataType }
     *     
     */
    public PaymentGroupDataType getPaymentGroupData() {
        return paymentGroupData;
    }

    /**
     * Sets the value of the paymentGroupData property.
     * 
     * @param value
     *     allowed object is
     *     {@link PaymentGroupDataType }
     *     
     */
    public void setPaymentGroupData(PaymentGroupDataType value) {
        this.paymentGroupData = value;
    }

    /**
     * Gets the value of the settlementRunReference property.
     * 
     * @return
     *     possible object is
     *     {@link UniqueIdentifierObjectType }
     *     
     */
    public UniqueIdentifierObjectType getSettlementRunReference() {
        return settlementRunReference;
    }

    /**
     * Sets the value of the settlementRunReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link UniqueIdentifierObjectType }
     *     
     */
    public void setSettlementRunReference(UniqueIdentifierObjectType value) {
        this.settlementRunReference = value;
    }

    /**
     * Gets the value of the paymentStatus property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getPaymentStatus() {
        return paymentStatus;
    }

    /**
     * Sets the value of the paymentStatus property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setPaymentStatus(String value) {
        this.paymentStatus = value;
    }

    /**
     * Gets the value of the paymentMemo property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getPaymentMemo() {
        return paymentMemo;
    }

    /**
     * Sets the value of the paymentMemo property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setPaymentMemo(String value) {
        this.paymentMemo = value;
    }

    /**
     * Gets the value of the paymentReferenceNumber property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getPaymentReferenceNumber() {
        return paymentReferenceNumber;
    }

    /**
     * Sets the value of the paymentReferenceNumber property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setPaymentReferenceNumber(String value) {
        this.paymentReferenceNumber = value;
    }

    /**
     * Gets the value of the paymentAmount property.
     * 
     * @return
     *     possible object is
     *     {@link BigDecimal }
     *     
     */
    public BigDecimal getPaymentAmount() {
        return paymentAmount;
    }

    /**
     * Sets the value of the paymentAmount property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigDecimal }
     *     
     */
    public void setPaymentAmount(BigDecimal value) {
        this.paymentAmount = value;
    }

    /**
     * Gets the value of the amountAsText property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getAmountAsText() {
        return amountAsText;
    }

    /**
     * Sets the value of the amountAsText property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setAmountAsText(String value) {
        this.amountAsText = value;
    }

    /**
     * Gets the value of the discountTaken property.
     * 
     * @return
     *     possible object is
     *     {@link BigDecimal }
     *     
     */
    public BigDecimal getDiscountTaken() {
        return discountTaken;
    }

    /**
     * Sets the value of the discountTaken property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigDecimal }
     *     
     */
    public void setDiscountTaken(BigDecimal value) {
        this.discountTaken = value;
    }

    /**
     * Gets the value of the currencyReference property.
     * 
     * @return
     *     possible object is
     *     {@link CurrencyObjectType }
     *     
     */
    public CurrencyObjectType getCurrencyReference() {
        return currencyReference;
    }

    /**
     * Sets the value of the currencyReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link CurrencyObjectType }
     *     
     */
    public void setCurrencyReference(CurrencyObjectType value) {
        this.currencyReference = value;
    }

    /**
     * Gets the value of the currencySymbol property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getCurrencySymbol() {
        return currencySymbol;
    }

    /**
     * Sets the value of the currencySymbol property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setCurrencySymbol(String value) {
        this.currencySymbol = value;
    }

    /**
     * Gets the value of the currencyDescription property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getCurrencyDescription() {
        return currencyDescription;
    }

    /**
     * Sets the value of the currencyDescription property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setCurrencyDescription(String value) {
        this.currencyDescription = value;
    }

    /**
     * Gets the value of the checkOrAdviceNumber property.
     * 
     * @return
     *     possible object is
     *     {@link BigDecimal }
     *     
     */
    public BigDecimal getCheckOrAdviceNumber() {
        return checkOrAdviceNumber;
    }

    /**
     * Sets the value of the checkOrAdviceNumber property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigDecimal }
     *     
     */
    public void setCheckOrAdviceNumber(BigDecimal value) {
        this.checkOrAdviceNumber = value;
    }

    /**
     * Gets the value of the checkNumber property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getCheckNumber() {
        return checkNumber;
    }

    /**
     * Sets the value of the checkNumber property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setCheckNumber(String value) {
        this.checkNumber = value;
    }

    /**
     * Gets the value of the prenoteFlag property.
     * This getter has been renamed from isPrenoteFlag() to getPrenoteFlag() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getPrenoteFlag() {
        return prenoteFlag;
    }

    /**
     * Sets the value of the prenoteFlag property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setPrenoteFlag(Boolean value) {
        this.prenoteFlag = value;
    }

    /**
     * Gets the value of the payrollPaymentDisplayOrder property.
     * 
     * @return
     *     possible object is
     *     {@link BigDecimal }
     *     
     */
    public BigDecimal getPayrollPaymentDisplayOrder() {
        return payrollPaymentDisplayOrder;
    }

    /**
     * Sets the value of the payrollPaymentDisplayOrder property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigDecimal }
     *     
     */
    public void setPayrollPaymentDisplayOrder(BigDecimal value) {
        this.payrollPaymentDisplayOrder = value;
    }

    /**
     * Gets the value of the handlingCodeReference property.
     * 
     * @return
     *     possible object is
     *     {@link PaymentHandlingInstructionObjectType }
     *     
     */
    public PaymentHandlingInstructionObjectType getHandlingCodeReference() {
        return handlingCodeReference;
    }

    /**
     * Sets the value of the handlingCodeReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link PaymentHandlingInstructionObjectType }
     *     
     */
    public void setHandlingCodeReference(PaymentHandlingInstructionObjectType value) {
        this.handlingCodeReference = value;
    }

    /**
     * Gets the value of the taxCodeReference property.
     * 
     * @return
     *     possible object is
     *     {@link TaxCodeObjectType }
     *     
     */
    public TaxCodeObjectType getTaxCodeReference() {
        return taxCodeReference;
    }

    /**
     * Sets the value of the taxCodeReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link TaxCodeObjectType }
     *     
     */
    public void setTaxCodeReference(TaxCodeObjectType value) {
        this.taxCodeReference = value;
    }

    /**
     * Gets the value of the companyReference property.
     * 
     * @return
     *     possible object is
     *     {@link CompanyObjectType }
     *     
     */
    public CompanyObjectType getCompanyReference() {
        return companyReference;
    }

    /**
     * Sets the value of the companyReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link CompanyObjectType }
     *     
     */
    public void setCompanyReference(CompanyObjectType value) {
        this.companyReference = value;
    }

    /**
     * Gets the value of the onBehalfOfCompanyReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the onBehalfOfCompanyReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getOnBehalfOfCompanyReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link CompanyObjectType }
     * 
     * 
     */
    public List<CompanyObjectType> getOnBehalfOfCompanyReference() {
        if (onBehalfOfCompanyReference == null) {
            onBehalfOfCompanyReference = new ArrayList<CompanyObjectType>();
        }
        return this.onBehalfOfCompanyReference;
    }

    /**
     * Gets the value of the originatingContactData property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the originatingContactData property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getOriginatingContactData().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link OriginatingPartyWWSDataType }
     * 
     * 
     */
    public List<OriginatingPartyWWSDataType> getOriginatingContactData() {
        if (originatingContactData == null) {
            originatingContactData = new ArrayList<OriginatingPartyWWSDataType>();
        }
        return this.originatingContactData;
    }

    /**
     * Gets the value of the originatingBankData property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the originatingBankData property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getOriginatingBankData().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link OriginatingPartyBankDataType }
     * 
     * 
     */
    public List<OriginatingPartyBankDataType> getOriginatingBankData() {
        if (originatingBankData == null) {
            originatingBankData = new ArrayList<OriginatingPartyBankDataType>();
        }
        return this.originatingBankData;
    }

    /**
     * Gets the value of the receivingPartyReference property.
     * 
     * @return
     *     possible object is
     *     {@link PayeeObjectType }
     *     
     */
    public PayeeObjectType getReceivingPartyReference() {
        return receivingPartyReference;
    }

    /**
     * Sets the value of the receivingPartyReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link PayeeObjectType }
     *     
     */
    public void setReceivingPartyReference(PayeeObjectType value) {
        this.receivingPartyReference = value;
    }

    /**
     * Gets the value of the receivingPartyContactData property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the receivingPartyContactData property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getReceivingPartyContactData().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ReceivingPartyWWSDataType }
     * 
     * 
     */
    public List<ReceivingPartyWWSDataType> getReceivingPartyContactData() {
        if (receivingPartyContactData == null) {
            receivingPartyContactData = new ArrayList<ReceivingPartyWWSDataType>();
        }
        return this.receivingPartyContactData;
    }

    /**
     * Gets the value of the receivingPartyBankData property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the receivingPartyBankData property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getReceivingPartyBankData().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ReceivingPartyBankDataType }
     * 
     * 
     */
    public List<ReceivingPartyBankDataType> getReceivingPartyBankData() {
        if (receivingPartyBankData == null) {
            receivingPartyBankData = new ArrayList<ReceivingPartyBankDataType>();
        }
        return this.receivingPartyBankData;
    }

    /**
     * Gets the value of the receivingPartyCreditCardData property.
     * 
     * @return
     *     possible object is
     *     {@link ReceivingPartyCreditCardDataType }
     *     
     */
    public ReceivingPartyCreditCardDataType getReceivingPartyCreditCardData() {
        return receivingPartyCreditCardData;
    }

    /**
     * Sets the value of the receivingPartyCreditCardData property.
     * 
     * @param value
     *     allowed object is
     *     {@link ReceivingPartyCreditCardDataType }
     *     
     */
    public void setReceivingPartyCreditCardData(ReceivingPartyCreditCardDataType value) {
        this.receivingPartyCreditCardData = value;
    }

    /**
     * Gets the value of the remittanceData property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the remittanceData property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getRemittanceData().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link RemittanceDataType }
     * 
     * 
     */
    public List<RemittanceDataType> getRemittanceData() {
        if (remittanceData == null) {
            remittanceData = new ArrayList<RemittanceDataType>();
        }
        return this.remittanceData;
    }

    /**
     * Gets the value of the payrollRemittanceData property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the payrollRemittanceData property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getPayrollRemittanceData().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link PayrollRemittanceDataType }
     * 
     * 
     */
    public List<PayrollRemittanceDataType> getPayrollRemittanceData() {
        if (payrollRemittanceData == null) {
            payrollRemittanceData = new ArrayList<PayrollRemittanceDataType>();
        }
        return this.payrollRemittanceData;
    }

    /**
     * Gets the value of the integrationFieldOverrideData property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the integrationFieldOverrideData property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getIntegrationFieldOverrideData().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link DocumentFieldResultDataType }
     * 
     * 
     */
    public List<DocumentFieldResultDataType> getIntegrationFieldOverrideData() {
        if (integrationFieldOverrideData == null) {
            integrationFieldOverrideData = new ArrayList<DocumentFieldResultDataType>();
        }
        return this.integrationFieldOverrideData;
    }

    /**
     * Sets the value of the onBehalfOfCompanyReference property.
     * 
     * @param onBehalfOfCompanyReference
     *     allowed object is
     *     {@link CompanyObjectType }
     *     
     */
    public void setOnBehalfOfCompanyReference(List<CompanyObjectType> onBehalfOfCompanyReference) {
        this.onBehalfOfCompanyReference = onBehalfOfCompanyReference;
    }

    /**
     * Sets the value of the originatingContactData property.
     * 
     * @param originatingContactData
     *     allowed object is
     *     {@link OriginatingPartyWWSDataType }
     *     
     */
    public void setOriginatingContactData(List<OriginatingPartyWWSDataType> originatingContactData) {
        this.originatingContactData = originatingContactData;
    }

    /**
     * Sets the value of the originatingBankData property.
     * 
     * @param originatingBankData
     *     allowed object is
     *     {@link OriginatingPartyBankDataType }
     *     
     */
    public void setOriginatingBankData(List<OriginatingPartyBankDataType> originatingBankData) {
        this.originatingBankData = originatingBankData;
    }

    /**
     * Sets the value of the receivingPartyContactData property.
     * 
     * @param receivingPartyContactData
     *     allowed object is
     *     {@link ReceivingPartyWWSDataType }
     *     
     */
    public void setReceivingPartyContactData(List<ReceivingPartyWWSDataType> receivingPartyContactData) {
        this.receivingPartyContactData = receivingPartyContactData;
    }

    /**
     * Sets the value of the receivingPartyBankData property.
     * 
     * @param receivingPartyBankData
     *     allowed object is
     *     {@link ReceivingPartyBankDataType }
     *     
     */
    public void setReceivingPartyBankData(List<ReceivingPartyBankDataType> receivingPartyBankData) {
        this.receivingPartyBankData = receivingPartyBankData;
    }

    /**
     * Sets the value of the remittanceData property.
     * 
     * @param remittanceData
     *     allowed object is
     *     {@link RemittanceDataType }
     *     
     */
    public void setRemittanceData(List<RemittanceDataType> remittanceData) {
        this.remittanceData = remittanceData;
    }

    /**
     * Sets the value of the payrollRemittanceData property.
     * 
     * @param payrollRemittanceData
     *     allowed object is
     *     {@link PayrollRemittanceDataType }
     *     
     */
    public void setPayrollRemittanceData(List<PayrollRemittanceDataType> payrollRemittanceData) {
        this.payrollRemittanceData = payrollRemittanceData;
    }

    /**
     * Sets the value of the integrationFieldOverrideData property.
     * 
     * @param integrationFieldOverrideData
     *     allowed object is
     *     {@link DocumentFieldResultDataType }
     *     
     */
    public void setIntegrationFieldOverrideData(List<DocumentFieldResultDataType> integrationFieldOverrideData) {
        this.integrationFieldOverrideData = integrationFieldOverrideData;
    }

}
